/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.intellij.openapi.project.Project;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Device {
    @NotNull
    private final String myName;
    private final boolean myValid;
    @Nullable
    private final String myValidityReason;
    @NotNull
    private final Key myKey;
    @Nullable
    private final Instant myConnectionTime;
    @NotNull
    private final AndroidDevice myAndroidDevice;

    Device(@NotNull Builder builder2) {
        if (builder2 == null) {
            Device.$$$reportNull$$$0(0);
        }
        assert (builder2.myName != null);
        this.myName = builder2.myName;
        this.myValid = builder2.myValid;
        this.myValidityReason = builder2.myValidityReason;
        assert (builder2.myKey != null);
        this.myKey = builder2.myKey;
        this.myConnectionTime = builder2.myConnectionTime;
        assert (builder2.myAndroidDevice != null);
        this.myAndroidDevice = builder2.myAndroidDevice;
    }

    @NotNull
    abstract Icon getIcon();

    abstract boolean isConnected();

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            Device.$$$reportNull$$$0(1);
        }
        return string;
    }

    final boolean isValid() {
        return this.myValid;
    }

    @Nullable
    final String getValidityReason() {
        return this.myValidityReason;
    }

    @Nullable
    abstract Snapshot getSnapshot();

    @NotNull
    public final Key getKey() {
        Key key = this.myKey;
        if (key == null) {
            Device.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    final Instant getConnectionTime() {
        return this.myConnectionTime;
    }

    @NotNull
    final AndroidDevice getAndroidDevice() {
        AndroidDevice androidDevice = this.myAndroidDevice;
        if (androidDevice == null) {
            Device.$$$reportNull$$$0(3);
        }
        return androidDevice;
    }

    @NotNull
    abstract Future<AndroidVersion> getAndroidVersion();

    final boolean isRunning(@NotNull String appPackage) {
        if (appPackage == null) {
            Device.$$$reportNull$$$0(4);
        }
        if (!this.isConnected()) {
            return false;
        }
        IDevice device = this.getDdmlibDevice();
        assert (device != null);
        if (!device.isOnline()) {
            return false;
        }
        return !Deployable.searchClientsForPackage(device, appPackage).isEmpty();
    }

    @Nullable
    final IDevice getDdmlibDevice() {
        AndroidDevice device = this.getAndroidDevice();
        if (!device.isRunning()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    abstract void addTo(@NotNull DeviceFutures var1, @NotNull Project var2);

    @NotNull
    public final String toString() {
        String string = this.myName;
        if (string == null) {
            Device.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/Device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/Device";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDevice";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRunning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class Builder {
        @Nullable
        String myName;
        boolean myValid = true;
        @Nullable
        String myValidityReason;
        @Nullable
        Key myKey;
        @Nullable
        Instant myConnectionTime;
        @Nullable
        AndroidDevice myAndroidDevice;

        Builder() {
        }

        @NotNull
        abstract Device build();
    }
}

