/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevicesTask
implements AsyncSupplier<List<ConnectedDevice>> {
    @NotNull
    private final AndroidDebugBridge myAndroidDebugBridge;
    private final boolean mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Function<IDevice, AndroidDevice> myAndroidDeviceFactory;

    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, boolean selectDeviceSnapshotComboBoxSnapshotsEnabled, @Nullable LaunchCompatibilityChecker checker) {
        if (androidDebugBridge == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(0);
        }
        this(androidDebugBridge, selectDeviceSnapshotComboBoxSnapshotsEnabled, checker, AppExecutorUtil.getAppExecutorService(), device -> new ConnectedAndroidDevice((IDevice)device, null));
    }

    @VisibleForTesting
    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, boolean selectDeviceSnapshotComboBoxSnapshotsEnabled, @Nullable LaunchCompatibilityChecker checker, @NotNull Executor executor, @NotNull Function<IDevice, AndroidDevice> androidDeviceFactory) {
        if (androidDebugBridge == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(2);
        }
        if (androidDeviceFactory == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(3);
        }
        this.myAndroidDebugBridge = androidDebugBridge;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myChecker = checker;
        this.myExecutor = executor;
        this.myAndroidDeviceFactory = androidDeviceFactory;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ConnectedDevice>> get() {
        ListenableFuture<Collection<IDevice>> devices2 = this.myAndroidDebugBridge.getConnectedDevices();
        ListenableFuture listenableFuture = Futures.transformAsync(devices2, this::newConnectedDevices, (Executor)this.myExecutor);
        if (listenableFuture == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(4);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<List<ConnectedDevice>> newConnectedDevices(@NotNull Collection<IDevice> devices2) {
        if (devices2 == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(5);
        }
        Iterable futures = devices2.stream().filter(IDevice::isOnline).map(this::newConnectedDevice).collect(Collectors.toList());
        ListenableFuture listenableFuture = Futures.successfulAsList((Iterable)futures);
        if (listenableFuture == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<ConnectedDevice> newConnectedDevice(@NotNull IDevice ddmlibDevice) {
        if (ddmlibDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(7);
        }
        if (this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled) {
            ListenableFuture<String> idFuture = this.myAndroidDebugBridge.getVirtualDeviceId(ddmlibDevice);
            ListenableFuture listenableFuture = Futures.transform(idFuture, id -> this.newConnectedDevice(ddmlibDevice, (String)id), (Executor)this.myExecutor);
            if (listenableFuture == null) {
                ConnectedDevicesTask.$$$reportNull$$$0(8);
            }
            return listenableFuture;
        }
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.newConnectedDevice(ddmlibDevice, ""));
        if (listenableFuture == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @NotNull
    private ConnectedDevice newConnectedDevice(@NotNull IDevice ddmlibDevice, @NotNull String id) {
        if (ddmlibDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(10);
        }
        if (id == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(11);
        }
        AndroidDevice androidDevice = this.myAndroidDeviceFactory.apply(ddmlibDevice);
        ConnectedDevice.Builder builder2 = new ConnectedDevice.Builder().setName(ddmlibDevice.isEmulator() ? "Virtual Device" : "Physical Device").setKey(this.newKey(ddmlibDevice, id)).setAndroidDevice(androidDevice);
        if (this.myChecker == null) {
            ConnectedDevice connectedDevice = builder2.build();
            if (connectedDevice == null) {
                ConnectedDevicesTask.$$$reportNull$$$0(12);
            }
            return connectedDevice;
        }
        LaunchCompatibility compatibility = this.myChecker.validate(androidDevice);
        ConnectedDevice connectedDevice = builder2.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
        if (connectedDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(13);
        }
        return connectedDevice;
    }

    @NotNull
    private Key newKey(@NotNull IDevice connectedDevice, @NotNull String id) {
        if (connectedDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(14);
        }
        if (id == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(15);
        }
        if (!connectedDevice.isEmulator()) {
            return new Key(connectedDevice.getSerialNumber());
        }
        String virtualDeviceName = connectedDevice.getAvdName();
        if (virtualDeviceName == null || virtualDeviceName.equals("<build>")) {
            return new Key(connectedDevice.getSerialNumber());
        }
        return new Key(this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled ? id : virtualDeviceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebugBridge";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDeviceFactory";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/ConnectedDevicesTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ddmlibDevice";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/ConnectedDevicesTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newConnectedDevices";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newConnectedDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newConnectedDevices";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newConnectedDevice";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

