/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class DeviceVersion
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, Future<AndroidVersion>> myVersions = new ConcurrentHashMap<IDevice, Future<AndroidVersion>>();

    public DeviceVersion() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @NotNull
    public Future<AndroidVersion> get(@NotNull IDevice iDevice) {
        if (iDevice == null) {
            DeviceVersion.$$$reportNull$$$0(0);
        }
        Future future2 = this.myVersions.compute(iDevice, (d, f) -> {
            if (f != null && f.isDone()) {
                try {
                    AndroidVersion version2 = (AndroidVersion)f.get();
                    if (version2 != AndroidVersion.DEFAULT) {
                        return f;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    String buildApi = d.getProperty("ro.build.version.sdk");
                    if (buildApi == null) {
                        return AndroidVersion.DEFAULT;
                    }
                    int api = Integer.parseInt(buildApi);
                    String codeName = d.getProperty("ro.build.version.codename");
                    return new AndroidVersion(api, codeName);
                }
                catch (Exception e) {
                    return AndroidVersion.DEFAULT;
                }
            });
        });
        if (future2 == null) {
            DeviceVersion.$$$reportNull$$$0(1);
        }
        return future2;
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected() && bridge.hasInitialDeviceList()) {
            this.myVersions.keySet().retainAll(Arrays.asList(bridge.getDevices()));
        } else {
            this.myVersions.clear();
        }
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        this.myVersions.remove(device);
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployable/DeviceVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployable/DeviceVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

