/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.deployable.Process;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Device {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^package:(\\S+)\\s+.*");
    @NotNull
    private final ExecutorService myResolverExecutor;
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final Map<Integer, Process> myPidToProcess;
    @NotNull
    private final Map<String, Future<Void>> myResolutions;

    Device(@NotNull ExecutorService resolverExecutor, @NotNull IDevice device) {
        if (resolverExecutor == null) {
            Device.$$$reportNull$$$0(0);
        }
        if (device == null) {
            Device.$$$reportNull$$$0(1);
        }
        this.myPidToProcess = new ConcurrentHashMap<Integer, Process>();
        this.myResolutions = new ConcurrentHashMap<String, Future<Void>>();
        this.myResolverExecutor = resolverExecutor;
        this.myIDevice = device;
    }

    @NotNull
    public List<Client> findClientWithApplicationId(@NotNull String applicationId2) {
        if (applicationId2 == null) {
            Device.$$$reportNull$$$0(2);
        }
        if (this.myIDevice.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            List<Client> list = Arrays.stream(this.myIDevice.getClients()).filter(client -> applicationId2.equals(client.getClientData().getPackageName())).collect(Collectors.toList());
            if (list == null) {
                Device.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (this.isLegacyDevice()) {
            this.myResolutions.computeIfAbsent(applicationId2, ignored -> this.resolveLegacyPid(applicationId2));
        }
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Process process2 : this.myPidToProcess.values()) {
            if (!process2.containsApplicationId(applicationId2)) continue;
            clients.add(process2.getClient());
        }
        if (clients.isEmpty()) {
            for (Client client2 : this.myIDevice.getClients()) {
                if (!applicationId2.equals(client2.getClientData().getClientDescription()) && !applicationId2.equals(client2.getClientData().getPackageName())) continue;
                clients.add(client2);
            }
        }
        ArrayList<Client> arrayList = clients;
        if (arrayList == null) {
            Device.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    synchronized void refresh() {
        if (this.myIDevice.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            return;
        }
        HashMap<Integer, Client> clients = new HashMap<Integer, Client>(this.myIDevice.getClients().length);
        for (Client client : this.myIDevice.getClients()) {
            clients.put(client.getClientData().getPid(), client);
        }
        this.myPidToProcess.keySet().retainAll(clients.keySet());
        this.myPidToProcess.keySet().forEach(pid -> {
            Client client = (Client)clients.get(pid);
            if (client != null) {
                this.myPidToProcess.get(pid).setClient(client);
            }
        });
        HashSet addedPids = new HashSet(clients.keySet());
        addedPids.removeAll(this.myPidToProcess.keySet());
        addedPids.forEach(pid -> {
            Client client = (Client)clients.get(pid);
            Process process2 = new Process(client);
            if (!this.isLegacyDevice()) {
                this.resolveApplicationId(process2);
            }
            this.myPidToProcess.put((Integer)pid, process2);
        });
        if (this.isLegacyDevice() && !addedPids.isEmpty()) {
            this.myResolutions.values().removeIf(resolution -> {
                resolution.cancel(true);
                return true;
            });
        }
    }

    private boolean isLegacyDevice() {
        return this.myIDevice.getVersion().getFeatureLevel() < 26;
    }

    private void resolveApplicationId(@NotNull Process process2) {
        if (process2 == null) {
            Device.$$$reportNull$$$0(5);
        }
        this.myResolverExecutor.execute(() -> {
            String command = String.format(Locale.US, "stat -c %%u /proc/%d | xargs -n 1 cmd package list packages --uid", process2.getPid());
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            try {
                this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                Logger.getInstance(Device.class).warn("Could not resolve application ID", e);
                return;
            }
            String output = receiver.getOutput();
            if (output.isEmpty()) {
                return;
            }
            Matcher m = PACKAGE_NAME_PATTERN.matcher(output);
            while (m.find()) {
                process2.addApplicationId(m.group(1));
            }
        });
    }

    @NotNull
    private Future<Void> resolveLegacyPid(@NotNull String applicationId2) {
        if (applicationId2 == null) {
            Device.$$$reportNull$$$0(6);
        }
        Future<Void> future2 = this.myResolverExecutor.submit(() -> {
            String command = String.format("uid=`run-as %s whoami` && for pid in `run-as %s ps | grep -o \"$uid[[:space:]]\\{1,\\}[[:digit:]]\\{1,\\}\" | tr -s ' ' ' ' | cut -d ' ' -f2`; do   if [[ `run-as %s readlink /proc/$pid/exe` == /system/bin/app_process* ]]; then     echo $pid;   fi; done", applicationId2, applicationId2, applicationId2);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            if (output.isEmpty()) {
                return null;
            }
            String[] lines = output.split("\n");
            try {
                for (String line : lines) {
                    int pid = Integer.parseInt(line.trim());
                    this.myPidToProcess.computeIfPresent(pid, (ignored, process2) -> {
                        process2.addApplicationId(applicationId2);
                        return process2;
                    });
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        });
        if (future2 == null) {
            Device.$$$reportNull$$$0(7);
        }
        return future2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployable/Device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployable/Device";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClientWithApplicationId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLegacyPid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClientWithApplicationId";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveApplicationId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveLegacyPid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

