/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActivityLocatorUtils {
    public static boolean containsAction(@NotNull Element filter2, @NotNull String name) {
        if (filter2 == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(1);
        }
        for (Node action2 = filter2.getFirstChild(); action2 != null; action2 = action2.getNextSibling()) {
            if (action2.getNodeType() != 1 || !"action".equals(action2.getNodeName()) || !name.equals(((Element)action2).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull Element filter2, @NotNull String name) {
        if (filter2 == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(2);
        }
        if (name == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(3);
        }
        for (Node action2 = filter2.getFirstChild(); action2 != null; action2 = action2.getNextSibling()) {
            if (action2.getNodeType() != 1 || !"category".equals(action2.getNodeName()) || !name.equals(((Element)action2).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLauncherIntent(@NotNull DefaultActivityLocator.ActivityWrapper activity) {
        if (activity == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(4);
        }
        return activity.hasAction("android.intent.action.MAIN") && (activity.hasCategory("android.intent.category.LAUNCHER") || activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER"));
    }

    @Nullable
    public static String getQualifiedName(@NotNull Element component3) {
        Attr nameNode;
        if (component3 == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(5);
        }
        if ((nameNode = component3.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null) {
            return null;
        }
        String name = nameNode.getValue();
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        Element root2 = component3.getOwnerDocument().getDocumentElement();
        Attr pkgNode = root2.getAttributeNode("package");
        if (pkgNode != null) {
            String pkg = pkgNode.getValue();
            return pkg + (dotIndex == -1 ? "." : "") + name;
        }
        return name;
    }

    @Nullable
    public static String getQualifiedName(@NotNull ActivityAlias alias) {
        if (alias == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String name = alias.getName().getStringValue();
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        String pkg = null;
        DomElement parent = alias.getParent();
        if (parent instanceof Application && (parent = parent.getParent()) instanceof Manifest) {
            Manifest manifest = (Manifest)parent;
            pkg = manifest.getPackage().getStringValue();
        }
        return pkg == null ? name : pkg + (dotIndex == -1 ? "." : "") + name;
    }

    @Nullable
    public static String getQualifiedName(@NotNull Activity activity) {
        if (activity == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass psiClass = (PsiClass)activity.getActivityClass().getValue();
        if (psiClass == null) {
            Module module = activity.getModule();
            if (module != null && ApkFacet.getInstance(module) != null) {
                return activity.getActivityClass().getStringValue();
            }
            return null;
        }
        return ActivityLocatorUtils.getQualifiedActivityName(psiClass);
    }

    @Nullable
    public static String getQualifiedActivityName(@NotNull PsiClass c) {
        if (c == null) {
            ActivityLocatorUtils.$$$reportNull$$$0(8);
        }
        return PackageClassConverter.getQualifiedName(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/activity/ActivityLocatorUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsCategory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "containsLauncherIntent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedActivityName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

