/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.SwapInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    @NotNull
    @VisibleForTesting
    final AndroidVersion myMinSdkVersion;
    @NotNull
    private final IAndroidTarget myProjectTarget;
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    @Nullable
    private final AndroidRunConfigurationBase myAndroidRunConfigurationBase;
    @Nullable
    private final Set<String> mySupportedAbis;

    public LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget target, @NotNull AndroidFacet facet2, @Nullable ExecutionEnvironment environment, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(0);
        }
        if (target == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(2);
        }
        assert (environment == null && androidRunConfigurationBase == null || environment != null && androidRunConfigurationBase != null);
        this.myMinSdkVersion = minSdkVersion2;
        this.myProjectTarget = target;
        this.myEnvironment = environment;
        this.myAndroidRunConfigurationBase = androidRunConfigurationBase;
        this.myFacet = facet2;
        this.mySupportedAbis = supportedAbis;
    }

    @NotNull
    private EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeauters() {
        if (LaunchUtils.isWatchFeatureRequired(this.myFacet)) {
            EnumSet<IDevice.HardwareFeature> enumSet = EnumSet.of(IDevice.HardwareFeature.WATCH);
            if (enumSet == null) {
                LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(3);
            }
            return enumSet;
        }
        EnumSet<IDevice.HardwareFeature> enumSet = EnumSet.noneOf(IDevice.HardwareFeature.class);
        if (enumSet == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(4);
        }
        return enumSet;
    }

    @Override
    @Slow
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        SwapInfo swapInfo;
        if (device == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(5);
        }
        LaunchCompatibility launchCompatibility = LaunchCompatibility.YES;
        if (this.myEnvironment != null && this.myAndroidRunConfigurationBase != null && (swapInfo = (SwapInfo)this.myEnvironment.getUserData(SwapInfo.SWAP_INFO_KEY)) != null) {
            if (device.getVersion().compareTo(26, null) < 0) {
                launchCompatibility = new LaunchCompatibility(ThreeState.NO, "The device needs to be running Oreo or newer.");
            } else if (!device.isRunning()) {
                launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Please ensure the target device/emulator is running.");
            } else {
                try {
                    ApplicationIdProvider applicationIdProvider = this.myAndroidRunConfigurationBase.getApplicationIdProvider(this.myFacet);
                    Client client = ((IDevice)device.getLaunchedDevice().get()).getClient(applicationIdProvider.getPackageName());
                    if (client == null) {
                        launchCompatibility = new LaunchCompatibility(ThreeState.NO, "App not running on device. Please first install/run the app on the target device/emulator.");
                    }
                }
                catch (ApkProvisionException | InterruptedException | ExecutionException e) {
                    launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Could not determine if device is compatible.");
                }
            }
        }
        LaunchCompatibility launchCompatibility2 = launchCompatibility.combine(device.canRun(this.myMinSdkVersion, this.myProjectTarget, this.getRequiredHardwareFeauters(), this.mySupportedAbis));
        if (launchCompatibility2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(6);
        }
        return launchCompatibility2;
    }

    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet2, @Nullable ExecutionEnvironment env, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase) {
        if (facet2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(7);
        }
        AndroidVersion minSdkVersion2 = LaunchCompatibilityCheckerImpl.getMinSdkVersion(facet2);
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet2.getModule().getName());
        }
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        Set supportedAbis = androidModuleModel != null ? androidModuleModel.getSelectedVariant().getMainArtifact().getAbiFilters() : null;
        return new LaunchCompatibilityCheckerImpl(minSdkVersion2, platform.getTarget(), facet2, env, androidRunConfigurationBase, supportedAbis);
    }

    private static AndroidVersion getMinSdkVersion(@NotNull AndroidFacet facet2) {
        ListenableFuture<AndroidVersion> minSdkVersionFuture;
        if (facet2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(8);
        }
        if ((minSdkVersionFuture = AndroidModuleInfo.getInstance(facet2).getRuntimeMinSdkVersion()).isDone()) {
            try {
                return (AndroidVersion)minSdkVersionFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return AndroidVersion.DEFAULT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdkVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredHardwareFeauters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMinSdkVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

