/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidDevice;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibility {
    @NonNls
    private static final String GOOGLE_APIS_TARGET_NAME = "Google APIs";
    private final ThreeState myCompatible;
    private final String myReason;
    public static final LaunchCompatibility YES = new LaunchCompatibility(ThreeState.YES, null);

    public LaunchCompatibility(ThreeState compatible, @Nullable String reason) {
        this.myCompatible = compatible;
        this.myReason = reason;
    }

    public LaunchCompatibility combine(@NotNull LaunchCompatibility other) {
        if (other == null) {
            LaunchCompatibility.$$$reportNull$$$0(0);
        }
        if (this.myCompatible == ThreeState.NO) {
            return this;
        }
        if (other.myCompatible == ThreeState.NO) {
            return other;
        }
        if (this.myCompatible == ThreeState.UNSURE) {
            return this;
        }
        return other;
    }

    public ThreeState isCompatible() {
        return this.myCompatible;
    }

    @Nullable
    public String getReason() {
        return this.myReason;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("compatible", (Object)this.myCompatible).add("reason", (Object)this.myReason).toString();
    }

    public boolean equals(Object o) {
        return o instanceof LaunchCompatibility && this.myCompatible == ((LaunchCompatibility)o).myCompatible && Objects.equal((Object)this.myReason, (Object)((LaunchCompatibility)o).myReason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCompatible, this.myReason});
    }

    @NotNull
    public static LaunchCompatibility canRunOnDevice(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis, @NotNull AndroidDevice device) {
        AndroidVersion deviceVersion;
        if (minSdkVersion2 == null) {
            LaunchCompatibility.$$$reportNull$$$0(1);
        }
        if (projectTarget == null) {
            LaunchCompatibility.$$$reportNull$$$0(2);
        }
        if (requiredFeatures == null) {
            LaunchCompatibility.$$$reportNull$$$0(3);
        }
        if (device == null) {
            LaunchCompatibility.$$$reportNull$$$0(4);
        }
        if (!(deviceVersion = device.getVersion()).equals((Object)AndroidVersion.DEFAULT) && !deviceVersion.canRun(minSdkVersion2)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion2, deviceVersion, minSdkVersion2.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        for (IDevice.HardwareFeature hardwareFeature : requiredFeatures) {
            if (device.supportsFeature(hardwareFeature)) continue;
            return new LaunchCompatibility(ThreeState.NO, "missing feature: " + hardwareFeature);
        }
        if (device.supportsFeature(IDevice.HardwareFeature.WATCH) && !requiredFeatures.contains(IDevice.HardwareFeature.WATCH)) {
            return new LaunchCompatibility(ThreeState.NO, "missing uses-feature watch, non-watch apks cannot be launched on a watch");
        }
        if (supportedAbis != null) {
            LinkedHashSet<String> deviceAbis = new LinkedHashSet<String>();
            for (Abi abi : device.getAbis()) {
                deviceAbis.add(abi.toString());
            }
            if (!supportedAbis.isEmpty() && Sets.intersection(supportedAbis, deviceAbis).isEmpty()) {
                return new LaunchCompatibility(ThreeState.NO, "Device supports " + Joiner.on((String)", ").join(deviceAbis) + ", but APK only supports " + Joiner.on((String)", ").join(supportedAbis));
            }
        }
        if (projectTarget.isPlatform()) {
            LaunchCompatibility launchCompatibility = YES;
            if (launchCompatibility == null) {
                LaunchCompatibility.$$$reportNull$$$0(5);
            }
            return launchCompatibility;
        }
        List additionalLibs = projectTarget.getAdditionalLibraries();
        if (additionalLibs.isEmpty()) {
            LaunchCompatibility launchCompatibility = YES;
            if (launchCompatibility == null) {
                LaunchCompatibility.$$$reportNull$$$0(6);
            }
            return launchCompatibility;
        }
        String string = projectTarget.getName();
        if (GOOGLE_APIS_TARGET_NAME.equals(string)) {
            LaunchCompatibility launchCompatibility = YES;
            if (launchCompatibility == null) {
                LaunchCompatibility.$$$reportNull$$$0(7);
            }
            return launchCompatibility;
        }
        return new LaunchCompatibility(ThreeState.UNSURE, "unsure if device supports addon: " + string);
    }

    private static LaunchCompatibility isCompatibleAddonAvd(IAndroidTarget projectTarget, ISystemImage image) {
        if (!StringUtil.equals((CharSequence)projectTarget.getVendor(), (CharSequence)image.getAddonVendor().getDisplay())) {
            String reason = String.format("AVD vendor (%1$s) != AVD target (%2$s)", image.getAddonVendor().getDisplay(), projectTarget.getVendor());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        if (!StringUtil.equals((CharSequence)projectTarget.getName(), (CharSequence)image.getTag().getDisplay())) {
            String reason = String.format("AVD target name (%1$s) != Project target name (%2$s)", image.getTag().getDisplay(), projectTarget.getName());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return YES;
    }

    @NotNull
    public static LaunchCompatibility canRunOnAvd(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull ISystemImage image) {
        AndroidVersion avdVersion;
        if (minSdkVersion2 == null) {
            LaunchCompatibility.$$$reportNull$$$0(8);
        }
        if (projectTarget == null) {
            LaunchCompatibility.$$$reportNull$$$0(9);
        }
        if (image == null) {
            LaunchCompatibility.$$$reportNull$$$0(10);
        }
        if (!(avdVersion = image.getAndroidVersion()).canRun(minSdkVersion2)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion2, avdVersion, minSdkVersion2.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        LaunchCompatibility launchCompatibility = projectTarget.isPlatform() ? YES : LaunchCompatibility.isCompatibleAddonAvd(projectTarget, image);
        if (launchCompatibility == null) {
            LaunchCompatibility.$$$reportNull$$$0(11);
        }
        return launchCompatibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdkVersion";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredFeatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/LaunchCompatibility";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/LaunchCompatibility";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "canRunOnDevice";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "canRunOnAvd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRunOnDevice";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRunOnAvd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

