/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ApkProvisionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProviderUtil {
    private static final Logger LOG = Logger.getInstance(ApkProviderUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String computePackageName(@NotNull AndroidFacet facet2) throws ApkProvisionException {
        if (facet2 == null) {
            ApkProviderUtil.$$$reportNull$$$0(0);
        }
        if (facet2.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            String string = facet2.getProperties().CUSTOM_MANIFEST_PACKAGE;
            if (string == null) {
                ApkProviderUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (facet2.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
            Manifest manifest;
            VirtualFile manifestVFile;
            Pair<File, String> pair;
            LocalFileSystem.getInstance().refresh(false);
            File manifestCopy = null;
            try {
                pair = ApkProviderUtil.getCopyOfCompilerManifestFile(facet2);
            }
            catch (IOException e) {
                throw new ApkProvisionException("Could not compute package name because of I/O error: " + e.getMessage(), e);
            }
            manifestCopy = pair != null ? (File)pair.getFirst() : null;
            VirtualFile virtualFile = manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(manifestCopy) : null;
            if (manifestVFile != null) {
                manifestVFile.refresh(false, false);
                manifest = AndroidUtils.loadDomElement(facet2.getModule(), manifestVFile, Manifest.class);
            } else {
                manifest = null;
            }
            final String manifestLocalPath = pair != null ? (String)pair.getSecond() : null;
            Module module = facet2.getModule();
            final String moduleName2 = module.getName();
            if (manifest == null) {
                throw new ApkProvisionException("Cannot find AndroidManifest.xml file for module " + moduleName2);
            }
            String string = (String)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<String, ApkProvisionException>(){

                public String compute() throws ApkProvisionException {
                    GenericAttributeValue<String> packageAttrValue = manifest.getPackage();
                    String aPackage = (String)packageAttrValue.getValue();
                    if (aPackage == null || aPackage.isEmpty()) {
                        throw new ApkProvisionException("[" + moduleName2 + "] Main package is not specified in file " + manifestLocalPath);
                    }
                    return aPackage;
                }
            });
            String string2 = string;
            if (string2 == null) {
                ApkProviderUtil.$$$reportNull$$$0(2);
            }
            return string2;
            finally {
                if (manifestCopy != null) {
                    FileUtil.delete((File)manifestCopy.getParentFile());
                }
            }
        }
        String pkg = AndroidModuleInfo.getInstance(facet2).getPackage();
        if (pkg == null || pkg.isEmpty()) {
            throw new ApkProvisionException("[" + facet2.getModule().getName() + "] Unable to obtain main package from manifest.");
        }
        String string = pkg;
        if (string == null) {
            ApkProviderUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static Pair<File, String> getCopyOfCompilerManifestFile(@NotNull AndroidFacet facet2) throws IOException {
        VirtualFile manifestFile;
        if (facet2 == null) {
            ApkProviderUtil.$$$reportNull$$$0(4);
        }
        if ((manifestFile = AndroidRootUtil.getCustomManifestFileForCompiler(facet2)) == null) {
            return null;
        }
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)"android_manifest_file_for_execution", (String)"tmp");
            File manifestCopy = new File(tmpDir, manifestFile.getName());
            FileUtil.copy((File)new File(manifestFile.getPath()), (File)manifestCopy);
            return Pair.create((Object)manifestCopy, (Object)PathUtil.getLocalPath((VirtualFile)manifestFile));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            if (tmpDir != null) {
                FileUtil.delete((File)tmpDir);
            }
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/ApkProviderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/ApkProviderUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computePackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computePackageName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCopyOfCompilerManifestFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

