/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.TextEmitter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class AndroidLogcatOutputCapture
implements AutoCloseable {
    private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
    private static final Logger LOG = Logger.getInstance(AndroidLogcatOutputCapture.class);
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<IDevice, AndroidLogcatService.LogcatListener> myLogListeners;
    @NotNull
    private final Object myLock;
    @NotNull
    private final TextEmitter myTextEmitter;

    public AndroidLogcatOutputCapture(@NotNull TextEmitter textEmitter) {
        if (textEmitter == null) {
            AndroidLogcatOutputCapture.$$$reportNull$$$0(0);
        }
        this.myLogListeners = new HashMap<IDevice, AndroidLogcatService.LogcatListener>();
        this.myLock = new Object();
        this.myTextEmitter = textEmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(@NotNull IDevice device, int pid, @NotNull String applicationId2) {
        AndroidLogcatService.LogcatListener previousListener;
        if (device == null) {
            AndroidLogcatOutputCapture.$$$reportNull$$$0(1);
        }
        if (applicationId2 == null) {
            AndroidLogcatOutputCapture.$$$reportNull$$$0(2);
        }
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isRunOutputEnabled()) {
            return;
        }
        LOG.info(String.format("startCapture(\"%s\")", device.getName()));
        MyLogcatListener logListener = new MyLogcatListener(applicationId2, pid, device, this.myTextEmitter);
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.put(device, logListener);
            MyLogcatListener.setShowDeviceName(this.myLogListeners.size() > 1);
        }
        if (previousListener != null) {
            LOG.warn(String.format("The device \"%s\" already has a registered logcat listener for application \"%s\". Removing it", device.getName(), applicationId2));
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture(@NotNull IDevice device) {
        AndroidLogcatService.LogcatListener previousListener;
        if (device == null) {
            AndroidLogcatOutputCapture.$$$reportNull$$$0(3);
        }
        LOG.info(String.format("stopCapture(\"%s\")", device.getName()));
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.remove(device);
            MyLogcatListener.setShowDeviceName(this.myLogListeners.size() > 1);
        }
        if (previousListener != null) {
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>> listeners;
        LOG.info("stopAll()");
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            listeners = new ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>>(this.myLogListeners.entrySet());
            this.myLogListeners.clear();
            MyLogcatListener.setShowDeviceName(false);
        }
        for (Map.Entry entry : listeners) {
            AndroidLogcatService.getInstance().removeListener((IDevice)entry.getKey(), (AndroidLogcatService.LogcatListener)entry.getValue());
        }
    }

    @Override
    public void close() {
        this.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEmitter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/AndroidLogcatOutputCapture";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startCapture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "stopCapture";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyLogcatListener
    extends ApplicationLogListener {
        private static AtomicBoolean ourShowDeviceName = new AtomicBoolean(false);
        private final AndroidLogcatFormatter myFormatter;
        private final IShellEnabledDevice myDevice;
        private final AtomicBoolean myIsFirstMessage;
        private final TextEmitter myTextEmitter;

        private MyLogcatListener(@NotNull String packageName, int pid, @NotNull IDevice device, @NotNull TextEmitter emitter) {
            if (packageName == null) {
                MyLogcatListener.$$$reportNull$$$0(0);
            }
            if (device == null) {
                MyLogcatListener.$$$reportNull$$$0(1);
            }
            if (emitter == null) {
                MyLogcatListener.$$$reportNull$$$0(2);
            }
            super(packageName, pid);
            this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
            this.myDevice = device;
            this.myIsFirstMessage = new AtomicBoolean(true);
            this.myTextEmitter = emitter;
        }

        public static void setShowDeviceName(boolean showDeviceName) {
            ourShowDeviceName.set(showDeviceName);
        }

        @Override
        protected String formatLogLine(@NotNull LogCatMessage line) {
            if (line == null) {
                MyLogcatListener.$$$reportNull$$$0(3);
            }
            String message2 = this.myFormatter.formatMessage(SIMPLE_FORMAT, line.getHeader(), line.getMessage());
            if (ourShowDeviceName.get()) {
                return "[" + this.myDevice.getName() + "]: " + message2;
            }
            return message2;
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message2, @NotNull Key key) {
            if (message2 == null) {
                MyLogcatListener.$$$reportNull$$$0(4);
            }
            if (key == null) {
                MyLogcatListener.$$$reportNull$$$0(5);
            }
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myTextEmitter.emit("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myTextEmitter.emit(message2, key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emitter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/AndroidLogcatOutputCapture$MyLogcatListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatLogLine";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

