/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.update;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.FtsOptionsBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SchemaDiffUtil {
    public static boolean isFieldStructureTheSame(@NotNull FieldBundle oldField, @NotNull FieldBundle newField) {
        if (oldField == null) {
            SchemaDiffUtil.$$$reportNull$$$0(0);
        }
        if (newField == null) {
            SchemaDiffUtil.$$$reportNull$$$0(1);
        }
        return oldField.isNonNull() == newField.isNonNull() && Objects.equals(oldField.getAffinity(), newField.getAffinity()) && Objects.equals(oldField.getDefaultValue(), newField.getDefaultValue());
    }

    public static boolean isTableStructureTheSame(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(2);
        }
        if (newEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(3);
        }
        if (!SchemaDiffUtil.isTableTypeTheSame(oldEntity, newEntity)) {
            return false;
        }
        if (!oldEntity.getPrimaryKey().isSchemaEqual(newEntity.getPrimaryKey())) {
            return false;
        }
        return SchemaDiffUtil.tablesHaveSameColumns(oldEntity, newEntity) && SchemaDiffUtil.tablesHaveSameForeignKeyConstraints(oldEntity, newEntity) && SchemaDiffUtil.tablesHaveSameIndices(oldEntity, newEntity);
    }

    public static boolean isTableTypeTheSame(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(4);
        }
        if (newEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(5);
        }
        return oldEntity instanceof FtsEntityBundle == newEntity instanceof FtsEntityBundle;
    }

    public static boolean tablesHaveSameColumns(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(6);
        }
        if (newEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(7);
        }
        Map<String, FieldBundle> oldEntityFields = oldEntity.getFieldsByColumnName();
        Map<String, FieldBundle> newEntityFields = newEntity.getFieldsByColumnName();
        ArrayList<FieldBundle> matchedFields = new ArrayList<FieldBundle>();
        if (oldEntityFields.size() != newEntityFields.size()) {
            return false;
        }
        for (Map.Entry<String, FieldBundle> oldFieldEntry : oldEntityFields.entrySet()) {
            FieldBundle newField = newEntityFields.get(oldFieldEntry.getKey());
            if (newField == null || !oldFieldEntry.getValue().isSchemaEqual(newField)) {
                return false;
            }
            matchedFields.add(newField);
        }
        return newEntityFields.values().size() == matchedFields.size();
    }

    public static boolean tablesHaveSameForeignKeyConstraints(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(8);
        }
        if (newEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(9);
        }
        List<ForeignKeyBundle> oldEntityForeignKeys = oldEntity.getForeignKeys();
        List<ForeignKeyBundle> newEntityForeignKeys = newEntity.getForeignKeys();
        ArrayList<ForeignKeyBundle> matchedKeys = new ArrayList<ForeignKeyBundle>();
        if (oldEntityForeignKeys.size() != newEntityForeignKeys.size()) {
            return false;
        }
        for (ForeignKeyBundle oldKey : oldEntityForeignKeys) {
            boolean foundMatchingNewKey = false;
            for (ForeignKeyBundle newKey : newEntityForeignKeys) {
                if (!oldKey.isSchemaEqual(newKey)) continue;
                foundMatchingNewKey = true;
                matchedKeys.add(newKey);
                break;
            }
            if (foundMatchingNewKey) continue;
            return false;
        }
        return newEntityForeignKeys.size() == matchedKeys.size();
    }

    public static boolean tablesHaveSameIndices(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(10);
        }
        if (newEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(11);
        }
        List<IndexBundle> oldEntityIndices = oldEntity.getIndices();
        Map<String, IndexBundle> newEntityIndies = newEntity.getIndices().stream().collect(Collectors.toMap(IndexBundle::getName, index -> index));
        ArrayList<IndexBundle> matchedIndices = new ArrayList<IndexBundle>();
        if (oldEntityIndices.size() != newEntityIndies.size()) {
            return false;
        }
        for (IndexBundle oldIndex : oldEntityIndices) {
            IndexBundle newIndex = newEntityIndies.get(oldIndex.getName());
            if (newIndex == null || !oldIndex.isSchemaEqual(newIndex)) {
                return false;
            }
            matchedIndices.add(newIndex);
        }
        return newEntityIndies.values().size() == matchedIndices.size();
    }

    public static boolean ftsTableNeedsExternalContentSource(@NotNull FtsEntityBundle ftsEntity) {
        String contentTable;
        FtsOptionsBundle ftsOptions;
        if (ftsEntity == null) {
            SchemaDiffUtil.$$$reportNull$$$0(12);
        }
        return (ftsOptions = ftsEntity.getFtsOptions()) != null && (contentTable = ftsOptions.getContentTable()) != null && !contentTable.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newField";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftsEntity";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/room/migrations/update/SchemaDiffUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldStructureTheSame";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTableStructureTheSame";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTableTypeTheSame";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tablesHaveSameColumns";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "tablesHaveSameForeignKeyConstraints";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "tablesHaveSameIndices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "ftsTableNeedsExternalContentSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

