/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GenerateMigrationWizardData {
    private Project project;
    private PsiPackage targetPackage;
    private PsiDirectory migrationClassDirectory;
    private PsiDirectory migrationTestDirectory;
    private DatabaseUpdate databaseUpdate;
    private List<EntityUpdate> userIdentifiedEntityUpdates;
    private Map<String, String> renamedTables;
    private Map<String, Map<String, String>> tableToRenamedColumnsMapping;

    GenerateMigrationWizardData(@NotNull Project project, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory migrationClassDirectory, @NotNull PsiDirectory migrationTestDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        if (project == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(0);
        }
        if (targetPackage == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(1);
        }
        if (migrationClassDirectory == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(2);
        }
        if (migrationTestDirectory == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(3);
        }
        if (databaseUpdate == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(4);
        }
        this.project = project;
        this.targetPackage = targetPackage;
        this.migrationClassDirectory = migrationClassDirectory;
        this.migrationTestDirectory = migrationTestDirectory;
        this.databaseUpdate = databaseUpdate;
        this.userIdentifiedEntityUpdates = new ArrayList<EntityUpdate>();
        this.renamedTables = new HashMap<String, String>();
        this.tableToRenamedColumnsMapping = new HashMap<String, Map<String, String>>();
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public PsiPackage getTargetPackage() {
        PsiPackage psiPackage = this.targetPackage;
        if (psiPackage == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(6);
        }
        return psiPackage;
    }

    @NotNull
    public PsiDirectory getMigrationClassDirectory() {
        PsiDirectory psiDirectory = this.migrationClassDirectory;
        if (psiDirectory == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(7);
        }
        return psiDirectory;
    }

    @NotNull
    public PsiDirectory getMigrationTestDirectory() {
        PsiDirectory psiDirectory = this.migrationTestDirectory;
        if (psiDirectory == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(8);
        }
        return psiDirectory;
    }

    @NotNull
    public DatabaseUpdate getDatabaseUpdate() {
        DatabaseUpdate databaseUpdate = this.databaseUpdate;
        if (databaseUpdate == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(9);
        }
        return databaseUpdate;
    }

    @NotNull
    public List<EntityUpdate> getUserIdentifiedEntityUpdates() {
        List<EntityUpdate> list = this.userIdentifiedEntityUpdates;
        if (list == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public DatabaseUpdate getUserReviewedDatabaseUpdate() {
        this.databaseUpdate.applyRenameMapping(this.renamedTables);
        for (EntityUpdate entityUpdate : this.databaseUpdate.getModifiedEntities().values()) {
            Map<String, String> renamedColumns = this.tableToRenamedColumnsMapping.get(entityUpdate.getNewTableName());
            if (renamedColumns == null) continue;
            entityUpdate.applyRenameMapping(renamedColumns);
        }
        DatabaseUpdate databaseUpdate = this.databaseUpdate;
        if (databaseUpdate == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(11);
        }
        return databaseUpdate;
    }

    public void updateTargetPackage(@NotNull PsiPackage targetPackage) {
        if (targetPackage == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(12);
        }
        this.targetPackage = targetPackage;
    }

    public void updateMigrationClassDirectory(@NotNull PsiDirectory migrationClassDirectory) {
        if (migrationClassDirectory == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(13);
        }
        this.migrationClassDirectory = migrationClassDirectory;
    }

    public void updateMigrationTestDirectory(PsiDirectory migrationTestDirectory) {
        this.migrationTestDirectory = migrationTestDirectory;
    }

    public void updateRenamedTables(@NotNull Map<String, String> userInput) {
        if (userInput == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(14);
        }
        this.renamedTables = userInput;
    }

    public void updateTableToRenamedColumnsMapping(@NotNull Map<String, Map<String, String>> tableToRenamedColumnsMapping) {
        if (tableToRenamedColumnsMapping == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(15);
        }
        this.tableToRenamedColumnsMapping = tableToRenamedColumnsMapping;
    }

    public void updateUserIdentifiedEntityUpdates(@NotNull List<EntityUpdate> userIdentifiedEntityUpdates) {
        if (userIdentifiedEntityUpdates == null) {
            GenerateMigrationWizardData.$$$reportNull$$$0(16);
        }
        this.userIdentifiedEntityUpdates = userIdentifiedEntityUpdates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationClassDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationTestDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseUpdate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizardData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userInput";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableToRenamedColumnsMapping";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userIdentifiedEntityUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizardData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationClassDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationTestDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseUpdate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserIdentifiedEntityUpdates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserReviewedDatabaseUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetPackage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateMigrationClassDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateRenamedTables";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTableToRenamedColumnsMapping";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateUserIdentifiedEntityUpdates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

