/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public interface MigrationTestGenerator {
    public static final String RULE_ANNOTATION_QUALIFIED_NAME = "org.junit.Rule";
    public static final String TEST_ANNOTATION_QUALIFIED_NAME = "org.junit.Test";
    public static final String RUN_WITH_ANNOTATION_QUALIFIED_NAME = "org.junit.runner.RunWith";
    public static final String OLD_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME = "androidx.test.runner.AndroidJUnit4";
    public static final String NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME = "androidx.test.ext.junit.runners.AndroidJUnit4";
    public static final String IO_EXCEPTION_QUALIFIED_NAME = "java.io.IOException";
    public static final String ASSERT_QUALIFIED_NAME = "org.junit.Assert";
    public static final String MIGRATION_TEST_HELPER_QUALIFIED_NAME = "androidx.room.testing.MigrationTestHelper";
    public static final String FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME = "androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory";
    public static final String INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME = "androidx.test.platform.app.InstrumentationRegistry";
    public static final String SUPPORT_SQLITE_DATABASE_QUALIFIED_NAME = "androidx.sqlite.db.SupportSQLiteDatabase";
    public static final String MIGRATION_TEST_HELPER_FIELD_NAME = "migrationTestHelper";
    public static final String EXEC_SQL_STATEMENT = "db.execSQL(\"INSERT INTO table_name (column_name) VALUES (value);\")";
    public static final String CLOSE_STATEMENT = "db.close()";
    public static final String ASSERT_STATEMENT = "%s.fail(\"TODO: Verify data after migration is correct\")";
    public static final String EXEC_SQL_COMMENT = "// TODO: Insert data in the test database using SQL queries.";
    public static final String CLOSE_COMMENT = "// Prepare for the next version.";
    public static final String ASSERT_COMMENT = "// MigrationTestHelper automatically verifies the schema changes, but you need to validate that the data was migrated properly.";

    public void createMigrationTest(@NotNull PsiPackage var1, @NotNull PsiDirectory var2, @NotNull String var3, @NotNull String var4, int var5, int var6);

    @NotNull
    public static String getMigrationTestName(int migrationStartVersion, int migrationEndVersion) {
        String string = String.format(Locale.US, "Migration_%d_%d_Test", migrationStartVersion, migrationEndVersion);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getMigrationTestMethodName(int migrationStartVersion, int migrationEndVersion) {
        String string = String.format(Locale.US, "testMigrate%dTo%d", migrationStartVersion, migrationEndVersion);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getTestDatabaseFieldName(@NotNull String databaseName) {
        if (databaseName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(2);
        }
        return String.format("TEST_%s", CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, databaseName));
    }

    @NotNull
    public static String getTestDatabaseName(@NotNull String databaseName) {
        if (databaseName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(3);
        }
        String string = String.format("\"test-%s\"", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, databaseName));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String selectRunnerClass(@NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope migrationTestResolveScope) {
        String runnerQualifiedName;
        if (javaPsiFacade == null) {
            MigrationTestGenerator.$$$reportNull$$$0(5);
        }
        if (migrationTestResolveScope == null) {
            MigrationTestGenerator.$$$reportNull$$$0(6);
        }
        try {
            PsiClass runnerClass = (PsiClass)MoreObjects.firstNonNull((Object)javaPsiFacade.findClass(NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME, migrationTestResolveScope), (Object)javaPsiFacade.findClass(OLD_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME, migrationTestResolveScope));
            runnerQualifiedName = runnerClass.getQualifiedName();
        }
        catch (Exception e) {
            runnerQualifiedName = NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME;
        }
        if (!1.$assertionsDisabled && runnerQualifiedName == null) {
            throw new AssertionError();
        }
        String string = runnerQualifiedName;
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getInstrumentationParameter(@NotNull CodeType codeType) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(8);
        }
        String instrumentationRegistry = codeType == CodeType.JAVA_CODE ? INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME : StringUtil.getShortName((String)INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME);
        String string = String.format("%s.getInstrumentation()", instrumentationRegistry);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getDatabaseCanonicalNameParameter(@NotNull CodeType codeType, @NotNull String databaseClassQualifiedName) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(10);
        }
        if (databaseClassQualifiedName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(11);
        }
        if (codeType == CodeType.JAVA_CODE) {
            String string = String.format("%s.class.getCanonicalName()", databaseClassQualifiedName);
            if (string == null) {
                MigrationTestGenerator.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = String.format("%s::class.java.canonicalName", StringUtil.getShortName((String)databaseClassQualifiedName));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getFrameworkSqliteOpenFactoryHelperParameter(@NotNull CodeType codeType) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(14);
        }
        if (codeType == CodeType.JAVA_CODE) {
            String string = String.format("new %s()", FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME);
            if (string == null) {
                MigrationTestGenerator.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = String.format("%s()", StringUtil.getShortName((String)FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getHelperInitializationExpression(@NotNull CodeType codeType, @NotNull String databaseClassQualifiedName) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(17);
        }
        if (databaseClassQualifiedName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(18);
        }
        if (codeType == CodeType.JAVA_CODE) {
            String string = String.format("%s = new %s(\n%s,\n %s,\n %s);", MIGRATION_TEST_HELPER_FIELD_NAME, MIGRATION_TEST_HELPER_QUALIFIED_NAME, MigrationTestGenerator.getInstrumentationParameter(codeType), MigrationTestGenerator.getDatabaseCanonicalNameParameter(codeType, databaseClassQualifiedName), MigrationTestGenerator.getFrameworkSqliteOpenFactoryHelperParameter(codeType));
            if (string == null) {
                MigrationTestGenerator.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = String.format("val %s: MigrationTestHelper = MigrationTestHelper(\n%s,\n %s,\n %s)", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getInstrumentationParameter(codeType), MigrationTestGenerator.getDatabaseCanonicalNameParameter(codeType, databaseClassQualifiedName), MigrationTestGenerator.getFrameworkSqliteOpenFactoryHelperParameter(codeType));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getCreateDatabaseStatement(@NotNull CodeType codeType, @NotNull String databaseName, int databaseVersion) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(21);
        }
        if (databaseName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(22);
        }
        String createDatabaseStatementTemplate = codeType == CodeType.JAVA_CODE ? "androidx.sqlite.db.SupportSQLiteDatabase db = %s.createDatabase(%s, %d);" : "var db = %s.createDatabase(%s, %d)";
        String string = String.format(Locale.US, createDatabaseStatementTemplate, MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getCreateDatabaseComment(int databaseVersion) {
        String string = String.format(Locale.US, "// Create database with schema version %d.", databaseVersion);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getExecSqlStatement(@NotNull CodeType codeType) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(25);
        }
        if (codeType == CodeType.JAVA_CODE) {
            return "db.execSQL(\"INSERT INTO table_name (column_name) VALUES (value);\");";
        }
        return EXEC_SQL_STATEMENT;
    }

    @NotNull
    public static String getCloseStatement(@NotNull CodeType codeType) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(26);
        }
        if (codeType == CodeType.JAVA_CODE) {
            return "db.close();";
        }
        return CLOSE_STATEMENT;
    }

    @NotNull
    public static String getRunAndValidateMigrationStatement(@NotNull CodeType codeType, @NotNull String databaseName, @NotNull String migrationQualifiedName, int databaseVersion) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(27);
        }
        if (databaseName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(28);
        }
        if (migrationQualifiedName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(29);
        }
        if (codeType == CodeType.JAVA_CODE) {
            String string = String.format(Locale.US, "db = %s.runMigrationsAndValidate(%s, %d, true, new %s());", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion, migrationQualifiedName);
            if (string == null) {
                MigrationTestGenerator.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = String.format(Locale.US, "db = %s.runMigrationsAndValidate(%s, %d, true, %s())", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion, StringUtil.getShortName((String)migrationQualifiedName));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String getRunAndValidateMigrationComment(@NotNull String migrationName, int databaseVersion) {
        if (migrationName == null) {
            MigrationTestGenerator.$$$reportNull$$$0(32);
        }
        String string = String.format(Locale.US, "// Re-open the database with version %d and provide %s as the migration process.", databaseVersion, migrationName);
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String getAssertStatement(@NotNull CodeType codeType) {
        if (codeType == null) {
            MigrationTestGenerator.$$$reportNull$$$0(34);
        }
        if (codeType == CodeType.JAVA_CODE) {
            String string = String.format(ASSERT_STATEMENT, ASSERT_QUALIFIED_NAME) + ";";
            if (string == null) {
                MigrationTestGenerator.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = String.format(ASSERT_STATEMENT, StringUtil.getShortName((String)ASSERT_QUALIFIED_NAME));
        if (string == null) {
            MigrationTestGenerator.$$$reportNull$$$0(36);
        }
        return string;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/generators/MigrationTestGenerator";
                break;
            }
            case 2: 
            case 3: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsiFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationTestResolveScope";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeType";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseClassQualifiedName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationQualifiedName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationTestName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationTestMethodName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/generators/MigrationTestGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDatabaseName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectRunnerClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstrumentationParameter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseCanonicalNameParameter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkSqliteOpenFactoryHelperParameter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperInitializationExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDatabaseStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDatabaseComment";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAndValidateMigrationStatement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAndValidateMigrationComment";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssertStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestDatabaseFieldName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestDatabaseName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectRunnerClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstrumentationParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseCanonicalNameParameter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkSqliteOpenFactoryHelperParameter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getHelperInitializationExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDatabaseStatement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getExecSqlStatement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCloseStatement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRunAndValidateMigrationStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRunAndValidateMigrationComment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAssertStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CodeType {
        JAVA_CODE,
        KOTLIN_CODE;

    }
}

