/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class CommentTrackingXmlPullParser
extends KXmlParser {
    private static final int ATTR_GROUP_MAX_CHARACTERS = 40;
    @Nullable
    String myLastComment;
    boolean tagEncounteredAfterComment;
    @NotNull
    final ArrayList<String> myAttrGroupCommentStack = new ArrayList(4);

    public CommentTrackingXmlPullParser() {
        try {
            this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException e) {
            throw new Error(e);
        }
    }

    @Nullable
    public String getLastComment() {
        return this.myLastComment;
    }

    @Nullable
    public String getAttrGroupComment() {
        return this.myAttrGroupCommentStack.get(this.myAttrGroupCommentStack.size() - 1);
    }

    public int nextToken() throws XmlPullParserException, IOException {
        int token = super.nextToken();
        this.processToken(token);
        return token;
    }

    public int next() throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException("Use nextToken() instead of next() for comment tracking to work");
    }

    private void processToken(int token) {
        switch (token) {
            case 2: {
                if (this.tagEncounteredAfterComment) {
                    this.myLastComment = null;
                }
                this.tagEncounteredAfterComment = true;
                this.myAttrGroupCommentStack.add(this.myAttrGroupCommentStack.get(this.myAttrGroupCommentStack.size() - 1));
                assert (this.myAttrGroupCommentStack.size() == this.getDepth() + 1);
                if (!"eat-comment".equals(this.getName()) || this.getPrefix() != null || this.myLastComment == null || this.myLastComment.length() > 40 || this.myLastComment.startsWith("TODO:")) break;
                String attrGroupComment = this.myLastComment;
                if (attrGroupComment.endsWith(".")) {
                    attrGroupComment = attrGroupComment.substring(0, attrGroupComment.length() - 1);
                }
                this.myAttrGroupCommentStack.set(this.myAttrGroupCommentStack.size() - 2, attrGroupComment);
                break;
            }
            case 3: {
                this.myLastComment = null;
                this.myAttrGroupCommentStack.remove(this.myAttrGroupCommentStack.size() - 1);
                break;
            }
            case 9: {
                String commentText = this.getText().trim();
                if (CommentTrackingXmlPullParser.isEmptyOrAsciiArt(commentText)) break;
                this.myLastComment = commentText;
                this.tagEncounteredAfterComment = false;
                break;
            }
        }
    }

    public void setInput(@NotNull Reader reader) throws XmlPullParserException {
        if (reader == null) {
            CommentTrackingXmlPullParser.$$$reportNull$$$0(0);
        }
        super.setInput(reader);
        this.myLastComment = null;
        this.myAttrGroupCommentStack.clear();
        this.myAttrGroupCommentStack.add(null);
    }

    public void setInput(@NotNull InputStream inputStream, @Nullable String encoding) throws XmlPullParserException {
        if (inputStream == null) {
            CommentTrackingXmlPullParser.$$$reportNull$$$0(1);
        }
        super.setInput(inputStream, encoding);
        this.myLastComment = null;
        this.myAttrGroupCommentStack.clear();
        this.myAttrGroupCommentStack.add(null);
    }

    private static boolean isEmptyOrAsciiArt(@NotNull String commentText) {
        if (commentText == null) {
            CommentTrackingXmlPullParser.$$$reportNull$$$0(2);
        }
        return commentText.isEmpty() || commentText.charAt(0) == '*' || commentText.charAt(0) == '=';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/resources/base/CommentTrackingXmlPullParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setInput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyOrAsciiArt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

