/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.utils.HashCodes;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceNavigationItem
implements NavigationItem {
    @NotNull
    private final ResourceItem myResource;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;

    public ResourceNavigationItem(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file, @NotNull Project project) {
        if (resourceItem == null) {
            ResourceNavigationItem.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ResourceNavigationItem.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ResourceNavigationItem.$$$reportNull$$$0(2);
        }
        this.myResource = resourceItem;
        this.myFile = file;
        this.myProject = project;
    }

    @NotNull
    public String getName() {
        String string = this.myResource.getName();
        if (string == null) {
            ResourceNavigationItem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceItemPresentation(this.myResource, this.myFile);
    }

    public void navigate(boolean requestFocus) {
        Navigatable target = this.getNavigationTarget();
        if (target != null) {
            target.navigate(requestFocus);
        }
    }

    @Nullable
    private Navigatable getNavigationTarget() {
        PsiElement psiElement = AndroidResourceToPsiResolver.getInstance().resolveToDeclaration(this.myResource, this.myProject);
        return psiElement == null ? null : PsiNavigationSupport.getInstance().getDescriptor(psiElement);
    }

    public boolean canNavigate() {
        Navigatable target = this.getNavigationTarget();
        return target != null && target.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable target = this.getNavigationTarget();
        return target != null && target.canNavigateToSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNavigationItem item = (ResourceNavigationItem)o;
        return this.myResource.equals(item.myResource) && this.myFile.equals(item.myFile) && this.myProject.equals(item.myProject);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myResource.hashCode(), (int)this.myFile.hashCode(), (int)this.myProject.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/psi/ResourceNavigationItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/psi/ResourceNavigationItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ResourceItemPresentation
    implements ItemPresentation {
        @NotNull
        private final ResourceItem myResource;
        @NotNull
        private final VirtualFile myFile;

        public ResourceItemPresentation(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file) {
            if (resourceItem == null) {
                ResourceItemPresentation.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ResourceItemPresentation.$$$reportNull$$$0(1);
            }
            this.myResource = resourceItem;
            this.myFile = file;
        }

        @NotNull
        public String getPresentableText() {
            VirtualFile parentDir = this.myFile.getParent();
            if (parentDir == null) {
                String string = this.myResource.getName();
                if (string == null) {
                    ResourceItemPresentation.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.myResource.isFileBased()) {
                String string = this.myResource.getName() + " (" + parentDir.getName() + ")";
                if (string == null) {
                    ResourceItemPresentation.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.myResource.getName() + " (..." + File.separatorChar + parentDir.getName() + File.separatorChar + this.myFile.getName() + ")";
            if (string == null) {
                ResourceItemPresentation.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public String getLocationString() {
            return null;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return ResourceReferencePsiElement.RESOURCE_ICON;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/psi/ResourceNavigationItem$ResourceItemPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/psi/ResourceNavigationItem$ResourceItemPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

