/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceManagerToPsiResolver
implements AndroidResourceToPsiResolver {
    @NotNull
    public static final ResourceManagerToPsiResolver INSTANCE = new ResourceManagerToPsiResolver();

    private ResourceManagerToPsiResolver() {
    }

    @Override
    @Nullable
    public PsiElement resolveToDeclaration(@NotNull ResourceItem resourceItem, @NotNull Project project) {
        VirtualFile source;
        if (resourceItem == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(1);
        }
        if ((source = ResourceHelper.getSourceAsVirtualFile(resourceItem)) == null) {
            return null;
        }
        if (resourceItem.isFileBased()) {
            return PsiManager.getInstance((Project)project).findFile(source);
        }
        if (resourceItem.getType() == ResourceType.ID) {
            XmlAttribute xmlAttribute = AndroidResourceUtil.getIdDeclarationAttribute(project, resourceItem);
            return xmlAttribute == null ? null : xmlAttribute.getValueElement();
        }
        return new ValueResourceInfoImpl(resourceItem, source, project).computeXmlElement();
    }

    @Override
    @NotNull
    public ResolveResult[] resolveReference(@NotNull ResourceValue resourceValue2, @NotNull XmlElement context, @NotNull AndroidFacet facet2) {
        if (resourceValue2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(3);
        }
        if (facet2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(4);
        }
        return this.resolveReference(resourceValue2, context, facet2, false);
    }

    @Override
    @NotNull
    public ResolveResult[] resolveReferenceWithDynamicFeatureModules(@NotNull ResourceValue resourceValue2, @NotNull XmlElement element, @NotNull AndroidFacet facet2) {
        if (resourceValue2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(6);
        }
        if (facet2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(7);
        }
        return this.resolveReference(resourceValue2, element, facet2, true);
    }

    @NotNull
    private ResolveResult[] resolveReference(@NotNull ResourceValue resourceValue2, @NotNull XmlElement context, @NotNull AndroidFacet facet2, boolean includeDynamicFeatures) {
        AndroidModuleSystem androidModuleSystem;
        ResourceManager manager;
        ResourceNamespace resolvedNamespace;
        if (resourceValue2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(8);
        }
        if (context == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(9);
        }
        if (facet2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(10);
        }
        if ((resolvedNamespace = ResourceHelper.resolveResourceNamespace(context, resourceValue2.getPackage())) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(11);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean attrReference = resourceValue2.getPrefix() == '?';
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        if (resourceValue2.getType() != null && resourceValue2.getResourceName() != null && (manager = ModuleResourceManagers.getInstance(facet2).getResourceManager(resolvedNamespace.getPackageName(), (PsiElement)context)) != null) {
            manager.collectLazyResourceElements(resolvedNamespace, resourceValue2.getType().getName(), resourceValue2.getResourceName(), attrReference, (PsiElement)context, elements);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (elements.isEmpty() && resourceValue2.getResourceName() != null && resolvedNamespace != ResourceNamespace.ANDROID) {
            LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(facet2.getModule());
            ResourceType resourceType = resourceValue2.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                XmlAttribute attribute;
                assert (resources != null);
                String resourceName = resourceValue2.getResourceName();
                if (resourceType == ResourceType.SAMPLE_DATA) {
                    resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceName);
                }
                List<ResourceItem> items2 = resources.getResources(resolvedNamespace, resourceType, resourceName);
                if (FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items2) {
                        if (item instanceof ResolvableResourceItem) {
                            result2.add(((ResolvableResourceItem)item).createResolveResult());
                            continue;
                        }
                        if (item instanceof BasicResourceItem && !((BasicResourceItem)item).isUserDefined()) {
                            result2.add(new AarResourceResolveResult((BasicResourceItem)item));
                            continue;
                        }
                        XmlTag tag = AndroidResourceUtil.getItemTag(facet2.getModule().getProject(), item);
                        if (tag == null) continue;
                        elements.add((PsiElement)tag);
                    }
                } else if (resourceType == ResourceType.SAMPLE_DATA && context.getParent() instanceof XmlAttribute && "http://schemas.android.com/tools".equals((attribute = (XmlAttribute)context.getParent()).getNamespace())) {
                    items2.stream().filter(SampleDataResourceItem.class::isInstance).forEach(sampleDataItem -> result2.add(((SampleDataResourceItem)sampleDataItem).createResolveResult()));
                }
            }
        }
        if (includeDynamicFeatures && (androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)context)) != null) {
            List<Module> modules = androidModuleSystem.getDynamicFeatureModules();
            for (Module module : modules) {
                LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(module);
                if (moduleResources == null) continue;
                List<ResourceItem> resources = moduleResources.getResources(resolvedNamespace, resourceValue2.getType(), resourceValue2.getResourceName());
                for (ResourceItem item : resources) {
                    PsiElement declaration = this.resolveToDeclaration(item, context.getProject());
                    if (declaration == null) continue;
                    result2.add(new PsiElementResolveResult(declaration));
                }
            }
        }
        if (elements.size() > 1) {
            elements.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result2.add(new PsiElementResolveResult(target));
        }
        ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(12);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public PsiElement[] getXmlAttributeNameGotoDeclarationTargets(@NotNull String attributeName, @NotNull ResourceNamespace namespace, @NotNull PsiElement context) {
        LocalResourceRepository repository;
        AndroidFacet facet2;
        if (attributeName == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(13);
        }
        if (namespace == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(15);
        }
        if ((facet2 = AndroidFacet.getInstance((PsiElement)context)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(16);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        LocalResourceRepository localResourceRepository = repository = namespace.equals((Object)ResourceNamespace.ANDROID) ? repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of()) : repositoryManager.getAppResources();
        if (repository == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<LazyValueResourceElementWrapper> elementList = new ArrayList<LazyValueResourceElementWrapper>();
        for (ResourceItem resourceItem : repository.getResources(namespace, ResourceType.ATTR, attributeName)) {
            VirtualFile file = FileExtensions.toVirtualFile(resourceItem.getSource());
            if (file == null) continue;
            elementList.add(new LazyValueResourceElementWrapper(new ValueResourceInfoImpl(resourceItem, file, facet2.getModule().getProject()), context));
        }
        PsiElement[] psiElementArray = elementList.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiFile[] getGotoDeclarationFileBasedTargets(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        if (resourceReference == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(19);
        }
        if (context == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(20);
        }
        PsiElement[] targets = this.getGotoDeclarationTargets(resourceReference, context);
        PsiFile[] psiFileArray = (PsiFile[])Arrays.stream(targets).filter(element -> element instanceof PsiFile).map(PsiFile.class::cast).toArray(PsiFile[]::new);
        if (psiFileArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(21);
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public PsiElement[] getGotoDeclarationTargets(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        ResourceManager manager;
        AndroidFacet facet2;
        if (resourceReference == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(22);
        }
        if (context == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(23);
        }
        if ((facet2 = AndroidFacet.getInstance((PsiElement)context)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(24);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResourceType resourceType = resourceReference.getResourceType();
        ResourceNamespace namespace = resourceReference.getNamespace();
        String resourceName = resourceReference.getName();
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet2);
        ResourceManager resourceManager = manager = namespace == ResourceNamespace.ANDROID ? resourceManagers.getFrameworkResourceManager(false) : resourceManagers.getLocalResourceManager();
        if (manager == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(25);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        manager.collectLazyResourceElements(namespace, resourceType.getName(), resourceName, true, context, resourceList);
        if (manager instanceof LocalResourceManager) {
            LocalResourceManager localManager = (LocalResourceManager)manager;
            if (resourceType.equals((Object)ResourceType.STYLEABLE)) {
                for (DeclareStyleable declareStyleable : localManager.findStyleables(namespace, resourceName)) {
                    resourceList.add((PsiElement)declareStyleable.getName().getXmlAttributeValue());
                }
                for (Attr attr : localManager.findStyleableAttributesByFieldName(namespace, resourceName)) {
                    resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                }
            }
        }
        if (resourceList.size() > 1) {
            resourceList.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        PsiElement[] psiElementArray = resourceList.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(26);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/psi/ResourceManagerToPsiResolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/psi/ResourceManagerToPsiResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlAttributeNameGotoDeclarationTargets";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoDeclarationFileBasedTargets";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoDeclarationTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveToDeclaration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceWithDynamicFeatureModules";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getXmlAttributeNameGotoDeclarationTargets";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationFileBasedTargets";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AarResourceResolveResult
    implements ResolveResult {
        @Nullable
        private final PsiElement myElement;

        AarResourceResolveResult(@NotNull BasicResourceItem resourceItem) {
            if (resourceItem == null) {
                AarResourceResolveResult.$$$reportNull$$$0(0);
            }
            this.myElement = null;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        public boolean isValidResult() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceItem", "com/android/tools/idea/res/psi/ResourceManagerToPsiResolver$AarResourceResolveResult", "<init>"));
        }
    }
}

