/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.ResourceRepositoryInnerRClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRepositoryRClass
extends AndroidRClassBase {
    private static final Logger LOG = Logger.getInstance(ResourceRepositoryRClass.class);
    @NotNull
    private final ResourcesSource mySource;

    public ResourceRepositoryRClass(@NotNull PsiManager psiManager, @NotNull ResourcesSource source) {
        if (psiManager == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(0);
        }
        if (source == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(1);
        }
        super(psiManager, source.getPackageName());
        this.mySource = source;
    }

    @Override
    @NotNull
    protected PsiClass[] doGetInnerClasses() {
        if (DumbService.isDumb((Project)this.getProject())) {
            LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            if (PsiClass.EMPTY_ARRAY == null) {
                ResourceRepositoryRClass.$$$reportNull$$$0(2);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        Set<ResourceType> types = this.mySource.getResourceRepository().getResourceTypes(this.mySource.getResourceNamespace());
        ArrayList<ResourceRepositoryInnerRClass> result2 = new ArrayList<ResourceRepositoryInnerRClass>();
        for (ResourceType type : types) {
            if (!type.getHasInnerClass()) continue;
            result2.add(new ResourceRepositoryInnerRClass(type, this.mySource, this));
        }
        LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(3);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    protected ModificationTracker getInnerClassesDependencies() {
        ModificationTracker modificationTracker = () -> this.mySource.getResourceRepository().getModificationCount();
        if (modificationTracker == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(4);
        }
        return modificationTracker;
    }

    @Nullable
    public String getQualifiedName() {
        String packageName = this.mySource.getPackageName();
        return packageName == null ? "R" : packageName + ".R";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceRepositoryRClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceRepositoryRClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetInnerClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourcesSource {
        @Nullable
        public String getPackageName();

        @NotNull
        public LocalResourceRepository getResourceRepository();

        @NotNull
        public ResourceNamespace getResourceNamespace();

        @NotNull
        public AndroidLightField.FieldModifier getFieldModifier();

        public boolean isPublic(@NotNull ResourceType var1, @NotNull String var2);
    }
}

