/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.AndroidPluginVersion;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCache;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceFolderRepositoryFileCacheImpl
implements ResourceFolderRepositoryFileCache {
    private static final String CACHE_DIRECTORY = "caches/project_resources";
    private static final String INVALIDATION_MARKER_FILE = "invalidated.txt";
    @NotNull
    private final Path myRootDir;

    ResourceFolderRepositoryFileCacheImpl() {
        this.myRootDir = Paths.get(PathManager.getSystemPath(), new String[0]).resolve(CACHE_DIRECTORY);
    }

    ResourceFolderRepositoryFileCacheImpl(@NotNull Path rootDirParent) {
        if (rootDirParent == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(0);
        }
        this.myRootDir = rootDirParent.resolve(CACHE_DIRECTORY);
    }

    private static Logger getLogger() {
        return Logger.getInstance(ResourceFolderRepositoryFileCacheImpl.class);
    }

    @Override
    @Nullable
    public ResourceFolderRepositoryCachingData getCachingData(@NotNull Project project, @NotNull VirtualFile resourceDir, @Nullable Executor cacheCreationExecutor) {
        String codeVersion;
        if (project == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(1);
        }
        if (resourceDir == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(2);
        }
        if ((codeVersion = AndroidPluginVersion.getAndroidPluginVersion()) == null) {
            return null;
        }
        Path cacheFile = this.getCacheFile(project, resourceDir);
        if (cacheFile == null) {
            return null;
        }
        return new ResourceFolderRepositoryCachingData(cacheFile, this.isValid(), codeVersion, cacheCreationExecutor);
    }

    @Override
    public void createDirForProject(@NotNull Project project) throws IOException {
        Path dir;
        if (project == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(3);
        }
        if ((dir = this.getProjectDir(project)) == null) {
            throw new IOException();
        }
        FileUtil.ensureExists((File)dir.toFile());
    }

    @Nullable
    private Path getCacheFile(@NotNull Project project, @NotNull VirtualFile resourceDir) {
        if (project == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(4);
        }
        if (resourceDir == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(5);
        }
        if (!this.isValid()) {
            return null;
        }
        Path projectComponent = this.getProjectDir(project);
        if (projectComponent == null) {
            return null;
        }
        String dirComponent = FileUtil.sanitizeFileName((String)resourceDir.getParent().getName()) + "_" + Integer.toHexString(resourceDir.hashCode()) + ".dat";
        return projectComponent.resolve(dirComponent);
    }

    @VisibleForTesting
    @Nullable
    Path getRootDir() {
        if (!Files.isDirectory(this.myRootDir, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(this.myRootDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to create cache root directory " + this.myRootDir, (Throwable)e);
                return null;
            }
        }
        return this.myRootDir;
    }

    @VisibleForTesting
    @Nullable
    Path getProjectDir(@NotNull Project project) {
        Path rootDir;
        if (project == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(6);
        }
        if ((rootDir = this.getRootDir()) == null) {
            return null;
        }
        return ProjectUtil.getProjectCachePath((Project)project, (Path)rootDir);
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return;
        }
        Path stampFile = rootDir.resolve(INVALIDATION_MARKER_FILE);
        try {
            Files.createFile(stampFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to write cache invalidating stamp file " + stampFile, (Throwable)e);
        }
    }

    @VisibleForTesting
    void clear() {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return;
        }
        boolean[] errorDeletingDirectories = new boolean[1];
        try (Stream<Path> stream2 = Files.list(rootDir);){
            stream2.forEach(subCache -> {
                if (!subCache.getFileName().toString().equals(INVALIDATION_MARKER_FILE)) {
                    try {
                        FileUtil.delete((Path)subCache);
                    }
                    catch (IOException e) {
                        ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + subCache + " directory", (Throwable)e);
                        errorDeletingDirectories[0] = true;
                    }
                }
            });
        }
        catch (IOException stream2) {
            // empty catch block
        }
        if (!errorDeletingDirectories[0]) {
            Path invalidationMarker = rootDir.resolve(INVALIDATION_MARKER_FILE);
            try {
                FileUtil.delete((Path)invalidationMarker);
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + invalidationMarker + " file", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    boolean isValid() {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return false;
        }
        Path stampFile = rootDir.resolve(INVALIDATION_MARKER_FILE);
        return Files.notExists(stampFile, new LinkOption[0]);
    }

    @NotNull
    private static ResourceFolderRepositoryFileCacheImpl getCache() {
        ResourceFolderRepositoryFileCacheImpl resourceFolderRepositoryFileCacheImpl = (ResourceFolderRepositoryFileCacheImpl)ResourceFolderRepositoryFileCacheService.get();
        if (resourceFolderRepositoryFileCacheImpl == null) {
            ResourceFolderRepositoryFileCacheImpl.$$$reportNull$$$0(7);
        }
        return resourceFolderRepositoryFileCacheImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirParent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachingData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirForProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDir";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PopulateCachesActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                PopulateCachesActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            DumbService dumbService = DumbService.getInstance((Project)project);
            ResourceFolderRegistry.PopulateCachesTask task2 = new ResourceFolderRegistry.PopulateCachesTask(project);
            dumbService.queueTask((DumbModeTask)task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl$PopulateCachesActivity", "runActivity"));
        }
    }

    static final class MaintenanceActivity
    implements StartupActivity.DumbAware {
        MaintenanceActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MaintenanceActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            DumbService dumbService = DumbService.getInstance((Project)project);
            PruneTask pruneTask = new PruneTask(project);
            dumbService.queueTask((DumbModeTask)pruneTask);
            ManageLruProjectFilesTask manageProjectsTask = new ManageLruProjectFilesTask(project);
            dumbService.queueTask((DumbModeTask)manageProjectsTask);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl$MaintenanceActivity", "runActivity"));
        }
    }

    public static class CacheInvalidator
    extends CachesInvalidator {
        public void invalidateCaches() {
            ResourceFolderRepositoryFileCacheService.get().invalidate();
        }
    }

    static final class PruneTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        PruneTask(@NotNull Project project) {
            if (project == null) {
                PruneTask.$$$reportNull$$$0(0);
            }
            super((Object)project);
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PruneTask.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            ResourceFolderRepositoryFileCacheImpl cache = ResourceFolderRepositoryFileCacheImpl.getCache();
            Path projectCacheBase = cache.getProjectDir(this.myProject);
            if (projectCacheBase == null || !Files.exists(projectCacheBase, new LinkOption[0])) {
                return;
            }
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            Map<VirtualFile, AndroidFacet> resDirectories = AndroidResourceUtil.getResourceDirectoriesForFacets(facets);
            HashSet<Path> usedCacheDirectories = new HashSet<Path>();
            for (VirtualFile resourceDir : resDirectories.keySet()) {
                Path dir = cache.getCacheFile(this.myProject, resourceDir);
                if (dir == null) continue;
                usedCacheDirectories.add(dir);
            }
            try (Stream<Path> stream = Files.list(projectCacheBase);){
                stream.forEach(file -> {
                    if (!usedCacheDirectories.contains(file) && !FileUtil.delete((File)file.toFile())) {
                        ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + file);
                    }
                });
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune cache files from " + projectCacheBase);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl$PruneTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ManageLruProjectFilesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;
        private static final Object PROJECT_LRU_LOCK = new Object();
        private static final String LRU_FILE = "project_lru_list.txt";
        private static final int MAX_PROJECT_CACHES = 12;

        ManageLruProjectFilesTask(@NotNull Project project) {
            if (project == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(0);
            }
            super((Object)project);
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            this.maintainLruCache(12);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void maintainLruCache(int maxProjectCaches) {
            assert (maxProjectCaches > 0);
            ResourceFolderRepositoryFileCacheImpl cache = ResourceFolderRepositoryFileCacheImpl.getCache();
            Path cacheRootDir = cache.getRootDir();
            if (cacheRootDir == null) {
                return;
            }
            if (!cache.isValid()) {
                cache.clear();
                return;
            }
            Object object = PROJECT_LRU_LOCK;
            synchronized (object) {
                try {
                    List<String> projectsList = ManageLruProjectFilesTask.loadListOfProjectCaches(cacheRootDir);
                    List<String> projectsToRemove = ManageLruProjectFilesTask.updateLruList(this.myProject, projectsList, maxProjectCaches);
                    ManageLruProjectFilesTask.pruneOldProjects(cacheRootDir, projectsToRemove);
                    ManageLruProjectFilesTask.writeListOfProjectCaches(cacheRootDir, projectsList);
                }
                catch (IOException e) {
                    ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to maintain projects LRU cache for dir " + cacheRootDir, (Throwable)e);
                }
            }
        }

        @VisibleForTesting
        @NotNull
        static List<String> loadListOfProjectCaches(@NotNull Path cacheRootDir) throws IOException {
            List<String> list;
            if (cacheRootDir == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(2);
            }
            Path lruFile = cacheRootDir.resolve(LRU_FILE);
            try {
                list = Files.readAllLines(lruFile).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
            catch (NoSuchFileException e) {
                return new ArrayList<String>();
            }
            if (list == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(3);
            }
            return list;
        }

        @VisibleForTesting
        static void writeListOfProjectCaches(@NotNull Path cacheRootDir, @NotNull List<String> projectsList) throws IOException {
            if (cacheRootDir == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(4);
            }
            if (projectsList == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(5);
            }
            Path lruFile = cacheRootDir.resolve(LRU_FILE);
            Files.write(lruFile, projectsList, new OpenOption[0]);
        }

        @VisibleForTesting
        static List<String> updateLruList(@NotNull Project currentProject, @NotNull List<String> projectsList, int maxProjectCaches) {
            if (currentProject == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(6);
            }
            if (projectsList == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(7);
            }
            ArrayList<String> projectsToRemove = new ArrayList<String>();
            Path currentProjectPath = ResourceFolderRepositoryFileCacheImpl.getCache().getProjectDir(currentProject);
            if (currentProjectPath == null) {
                return projectsToRemove;
            }
            String currentProjectDir = currentProjectPath.getFileName().toString();
            projectsList.remove(currentProjectDir);
            projectsList.add(0, currentProjectDir);
            int i2 = projectsList.size();
            while (--i2 >= maxProjectCaches) {
                projectsToRemove.add(projectsList.remove(i2));
            }
            return projectsToRemove;
        }

        private static void pruneOldProjects(@NotNull Path cacheRootDir, @NotNull List<String> childNames) {
            if (cacheRootDir == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(8);
            }
            if (childNames == null) {
                ManageLruProjectFilesTask.$$$reportNull$$$0(9);
            }
            for (String child : childNames) {
                Preconditions.checkArgument((!child.isEmpty() ? 1 : 0) != 0);
                Path path2 = cacheRootDir.resolve(child);
                if (FileUtil.delete((File)path2.toFile()) || !Files.exists(path2, new LinkOption[0])) continue;
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune directory " + path2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cacheRootDir";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl$ManageLruProjectFilesTask";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectsList";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentProject";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepositoryFileCacheImpl$ManageLruProjectFilesTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadListOfProjectCaches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performInDumbMode";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadListOfProjectCaches";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writeListOfProjectCaches";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateLruList";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "pruneOldProjects";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

