/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.res.FileTimeStampLengthHasher;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.LoggingPsiTreeChangeListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.VfsDensityBasedFileResourceItem;
import com.android.tools.idea.res.VfsFileResourceItem;
import com.android.tools.idea.res.VfsResourceFile;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.BasicDensityBasedFileResourceItem;
import com.android.tools.idea.resources.base.BasicFileResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSerializationUtil;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

public final class ResourceFolderRepository
extends LocalResourceRepository
implements LoadableResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "2";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final double CACHE_STALENESS_THRESHOLD = 0.05;
    private static final Comparator<ResourceItemSource<? extends ResourceItem>> SOURCE_COMPARATOR = Comparator.comparing(ResourceItemSource::getFolderConfiguration);
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PsiTreeChangeListener myPsiListener;
    @NotNull
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final PathString myResourcePathBase;
    private int myNumXmlFilesLoadedInitially;
    private int myNumXmlFilesLoadedInitiallyFromSources;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable;
    @NotNull
    private final Map<VirtualFile, ResourceItemSource<? extends ResourceItem>> mySources;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    @NotNull
    private final Object SCAN_LOCK;
    @Nullable
    private Set<PsiFile> myPendingScans;
    @VisibleForTesting
    static int ourFullRescans;
    @VisibleForTesting
    static int ourLayoutlibCacheFlushes;

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        if (facet2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(2);
        }
        return new ResourceFolderRepository(facet2, dir, namespace, cachingData);
    }

    private ResourceFolderRepository(@NotNull AndroidFacet facet2, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        if (facet2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(3);
        }
        if (resourceDir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(5);
        }
        super(resourceDir.getName());
        this.myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        this.mySources = new HashMap<VirtualFile, ResourceItemSource<? extends ResourceItem>>();
        this.SCAN_LOCK = new Object();
        this.myFacet = facet2;
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        this.myResourcePathPrefix = RepositoryLoader.portableFileName(this.myResourceDir.getPath()) + "/";
        this.myResourcePathBase = new PathString(this.myResourcePathPrefix);
        this.myPsiManager = PsiManager.getInstance((Project)this.getProject());
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Object psiListener = (Boolean)StudioFlags.INCREMENTAL_RESOURCE_REPOSITORIES.get() != false ? new IncrementalUpdatePsiListener() : new SimplePsiListener();
        this.myPsiListener = LOG.isDebugEnabled() ? new LoggingPsiTreeChangeListener((PsiTreeChangeListener)psiListener, LOG) : psiListener;
        Loader loader = new Loader(this, cachingData);
        loader.load();
    }

    @NotNull
    public VirtualFile getResourceDir() {
        VirtualFile virtualFile = this.myResourceDir;
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return null;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        Path path2 = Paths.get(this.myResourceDir.getPath(), new String[0]);
        if (path2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(7);
        }
        return path2;
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        if (relativeResourcePath == null) {
            ResourceFolderRepository.$$$reportNull$$$0(8);
        }
        String string = this.myResourcePathPrefix + relativeResourcePath;
        if (string == null) {
            ResourceFolderRepository.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            ResourceFolderRepository.$$$reportNull$$$0(10);
        }
        PathString pathString = this.myResourcePathBase.resolve(relativeResourcePath);
        if (pathString == null) {
            ResourceFolderRepository.$$$reportNull$$$0(11);
        }
        return pathString;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @Override
    public boolean containsUserDefinedResources() {
        return true;
    }

    private static void addToResult(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull ResourceItem item) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(12);
        }
        if (item == null) {
            ResourceFolderRepository.$$$reportNull$$$0(13);
        }
        result2.computeIfAbsent(item.getType(), t -> LinkedListMultimap.create()).put((Object)item.getName(), (Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        if (itemsByType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(14);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.commitToRepositoryWithoutLock(itemsByType);
        }
    }

    private void commitToRepositoryWithoutLock(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        if (itemsByType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(15);
        }
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
            this.getOrCreateMap(entry.getKey()).putAll((Multimap)entry.getValue());
        }
    }

    @VisibleForTesting
    boolean hasFreshFileCache() {
        return (double)this.myNumXmlFilesLoadedInitiallyFromSources <= (double)this.myNumXmlFilesLoadedInitially * 0.05;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitially() {
        return this.myNumXmlFilesLoadedInitially;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitiallyFromSources() {
        return this.myNumXmlFilesLoadedInitiallyFromSources;
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(16);
        }
        if (psiFile2.isValid()) {
            return psiFile2;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !this.getProject().isDisposed()) {
            return this.myPsiManager.findFile(virtualFile);
        }
        return null;
    }

    private void scanFileResourceFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull ResourceFolderType folderType, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceType type, boolean idGenerating, @NotNull PsiFile file) {
        String resourceName;
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(17);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(18);
        }
        if (folderConfiguration == null) {
            ResourceFolderRepository.$$$reportNull$$$0(19);
        }
        if (type == null) {
            ResourceFolderRepository.$$$reportNull$$$0(20);
        }
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(21);
        }
        if (FileResourceNameValidator.getErrorTextForNameWithoutExtension((String)(resourceName = ResourceHelper.getResourceName(file)), (ResourceFolderType)folderType) != null) {
            return;
        }
        RepositoryConfiguration configuration = new RepositoryConfiguration(this, folderConfiguration);
        PsiResourceItem item = PsiResourceItem.forFile(resourceName, type, this, file, false);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
            this.addIds(result2, items2, file);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items2, folderType, configuration);
            this.mySources.put(file.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, Collections.singletonList(item), folderType, configuration);
            this.mySources.put(file.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
        if (visitor == null) {
            ResourceFolderRepository.$$$reportNull$$$0(22);
        }
        if (visitor.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (ResourceFolderRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor) == ResourceVisitor.VisitResult.ABORT) {
                    ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.ABORT;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (visitResult == null) {
                        ResourceFolderRepository.$$$reportNull$$$0(23);
                    }
                    return visitResult;
                }
            }
        }
        ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.CONTINUE;
        if (visitResult == null) {
            ResourceFolderRepository.$$$reportNull$$$0(24);
        }
        return visitResult;
    }

    @Override
    @GuardedBy(value="ITEM_MAP_LOCK")
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(25);
        }
        if (type == null) {
            ResourceFolderRepository.$$$reportNull$$$0(26);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType type) {
        LinkedListMultimap multimap;
        if (type == null) {
            ResourceFolderRepository.$$$reportNull$$$0(27);
        }
        if ((multimap = this.myResourceTable.get(type)) == null) {
            multimap = LinkedListMultimap.create();
            this.myResourceTable.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        LinkedListMultimap linkedListMultimap = multimap;
        if (linkedListMultimap == null) {
            ResourceFolderRepository.$$$reportNull$$$0(28);
        }
        return linkedListMultimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(29);
        }
        return resourceNamespace;
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull PsiFile file) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(30);
        }
        if (items2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(31);
        }
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(32);
        }
        this.addIds(result2, items2, (PsiElement)file, false);
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull PsiElement element, boolean calledFromPsiListener) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(33);
        }
        if (items2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(34);
        }
        if (element == null) {
            ResourceFolderRepository.$$$reportNull$$$0(35);
        }
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlTag) {
            this.addIds(result2, items2, (XmlTag)element, calledFromPsiListener);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag tag : xmlTags) {
                this.addIds(result2, items2, tag, calledFromPsiListener);
            }
        }
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull XmlTag tag, boolean calledFromPsiListener) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(36);
        }
        if (items2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(37);
        }
        if (tag == null) {
            ResourceFolderRepository.$$$reportNull$$$0(38);
        }
        assert (tag.isValid());
        for (XmlAttribute attribute : tag.getAttributes()) {
            PsiResourceItem item = this.createIdFromAttribute(attribute, calledFromPsiListener);
            if (item == null) continue;
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    @Nullable
    private PsiResourceItem createIdFromAttribute(XmlAttribute attribute, boolean calledFromPsiListener) {
        String id;
        PsiResourceItem item = null;
        String attributeValue = StringUtil.notNullize((String)attribute.getValue()).trim();
        if (attributeValue.startsWith("@+id/") && !attribute.getNamespace().equals("http://schemas.android.com/tools") && ResourceFolderRepository.isValidValueResourceName(id = attributeValue.substring("@+id/".length()))) {
            item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this, attribute.getParent(), calledFromPsiListener);
        }
        return item;
    }

    private boolean scanValueFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull PsiFile file, @NotNull FolderConfiguration folderConfiguration) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(39);
        }
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(40);
        }
        if (folderConfiguration == null) {
            ResourceFolderRepository.$$$reportNull$$$0(41);
        }
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root2 = document.getRootTag();
                if (root2 == null) {
                    return false;
                }
                if (!root2.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root2.getSubTags();
                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    String name = tag.getAttributeValue("name");
                    ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                    if (type == null || !ResourceFolderRepository.isValidValueResourceName(name)) continue;
                    PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, this, tag, false);
                    ResourceFolderRepository.addToResult(result2, item);
                    items2.add(item);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (!ResourceFolderRepository.isValidValueResourceName(attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this, child, false);
                        items2.add(attrItem);
                        ResourceFolderRepository.addToResult(result2, attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items2, ResourceFolderType.VALUES, new RepositoryConfiguration(this, folderConfiguration));
                this.mySources.put(file.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    @Contract(value="null -> false")
    private static boolean isValidValueResourceName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && ValueResourceNameValidator.getErrorText((String)name, null) == null;
    }

    private static boolean isValidResourceFileName(@NotNull String filename, @NotNull ResourceFolderType folderType) {
        if (filename == null) {
            ResourceFolderRepository.$$$reportNull$$$0(42);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(43);
        }
        return FileResourceNameValidator.getErrorTextForFileResource((String)filename.toLowerCase(Locale.ENGLISH), (ResourceFolderType)folderType) == null;
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile2, @NotNull ResourceFolderType folderType) {
        ResourceItemSource<? extends ResourceItem> resFile;
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(44);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(45);
        }
        if ((resFile = this.mySources.get(psiFile2.getVirtualFile())) instanceof PsiResourceFile) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting to PSI ", new Object[]{psiFile2});
        }
        this.scheduleScan(psiFile2, folderType);
        return true;
    }

    private boolean isResourceFolder(@NotNull VirtualFile virtualFile) {
        VirtualFile parentDirectory;
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(46);
        }
        if (virtualFile.isDirectory() && (parentDirectory = virtualFile.getParent()) != null) {
            return parentDirectory.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(@NotNull VirtualFile virtualFile) {
        VirtualFile parent;
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(47);
        }
        return (parent = virtualFile.getParent()) != null && this.isResourceFolder(parent);
    }

    private boolean isResourceFile(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(48);
        }
        return this.isResourceFile(psiFile2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isScanPending(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(49);
        }
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            return this.myPendingScans != null && this.myPendingScans.contains(psiFile2);
        }
    }

    void scheduleScan(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(50);
        }
        ReadAction.run(() -> {
            ResourceFolderType folderType;
            PsiFile psiFile2 = PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
            if (psiFile2 != null && (folderType = ResourceHelper.getFolderType(psiFile2)) != null) {
                this.scheduleScan(psiFile2, folderType);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scheduleScan(@NotNull PsiFile psiFile2, @NotNull ResourceFolderType folderType) {
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(51);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(52);
        }
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.isScanPending(psiFile2)) {
                return;
            }
            if (this.myPendingScans == null) {
                this.myPendingScans = new HashSet<PsiFile>();
            }
            this.myPendingScans.add(psiFile2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!psiFile2.isValid()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (this.isScanPending(psiFile2)) {
                    this.scan(psiFile2, folderType);
                    Object object = this.SCAN_LOCK;
                    synchronized (object) {
                        this.myPendingScans.remove(psiFile2);
                        if (this.myPendingScans.isEmpty()) {
                            this.myPendingScans = null;
                        }
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<PsiFile> files2;
        super.sync();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.myPendingScans == null || this.myPendingScans.isEmpty()) {
                return;
            }
            files2 = new ArrayList<PsiFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (PsiFile file : files2) {
                ResourceFolderType folderType;
                if (!file.isValid() || (folderType = ResourceHelper.getFolderType(file)) == null) continue;
                this.scan(file, folderType);
            }
        });
        object = this.SCAN_LOCK;
        synchronized (object) {
            this.myPendingScans = null;
        }
    }

    @Slow
    public void scanRecursively(@NotNull VirtualFileFilter filter2) {
        if (filter2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(53);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myFacet.getModule().getProject());
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)this.myResourceDir, (VirtualFileFilter)filter2, virtualFile -> {
            if (virtualFile.isDirectory()) {
                return true;
            }
            PsiFile psiFile2 = manager.findFile(virtualFile);
            assert (psiFile2 != null);
            ResourceFolderType type = ResourceHelper.getFolderType(virtualFile);
            assert (type != null);
            this.scan(psiFile2, type);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(@NotNull PsiFile psiFile2, @NotNull ResourceFolderType folderType) {
        if (psiFile2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(54);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(55);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().runReadAction(() -> this.scan(psiFile2, folderType));
            return;
        }
        if (psiFile2.getProject().isDisposed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rescanning ", new Object[]{psiFile2});
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file = psiFile2;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            ResourceItemSource<? extends ResourceItem> source = this.mySources.remove(file.getVirtualFile());
            boolean removed = false;
            if (source != null) {
                removed = this.removeItemsFromSource(source);
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                PsiDirectory fileParent = psiFile2.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFileAsPsi(result2, file, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches(this, ResourceType.values());
            }
        } else if (ResourceFolderRepository.isValidResourceFileName(file.getName(), folderType)) {
            ResourceItemSource<? extends ResourceItem> source = this.mySources.get(file.getVirtualFile());
            if (source instanceof PsiResourceFile && file.getFileType() == StdFileTypes.XML) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                    ++ourFullRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    Object parent = ITEM_MAP_LOCK;
                    synchronized (parent) {
                        ListMultimap<String, ResourceItem> idMultimap = this.myResourceTable.get(ResourceType.ID);
                        if (idMultimap != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item : psiResourceFile) {
                                if (item.getType() != ResourceType.ID) continue;
                                idsBefore.add(item.getName());
                                idItems.add(item);
                            }
                            for (String id : idsBefore) {
                                List mapItems = idMultimap.get((Object)id);
                                if (mapItems == null || mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem delete : toDelete) {
                                    idMultimap.remove((Object)delete.getName(), (Object)delete);
                                }
                            }
                            for (PsiResourceItem item : idItems) {
                                psiResourceFile.removeItem(item);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                    file = this.ensureValid(file);
                    if (file != null) {
                        this.addIds(result2, idItems, file);
                    }
                    if (!idItems.isEmpty()) {
                        for (PsiResourceItem item : idItems) {
                            psiResourceFile.addItem(item);
                        }
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches(this, ResourceType.ID);
                }
            } else {
                if (source != null) {
                    this.removeItemsFromSource(source);
                }
                ++ourFullRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                ResourceType type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                this.clearLayoutlibCaches(file.getVirtualFile(), folderType);
                file = this.ensureValid(file);
                if (file != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile2.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file.getFileType() == StdFileTypes.XML;
                        this.scanFileResourceFileAsPsi(result2, folderType, folderConfiguration, type, idGeneratingFile, file);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches();
                }
            }
        }
        this.commitToRepository(result2);
    }

    private void scan(@NotNull VirtualFile file) {
        PsiFile psiFile2;
        ResourceFolderType folderType;
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(56);
        }
        if ((folderType = ResourceHelper.getFolderType(file)) == null) {
            return;
        }
        if (this.isResourceFile(file) && AndroidFileChangeListener.isRelevantFile(file) && (psiFile2 = this.myPsiManager.findFile(file)) != null) {
            Document document = this.myPsiDocumentManager.getDocument(psiFile2);
            if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Committing ", new Object[]{document});
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    WriteAction.run(() -> this.myPsiDocumentManager.commitDocument(document));
                    ReadAction.run(() -> this.scan(psiFile2, folderType));
                });
                return;
            }
            this.scan(psiFile2, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsForTag(@NotNull ResourceItemSource<PsiResourceItem> source, @NotNull XmlTag xmlTag, @NotNull ResourceType resourceType) {
        if (source == null) {
            ResourceFolderRepository.$$$reportNull$$$0(57);
        }
        if (xmlTag == null) {
            ResourceFolderRepository.$$$reportNull$$$0(58);
        }
        if (resourceType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(59);
        }
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Iterator sourceIter = source.iterator();
            while (sourceIter.hasNext()) {
                PsiResourceItem item = (PsiResourceItem)sourceIter.next();
                if (!item.wasTag(xmlTag)) continue;
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceType);
                List items2 = map2.get((Object)item.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                sourceIter.remove();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsFromSource(@NotNull ResourceItemSource<? extends ResourceItem> source) {
        if (source == null) {
            ResourceFolderRepository.$$$reportNull$$$0(60);
        }
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem resourceItem : source) {
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceItem.getType());
                List items2 = map2.get((Object)resourceItem.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != resourceItem) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                if (!items2.isEmpty()) continue;
                map2.removeAll((Object)resourceItem.getName());
            }
        }
        return changed;
    }

    private void getAndroidTargetDataThenRun(@NotNull VirtualFile file, @NotNull Consumer<AndroidTargetData> consumer) {
        Module module;
        ConfigurationManager configurationManager;
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(61);
        }
        if (consumer == null) {
            ResourceFolderRepository.$$$reportNull$$$0(62);
        }
        if ((configurationManager = ConfigurationManager.findExistingInstance(module = this.myFacet.getModule())) == null) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            IAndroidTarget target = configurationManager.getConfiguration(file).getTarget();
            if (target != null) {
                return AndroidTargetData.getTargetData(target, module);
            }
            return null;
        }, PooledThreadExecutor.INSTANCE).thenAcceptAsync(target -> {
            if (target != null) {
                consumer.accept((AndroidTargetData)target);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void bitmapUpdated(@NotNull VirtualFile bitmap) {
        if (bitmap == null) {
            ResourceFolderRepository.$$$reportNull$$$0(63);
        }
        Module module = this.myFacet.getModule();
        this.getAndroidTargetDataThenRun(bitmap, targetData -> targetData.clearLayoutBitmapCache(module));
    }

    void clearFontCache(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(64);
        }
        this.getAndroidTargetDataThenRun(virtualFile, targetData -> targetData.clearFontCache(virtualFile.getPath()));
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        PsiTreeChangeListener psiTreeChangeListener = this.myPsiListener;
        if (psiTreeChangeListener == null) {
            ResourceFolderRepository.$$$reportNull$$$0(65);
        }
        return psiTreeChangeListener;
    }

    void onFileCreated(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(66);
        }
        this.scan(file);
    }

    @NotNull
    private Project getProject() {
        Project project = this.myFacet.getModule().getProject();
        if (project == null) {
            ResourceFolderRepository.$$$reportNull$$$0(67);
        }
        return project;
    }

    void onFileOrDirectoryRemoved(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(68);
        }
        if (file.isDirectory()) {
            Iterator<Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>>> iterator = this.mySources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>> entry = iterator.next();
                iterator.remove();
                VirtualFile sourceFile = entry.getKey();
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)sourceFile, (boolean)true)) continue;
                ResourceItemSource<? extends ResourceItem> source = entry.getValue();
                this.onSourceRemoved(sourceFile, source);
            }
        } else {
            ResourceItemSource<? extends ResourceItem> source = this.mySources.remove(file);
            if (source != null) {
                this.onSourceRemoved(file, source);
            }
        }
    }

    private void onSourceRemoved(@NotNull VirtualFile file, @NotNull ResourceItemSource<? extends ResourceItem> source) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(69);
        }
        if (source == null) {
            ResourceFolderRepository.$$$reportNull$$$0(70);
        }
        LOG.debug("Removing file from repository ", new Object[]{file});
        boolean removed = this.removeItemsFromSource(source);
        if (removed) {
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(this, ResourceType.values());
        }
        if ((folderType = ResourceHelper.getFolderType(file)) != null) {
            this.clearLayoutlibCaches(file, folderType);
        }
    }

    private void clearLayoutlibCaches(@NotNull VirtualFile file, @NotNull ResourceFolderType folderType) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(71);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(72);
        }
        if ("xml".equals(file.getExtension())) {
            return;
        }
        if (folderType == ResourceFolderType.DRAWABLE) {
            ++ourLayoutlibCacheFlushes;
            this.bitmapUpdated(file);
        } else if (folderType == ResourceFolderType.FONT) {
            ++ourLayoutlibCacheFlushes;
            this.clearFontCache(file);
        }
    }

    private static boolean isItemElement(@NotNull XmlTag xmlTag) {
        String tag;
        if (xmlTag == null) {
            ResourceFolderRepository.$$$reportNull$$$0(73);
        }
        if ((tag = xmlTag.getName()).equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file) {
        if (tag == null) {
            ResourceFolderRepository.$$$reportNull$$$0(74);
        }
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(75);
        }
        if (!tag.isValid()) {
            ResourceItemSource<? extends ResourceItem> resFile = this.mySources.get(file.getVirtualFile());
            if (resFile != null) {
                assert (resFile instanceof PsiResourceFile);
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    if (!pri.wasTag(tag)) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name != null ? this.findValueResourceItem(tag, file, name) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file, @NotNull String name) {
        if (tag == null) {
            ResourceFolderRepository.$$$reportNull$$$0(76);
        }
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(77);
        }
        if (name == null) {
            ResourceFolderRepository.$$$reportNull$$$0(78);
        }
        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file, name, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file, @Nullable String name, @Nullable XmlTag tag) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(79);
        }
        if (type == null || name == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                return null;
            }
            List items2 = map2.get((Object)name);
            assert (items2 != null);
            if (tag != null) {
                for (ResourceItem resourceItem : items2) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item : items2) {
                    if (item instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item).getPsiFile(), file)) continue;
                        return item;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Set<VirtualFile> set = Collections.singleton(this.myResourceDir);
        if (set == null) {
            ResourceFolderRepository.$$$reportNull$$$0(80);
        }
        return set;
    }

    @Override
    @NotNull
    public VfsResourceFile deserializeResourceSourceFile(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath;
        if (stream == null) {
            ResourceFolderRepository.$$$reportNull$$$0(81);
        }
        if (configurations == null) {
            ResourceFolderRepository.$$$reportNull$$$0(82);
        }
        if ((relativePath = stream.readString()) == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
            virtualFile = null;
        }
        return new VfsResourceFile(virtualFile, configuration);
    }

    @Override
    @NotNull
    public BasicFileResourceItem deserializeFileResourceItem(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        Density density;
        String relativePath;
        if (stream == null) {
            ResourceFolderRepository.$$$reportNull$$$0(83);
        }
        if (resourceType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(84);
        }
        if (name == null) {
            ResourceFolderRepository.$$$reportNull$$$0(85);
        }
        if (visibility == null) {
            ResourceFolderRepository.$$$reportNull$$$0(86);
        }
        if (configurations == null) {
            ResourceFolderRepository.$$$reportNull$$$0(87);
        }
        if ((relativePath = stream.readString()) == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        int encodedDensity = stream.readInt();
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        boolean idGenerating = false;
        String folderName = new PathString(relativePath).getParentFileName();
        if (folderName != null) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            boolean bl = idGenerating = folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        }
        if (idGenerating) {
            if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
                virtualFile = null;
            }
            if (encodedDensity == 0) {
                return new VfsFileResourceItem(resourceType, name, configuration, visibility, relativePath, virtualFile);
            }
            density = Density.values()[encodedDensity - 1];
            return new VfsDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, virtualFile, density);
        }
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name, configuration, visibility, relativePath);
        }
        density = Density.values()[encodedDensity - 1];
        return new BasicDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, density);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository, ResourceType ... types) {
        if (repository == null) {
            ResourceFolderRepository.$$$reportNull$$$0(88);
        }
        if (types == null) {
            ResourceFolderRepository.$$$reportNull$$$0(89);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches(repository, types);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 65: 
            case 67: 
            case 80: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 65: 
            case 67: 
            case 80: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 65: 
            case 67: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRepository";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeResourcePath";
                break;
            }
            case 12: 
            case 17: 
            case 30: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsByType";
                break;
            }
            case 16: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: 
            case 43: 
            case 45: 
            case 52: 
            case 55: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 19: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderConfiguration";
                break;
            }
            case 20: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 32: 
            case 40: 
            case 56: 
            case 61: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 46: 
            case 47: 
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 57: 
            case 60: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 58: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 59: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitmap";
                break;
            }
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 82: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepository";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiListener";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 65: 
            case 67: 
            case 80: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "commitToRepository";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "commitToRepositoryWithoutLock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scanFileResourceFileAsPsi";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMap";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addIds";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "scanValueFileAsPsi";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isValidResourceFileName";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiIfNeeded";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFolder";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "scheduleScan";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "scanRecursively";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeItemsForTag";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "removeItemsFromSource";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidTargetDataThenRun";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "bitmapUpdated";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "clearFontCache";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "onFileCreated";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "onFileOrDirectoryRemoved";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "onSourceRemoved";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "clearLayoutlibCaches";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isItemElement";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceItem";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findResourceItem";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "deserializeResourceSourceFile";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFileResourceItem";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "invalidateParentCaches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 65: 
            case 67: 
            case 80: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParsingException
    extends RuntimeException {
        ParsingException(Throwable cause) {
            super(cause);
        }
    }

    private static class Loader
    extends RepositoryLoader<ResourceFolderRepository> {
        @NotNull
        private final ResourceFolderRepository myRepository;
        @NotNull
        private final VirtualFile myResourceDir;
        @NotNull
        private final PsiManager myPsiManager;
        @Nullable
        private final ResourceFolderRepositoryCachingData myCachingData;
        @NotNull
        private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources;
        @NotNull
        private final Map<VirtualFile, ResourceItemSource<BasicResourceItem>> mySources;
        @NotNull
        private final Map<VirtualFile, BasicFileResourceItem> myFileResources;
        @Nullable
        private VirtualFile myLastVirtualFile;
        @Nullable
        private PathString myLastPathString;
        @NotNull
        Set<VirtualFile> myFilesToReparseAsPsi;
        private final FileDocumentManager myFileDocumentManager;

        Loader(@NotNull ResourceFolderRepository repository, @Nullable ResourceFolderRepositoryCachingData cachingData) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(0);
            }
            super(VfsUtilCore.virtualToIoFile((VirtualFile)repository.myResourceDir).toPath(), null, repository.getNamespace());
            this.myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
            this.mySources = new HashMap<VirtualFile, ResourceItemSource<BasicResourceItem>>();
            this.myFileResources = new HashMap<VirtualFile, BasicFileResourceItem>();
            this.myFilesToReparseAsPsi = new HashSet<VirtualFile>();
            this.myRepository = repository;
            this.myResourceDir = repository.myResourceDir;
            this.myPsiManager = repository.myPsiManager;
            this.myCachingData = cachingData;
            this.myDefaultVisibility = ResourceVisibility.UNDEFINED;
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }

        public void load() {
            Executor executor;
            if (!this.myResourceDir.isValid()) {
                return;
            }
            this.loadFromPersistentCache();
            ApplicationManager.getApplication().runReadAction(this::getPsiDirsForListener);
            this.scanResFolder();
            this.populateRepository();
            ApplicationManager.getApplication().runReadAction(() -> this.scanQueuedPsiResources());
            if (this.myCachingData != null && !this.myRepository.hasFreshFileCache() && (executor = this.myCachingData.getCacheCreationExecutor()) != null) {
                executor.execute(this::createCacheFile);
            }
        }

        private void loadFromPersistentCache() {
            if (this.myCachingData == null) {
                return;
            }
            byte[] fileHeader = this.getCacheFileHeader(this.myCachingData);
            try (Base128InputStream stream2 = new Base128InputStream(this.myCachingData.getCacheFile());){
                if (!stream2.validateContents(fileHeader)) {
                    return;
                }
                ResourceSerializationUtil.readResourcesFromStream(stream2, Maps.newHashMapWithExpectedSize((int)1000), null, this.myRepository, item -> this.addResourceItem((BasicResourceItem)item, this.myRepository));
            }
            catch (NoSuchFileException stream2) {
            }
            catch (Throwable e) {
                this.mySources.clear();
                this.myFileResources.clear();
                LOG.warn("Failed to load resources from cache file " + this.myCachingData.getCacheFile().toString(), e);
            }
        }

        @NotNull
        protected byte[] getCacheFileHeader(@NotNull ResourceFolderRepositoryCachingData cachingData) {
            if (cachingData == null) {
                Loader.$$$reportNull$$$0(1);
            }
            byte[] byArray = ResourceSerializationUtil.getCacheFileHeader(stream -> {
                stream.write(CACHE_FILE_HEADER);
                stream.writeString(ResourceFolderRepository.CACHE_FILE_FORMAT_VERSION);
                stream.writeString(this.myResourceDir.getPath());
                stream.writeString(cachingData.getCodeVersion());
            });
            if (byArray == null) {
                Loader.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        private void createCacheFile() {
            assert (this.myCachingData != null);
            byte[] header = this.getCacheFileHeader(this.myCachingData);
            try {
                ResourceSerializationUtil.createPersistentCache(this.myCachingData.getCacheFile(), header, stream -> ResourceSerializationUtil.writeResourcesToStream(this.myResources, stream, config -> true));
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scanResFolder() {
            try {
                void var3_7;
                VirtualFile[] virtualFileArray = this.myResourceDir.getChildren();
                int n = virtualFileArray.length;
                boolean bl = false;
                while (var3_7 < n) {
                    String folderName;
                    RepositoryLoader.FolderInfo folderInfo;
                    VirtualFile subDir = virtualFileArray[var3_7];
                    if (subDir.isValid() && subDir.isDirectory() && (folderInfo = RepositoryLoader.FolderInfo.create(folderName = subDir.getName(), this.myFolderConfigCache)) != null) {
                        RepositoryConfiguration configuration = this.getConfiguration(this.myRepository, folderInfo.configuration);
                        for (VirtualFile file2 : subDir.getChildren()) {
                            if (file2.getName().startsWith(".")) continue;
                            if (this.myFileDocumentManager.isFileModified(file2)) {
                                this.myFilesToReparseAsPsi.add(file2);
                                continue;
                            }
                            if (folderInfo.folderType == ResourceFolderType.VALUES ? this.mySources.containsKey(file2) : this.myFileResources.containsKey(file2)) {
                                if (!Loader.isParsableFile(file2, folderInfo)) continue;
                                this.countCacheHit();
                                continue;
                            }
                            PathString pathString = FileExtensions.toPathString(file2);
                            this.myLastVirtualFile = file2;
                            this.myLastPathString = pathString;
                            try {
                                this.loadResourceFile(pathString, folderInfo, configuration);
                                if (!Loader.isParsableFile(file2, folderInfo)) continue;
                                this.countCacheMiss();
                            }
                            catch (ParsingException e) {
                                this.myFilesToReparseAsPsi.add(file2);
                            }
                        }
                    }
                    ++var3_7;
                }
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
            super.finishLoading(this.myRepository);
            for (Map.Entry<VirtualFile, BasicFileResourceItem> entry : this.myFileResources.entrySet()) {
                VirtualFile virtualFile = entry.getKey();
                BasicFileResourceItem item = entry.getValue();
                ResourceItemSource source = this.mySources.computeIfAbsent(virtualFile, file -> new VfsResourceFile((VirtualFile)file, item.getRepositoryConfiguration()));
                source.addItem(item);
            }
            ArrayList<ResourceItemSource<BasicResourceItem>> sortedSources = new ArrayList<ResourceItemSource<BasicResourceItem>>(this.mySources.values());
            sortedSources.sort(SOURCE_COMPARATOR);
            for (ResourceItemSource resourceItemSource : sortedSources) {
                for (ResourceItem item : resourceItemSource) {
                    this.getOrCreateMap(item.getType()).put((Object)item.getName(), (Object)item);
                }
            }
        }

        private void loadResourceFile(@NotNull PathString file, @NotNull RepositoryLoader.FolderInfo folderInfo, @NotNull RepositoryConfiguration configuration) {
            if (file == null) {
                Loader.$$$reportNull$$$0(3);
            }
            if (folderInfo == null) {
                Loader.$$$reportNull$$$0(4);
            }
            if (configuration == null) {
                Loader.$$$reportNull$$$0(5);
            }
            if (folderInfo.resourceType == null) {
                if (Loader.isXmlFile(file)) {
                    this.parseValueResourceFile(file, configuration);
                }
            } else if (ResourceFolderRepository.isValidResourceFileName(file.getFileName(), folderInfo.folderType)) {
                if (Loader.isXmlFile(file) && folderInfo.isIdGenerating) {
                    this.parseIdGeneratingResourceFile(file, configuration);
                }
                BasicFileResourceItem item = this.createFileResourceItem(file, folderInfo.resourceType, configuration, folderInfo.isIdGenerating);
                this.addResourceItem((BasicResourceItem)item, (ResourceFolderRepository)item.getRepository());
            }
        }

        private static boolean isParsableFile(@NotNull VirtualFile file, @NotNull RepositoryLoader.FolderInfo folderInfo) {
            if (file == null) {
                Loader.$$$reportNull$$$0(6);
            }
            if (folderInfo == null) {
                Loader.$$$reportNull$$$0(7);
            }
            return (folderInfo.folderType == ResourceFolderType.VALUES || folderInfo.isIdGenerating) && Loader.isXmlFile(file.getName());
        }

        private void populateRepository() {
            this.myRepository.mySources.putAll(this.mySources);
            this.myRepository.commitToRepositoryWithoutLock(this.myResources);
        }

        @NotNull
        private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
            if (resourceType == null) {
                Loader.$$$reportNull$$$0(8);
            }
            ListMultimap listMultimap = this.myResources.computeIfAbsent(resourceType, type -> LinkedListMultimap.create());
            if (listMultimap == null) {
                Loader.$$$reportNull$$$0(9);
            }
            return listMultimap;
        }

        @Override
        @NotNull
        protected InputStream getInputStream(@NotNull PathString file) throws IOException {
            VirtualFile virtualFile;
            if (file == null) {
                Loader.$$$reportNull$$$0(10);
            }
            if ((virtualFile = this.getVirtualFile(file)) == null) {
                throw new NoSuchFileException(file.getNativePath());
            }
            InputStream inputStream = virtualFile.getInputStream();
            if (inputStream == null) {
                Loader.$$$reportNull$$$0(11);
            }
            return inputStream;
        }

        @Nullable
        private VirtualFile getVirtualFile(@NotNull PathString file) {
            if (file == null) {
                Loader.$$$reportNull$$$0(12);
            }
            return file.equals((Object)this.myLastPathString) ? this.myLastVirtualFile : FileExtensions.toVirtualFile(file);
        }

        private void getPsiDirsForListener() {
            PsiDirectory resourceDirPsi = this.myPsiManager.findDirectory(this.myResourceDir);
            if (resourceDirPsi != null) {
                resourceDirPsi.getSubdirectories();
            }
        }

        @Override
        protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull ResourceFolderRepository repository) {
            if (item == null) {
                Loader.$$$reportNull$$$0(13);
            }
            if (repository == null) {
                Loader.$$$reportNull$$$0(14);
            }
            if (item instanceof BasicValueResourceItemBase) {
                VfsResourceFile sourceFile = (VfsResourceFile)((BasicValueResourceItemBase)item).getSourceFile();
                VirtualFile virtualFile = sourceFile.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    sourceFile.addItem(item);
                    this.mySources.put(virtualFile, sourceFile);
                }
            } else if (item instanceof VfsFileResourceItem) {
                VfsFileResourceItem fileResourceItem = (VfsFileResourceItem)item;
                VirtualFile virtualFile = fileResourceItem.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else if (item instanceof BasicFileResourceItem) {
                BasicFileResourceItem fileResourceItem = (BasicFileResourceItem)item;
                VirtualFile virtualFile = this.getVirtualFile(fileResourceItem.getSource());
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else {
                throw new IllegalArgumentException("Unexpected type: " + item.getClass().getName());
            }
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file, @NotNull ResourceType resourceType, @NotNull RepositoryConfiguration configuration, boolean idGenerating) {
            DensityQualifier densityQualifier;
            if (file == null) {
                Loader.$$$reportNull$$$0(15);
            }
            if (resourceType == null) {
                Loader.$$$reportNull$$$0(16);
            }
            if (configuration == null) {
                Loader.$$$reportNull$$$0(17);
            }
            String resourceName = Loader.getResourceName(file);
            ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
            Density density = null;
            if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
                density = densityQualifier.getValue();
            }
            return this.createFileResourceItem(file, resourceType, resourceName, configuration, visibility, density, idGenerating);
        }

        @Override
        @NotNull
        protected ResourceSourceFile createResourceSourceFile(@NotNull PathString file, @NotNull RepositoryConfiguration configuration) {
            if (file == null) {
                Loader.$$$reportNull$$$0(18);
            }
            if (configuration == null) {
                Loader.$$$reportNull$$$0(19);
            }
            VirtualFile virtualFile = this.getVirtualFile(file);
            return new VfsResourceFile(virtualFile, configuration);
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file, @NotNull ResourceType type, @NotNull String name, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable Density density, boolean idGenerating) {
            if (file == null) {
                Loader.$$$reportNull$$$0(20);
            }
            if (type == null) {
                Loader.$$$reportNull$$$0(21);
            }
            if (name == null) {
                Loader.$$$reportNull$$$0(22);
            }
            if (configuration == null) {
                Loader.$$$reportNull$$$0(23);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(24);
            }
            if (!idGenerating) {
                BasicFileResourceItem basicFileResourceItem = super.createFileResourceItem(file, type, name, configuration, visibility, density);
                if (basicFileResourceItem == null) {
                    Loader.$$$reportNull$$$0(25);
                }
                return basicFileResourceItem;
            }
            VirtualFile virtualFile = this.getVirtualFile(file);
            String relativePath = this.getResRelativePath(file);
            return density == null ? new VfsFileResourceItem(type, name, configuration, visibility, relativePath, virtualFile) : new VfsDensityBasedFileResourceItem(type, name, configuration, visibility, relativePath, virtualFile, density);
        }

        @Override
        protected void handleParsingError(@NotNull PathString file, @NotNull Exception e) {
            if (file == null) {
                Loader.$$$reportNull$$$0(26);
            }
            if (e == null) {
                Loader.$$$reportNull$$$0(27);
            }
            throw new ParsingException(e);
        }

        private void scanQueuedPsiResources() {
            for (VirtualFile file : this.myFilesToReparseAsPsi) {
                this.myRepository.scan(file);
            }
        }

        private void countCacheHit() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
        }

        private void countCacheMiss() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
            ++this.myRepository.myNumXmlFilesLoadedInitiallyFromSources;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 25: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 25: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachingData";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRepository$Loader";
                    break;
                }
                case 3: 
                case 6: 
                case 10: 
                case 12: 
                case 15: 
                case 18: 
                case 20: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderInfo";
                    break;
                }
                case 5: 
                case 17: 
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 8: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceType";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibility";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepository$Loader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCacheFileHeader";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileResourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCacheFileHeader";
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 25: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadResourceFile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isParsableFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateMap";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getInputStream";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getVirtualFile";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourceItem";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileResourceItem";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "createResourceSourceFile";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "handleParsingError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 9: 
                case 11: 
                case 25: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class IncrementalUpdatePsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;

        private IncrementalUpdatePsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(0);
            }
            if ((psiFile2 = event.getFile()) != null && AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                if (ResourceFolderRepository.this.isScanPending(psiFile2)) {
                    return;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile2);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            XmlTag parentTag;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag)) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ResourceItemSource<? extends ResourceItem> source = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                if (source != null) {
                                    assert (source instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                    String name = tag.getAttributeValue("name");
                                    if (ResourceFolderRepository.isValidValueResourceName(name)) {
                                        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                                        if (type == ResourceType.STYLEABLE) {
                                            ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                                            return;
                                        }
                                        if (type != null) {
                                            PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, ResourceFolderRepository.this, tag, true);
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceFolderRepository.this.getOrCreateMap(type).put((Object)name, (Object)item);
                                                psiResourceFile.addItem(item);
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            if ((parentTag = tag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ResourceItem parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                if (parentItem instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)parentItem).recomputeValue()) {
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    }
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile2);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile2);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                    } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == StdFileTypes.XML) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            XmlAttribute attribute;
                            PsiResourceItem newIdResource;
                            if (child instanceof XmlTag) {
                                ResourceItemSource<? extends ResourceItem> resFile;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ArrayList<PsiResourceItem> ids2 = new ArrayList<PsiResourceItem>();
                                HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                ResourceFolderRepository.this.addIds(result2, ids2, child, true);
                                ResourceFolderRepository.this.commitToRepository(result2);
                                if (!ids2.isEmpty() && (resFile = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile())) != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                    for (PsiResourceItem id : ids2) {
                                        psiResourceFile.addItem(id);
                                    }
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                                }
                                return;
                            }
                            if ((child instanceof XmlAttribute || parent instanceof XmlAttribute) && (newIdResource = ResourceFolderRepository.this.createIdFromAttribute(attribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : (XmlAttribute)child, true)) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                synchronized (object) {
                                    ResourceItemSource<? extends ResourceItem> resFile = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                    if (resFile != null) {
                                        assert (resFile instanceof PsiResourceFile);
                                        PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                        psiResourceFile.addItem(newIdResource);
                                        ResourceFolderRepository.this.getOrCreateMap(ResourceType.ID).put((Object)newIdResource.getName(), (Object)newIdResource);
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                                        return;
                                    }
                                }
                            }
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile2.getVirtualFile());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            block25: {
                ResourceFolderType folderType;
                PsiFile psiFile2;
                block26: {
                    PsiElement parent;
                    PsiElement child;
                    block27: {
                        XmlTag parentTag;
                        if (event == null) {
                            IncrementalUpdatePsiListener.$$$reportNull$$$0(1);
                        }
                        if ((psiFile2 = event.getFile()) == null || !AndroidFileChangeListener.isRelevantFile(psiFile2)) break block25;
                        if (ResourceFolderRepository.this.isScanPending(psiFile2)) {
                            return;
                        }
                        folderType = ResourceHelper.getFolderType(psiFile2);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(psiFile2)) break block25;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block26;
                        if (!(child instanceof XmlTag)) break block27;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag = (XmlTag)parent) != null) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                return;
                            }
                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                            if (resourceItem instanceof PsiResourceItem) {
                                ResourceItem declareStyleable;
                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                return;
                            }
                        }
                        if (ResourceFolderRepository.isItemElement(tag)) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                return;
                            }
                            ResourceItemSource<? extends ResourceItem> source = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                            if (source != null) {
                                ResourceType type;
                                String name;
                                PsiResourceFile resourceFile = (PsiResourceFile)source;
                                if (!tag.isValid()) {
                                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile2);
                                    if (item == null) {
                                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                                        return;
                                    }
                                    name = item.getName();
                                } else {
                                    name = tag.getAttributeValue("name");
                                }
                                if (name != null && (type = AndroidResourceUtil.getResourceTypeForResourceTag(tag)) != null) {
                                    Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                    synchronized (object) {
                                        boolean removed = ResourceFolderRepository.this.removeItemsForTag(resourceFile, tag, type);
                                        if (removed) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                        }
                                    }
                                }
                                return;
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                        break block25;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile2);
                        break block25;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile2);
                        break block25;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                    }
                    break block25;
                }
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == StdFileTypes.XML) {
                    ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                } else if (folderType == ResourceFolderType.FONT) {
                    ResourceFolderRepository.this.clearFontCache(psiFile2.getVirtualFile());
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(2);
            }
            if ((psiFile2 = event.getFile()) != null) {
                if (ResourceFolderRepository.this.isScanPending(psiFile2)) {
                    return;
                }
                if (AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                    PsiElement parent;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile2);
                    if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == StdFileTypes.XML) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                PsiElement oldChild = event.getOldChild();
                                PsiElement newChild = event.getNewChild();
                                if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                    String oldText = ((XmlAttributeValue)oldChild).getValue().trim();
                                    String newText = ((XmlAttributeValue)newChild).getValue().trim();
                                    if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                        ResourceItemSource<? extends ResourceItem> source = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                        if (source != null) {
                                            ResourceUrl newResourceUrl;
                                            ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                            if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                                return;
                                            }
                                            if (this.handleIdsChange(source, attribute.getParent())) {
                                                return;
                                            }
                                        }
                                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                                    }
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                PsiElement grandParent = parent2.getParent();
                                if (grandParent instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                assert (grandParent instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)grandParent;
                                XmlTag xmlTag = attribute.getParent();
                                String oldText = StringUtil.notNullize((String)event.getOldChild().getText()).trim();
                                String newText = StringUtil.notNullize((String)event.getNewChild().getText()).trim();
                                if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                    ResourceItemSource<? extends ResourceItem> resFile = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                    if (resFile != null) {
                                        ResourceUrl newResourceUrl;
                                        ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                        if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                            return;
                                        }
                                        if (this.handleIdsChange(resFile, xmlTag)) {
                                            return;
                                        }
                                    }
                                    ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                                } else if (folderType != ResourceFolderType.VALUES) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlTag) {
                                XmlTag parentTag = (XmlTag)parent3;
                                if (AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile2);
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(xmlTag);
                                    if (type != null) {
                                        String newName2;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName2 = event.getNewChild().getText())) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile2, oldName, xmlTag);
                                        if (item != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ListMultimap<String, ResourceItem> map2 = ResourceFolderRepository.this.myResourceTable.get(item.getType());
                                                if (map2 != null) {
                                                    map2.remove((Object)oldName, (Object)item);
                                                    if (ResourceFolderRepository.isValidValueResourceName(newName2)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, type, ResourceFolderRepository.this, xmlTag, true);
                                                        map2.put((Object)newName2, (Object)newItem);
                                                        ResourceItemSource<? extends ResourceItem> resFile = ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                                        if (resFile != null) {
                                                            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                            resourceFile.removeItem((PsiResourceItem)item);
                                                            resourceFile.addItem(newItem);
                                                        } else assert (false) : item;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                                }
                                            }
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                    } else if (folderType == ResourceFolderType.COLOR) {
                        PsiElement parent4 = event.getParent();
                        if (parent4 instanceof XmlElement) {
                            PsiElement attribute;
                            if (parent4 instanceof XmlComment) {
                                return;
                            }
                            if (parent4 instanceof XmlAttributeValue && (attribute = parent4.getParent()) instanceof XmlProcessingInstruction) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            return;
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile2.getVirtualFile());
                    } else if (folderType != null && (parent = event.getParent()) instanceof XmlElement) {
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleIdsChange(@NotNull ResourceItemSource<? extends ResourceItem> resFile, @NotNull XmlTag xmlTag) {
            if (resFile == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(3);
            }
            if (xmlTag == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(4);
            }
            if (!(resFile instanceof PsiResourceFile)) {
                return false;
            }
            PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
            synchronized (object) {
                ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                ArrayList<PsiResourceItem> ids2 = new ArrayList<PsiResourceItem>();
                ResourceFolderRepository.this.addIds(result2, ids2, xmlTag, true);
                ResourceFolderRepository.this.commitToRepository(result2);
                ids2.forEach(psiResourceFile::addItem);
                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                return true;
            }
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile2) {
            XmlTag style;
            if (psiFile2 == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(5);
            }
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                boolean cleared;
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile2);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                    return;
                }
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile2);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile2);
                    assert (folderType != null);
                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public final void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(6);
            }
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                IncrementalUpdatePsiListener.$$$reportNull$$$0(7);
            }
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged ? parent != event.getChild() : event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                return;
            }
            if (parent != null && parent.getChildren().length == 1 && parent.getChildren()[0] instanceof PsiWhiteSpace) {
                return;
            }
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 != null && AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                ResourceFolderType folderType;
                VirtualFile file = psiFile2.getVirtualFile();
                if (file != null && (folderType = ResourceHelper.getFolderType(psiFile2)) != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                    ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlTag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepository$IncrementalUpdatePsiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleIdsChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleValueXmlTextEdit";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildrenChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SimplePsiListener
    extends PsiTreeAnyChangeAbstractAdapter {
        private SimplePsiListener() {
        }

        protected void onChange(@Nullable PsiFile psiFile2) {
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile2);
            if (folderType != null && psiFile2 != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                ResourceFolderRepository.this.scheduleScan(psiFile2, folderType);
            }
        }
    }
}

