/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiResourceItem
implements ResourceItem {
    @NotNull
    private final String myName;
    @NotNull
    private final ResourceType myType;
    @NotNull
    private ResourceFolderRepository myOwner;
    @Nullable
    private ResourceValue myResourceValue;
    @Nullable
    private PsiResourceFile mySourceFile;
    @Nullable
    private final WeakReference<XmlTag> myOriginalTag;
    @Nullable
    private SmartPsiElementPointer<PsiFile> myFilePointer;
    @Nullable
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    @Nullable
    private AsyncInitializationData myAsyncInitData;

    private PsiResourceItem(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @Nullable XmlTag tag, @NotNull PsiFile file, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            PsiResourceItem.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PsiResourceItem.$$$reportNull$$$0(3);
        }
        this.myName = name;
        this.myType = type;
        this.myOriginalTag = tag == null ? null : new WeakReference<XmlTag>(tag);
        this.myOwner = owner;
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)file.getProject());
        if (calledFromPsiListener) {
            AsyncInitializationData initData;
            this.myAsyncInitData = initData = new AsyncInitializationData(file, tag);
            Application application = ApplicationManager.getApplication();
            application.executeOnPooledThread(() -> application.runReadAction(() -> {
                try {
                    SmartPsiElementPointer filePointer = pointerManager.createSmartPsiElementPointer((PsiElement)initData.psiFile);
                    SmartPsiElementPointer tagPointer = initData.xmlTag == null ? null : pointerManager.createSmartPsiElementPointer((PsiElement)initData.xmlTag, initData.psiFile);
                    AsyncInitializationData asyncInitializationData = initData;
                    synchronized (asyncInitializationData) {
                        this.myFilePointer = filePointer;
                        this.myTagPointer = tagPointer;
                    }
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
                this.myAsyncInitData = null;
            }));
        } else {
            this.myFilePointer = pointerManager.createSmartPsiElementPointer((PsiElement)file);
            this.myTagPointer = tag == null ? null : pointerManager.createSmartPsiElementPointer((PsiElement)tag, file);
        }
    }

    @NotNull
    public static PsiResourceItem forXmlTag(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @NotNull XmlTag tag, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(4);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            PsiResourceItem.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(7);
        }
        return new PsiResourceItem(name, type, owner, tag, tag.getContainingFile(), calledFromPsiListener);
    }

    @NotNull
    public static PsiResourceItem forFile(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @NotNull PsiFile file, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            PsiResourceItem.$$$reportNull$$$0(10);
        }
        if (file == null) {
            PsiResourceItem.$$$reportNull$$$0(11);
        }
        return new PsiResourceItem(name, type, owner, null, file, calledFromPsiListener);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsiResourceItem.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            PsiResourceItem.$$$reportNull$$$0(13);
        }
        return resourceType;
    }

    @NotNull
    public ResourceFolderRepository getRepository() {
        ResourceFolderRepository resourceFolderRepository = this.myOwner;
        if (resourceFolderRepository == null) {
            PsiResourceItem.$$$reportNull$$$0(14);
        }
        return resourceFolderRepository;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myOwner.getNamespace();
        if (resourceNamespace == null) {
            PsiResourceItem.$$$reportNull$$$0(15);
        }
        return resourceNamespace;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.getNamespace(), this.myType, this.myName);
    }

    @NotNull
    public FolderConfiguration getConfiguration() {
        PsiResourceFile source = this.getSourceFile();
        assert (source != null) : "getConfiguration called on a PsiResourceItem with no source";
        FolderConfiguration folderConfiguration = source.getFolderConfiguration();
        if (folderConfiguration == null) {
            PsiResourceItem.$$$reportNull$$$0(16);
        }
        return folderConfiguration;
    }

    @NotNull
    public String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            String string = this.myType.getName() + "-" + qualifiers + "/" + this.myName;
            if (string == null) {
                PsiResourceItem.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = this.myType.getName() + "/" + this.myName;
        if (string == null) {
            PsiResourceItem.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public PsiResourceFile getSourceFile() {
        if (this.mySourceFile != null) {
            return this.mySourceFile;
        }
        PsiFile psiFile2 = this.getPsiFile();
        if (psiFile2 == null) {
            return null;
        }
        PsiElement parent = AndroidPsiUtils.getPsiParentSafely((PsiElement)psiFile2);
        if (!(parent instanceof PsiDirectory)) {
            return null;
        }
        String name = ((PsiDirectory)parent).getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
        if (folderType == null) {
            return null;
        }
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)name);
        if (folderConfiguration == null) {
            return null;
        }
        return new PsiResourceFile(psiFile2, (Iterable<PsiResourceItem>)ImmutableList.of((Object)this), folderType, new RepositoryConfiguration(this.myOwner, folderConfiguration));
    }

    public void setSourceFile(@Nullable PsiResourceFile sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @Nullable
    public ResourceValue getResourceValue() {
        if (this.myResourceValue == null) {
            XmlTag tag = this.getTag();
            if (tag == null) {
                String path2;
                PsiResourceFile source = this.getSourceFile();
                assert (source != null) : "getResourceValue called on a PsiResourceItem with no source";
                ResourceType type = this.getType();
                Density density = type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                VirtualFile virtualFile = source.getVirtualFile();
                String string = path2 = virtualFile == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getAbsolutePath();
                this.myResourceValue = density != null ? new DensityBasedResourceValueImpl(this.getNamespace(), this.myType, this.myName, path2, density, null) : new ResourceValueImpl(this.getNamespace(), this.myType, this.myName, path2, null);
            } else {
                this.myResourceValue = this.parseXmlToResourceValue(tag);
            }
        }
        return this.myResourceValue;
    }

    @Nullable
    public PathString getSource() {
        PsiFile psiFile2 = this.getPsiFile();
        if (psiFile2 == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        return virtualFile == null ? null : new PathString(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
    }

    public boolean isFileBased() {
        return this.myOriginalTag == null;
    }

    @Nullable
    private Density getFolderDensity() {
        FolderConfiguration configuration = this.getConfiguration();
        DensityQualifier densityQualifier = configuration.getDensityQualifier();
        if (densityQualifier != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    @Nullable
    private ResourceValue parseXmlToResourceValue(final @Nullable XmlTag tag) {
        Object value2;
        if (tag == null || !tag.isValid()) {
            return null;
        }
        switch (this.myType) {
            case STYLE: {
                String parent = PsiResourceItem.getAttributeValue(tag, "parent");
                value2 = PsiResourceItem.parseStyleValue(tag, new StyleResourceValueImpl(this.getNamespace(), this.myName, parent, null));
                break;
            }
            case STYLEABLE: {
                value2 = this.parseDeclareStyleable(tag, new StyleableResourceValueImpl(this.getNamespace(), this.myName, null, null));
                break;
            }
            case ATTR: {
                value2 = PsiResourceItem.parseAttrValue(tag, new AttrResourceValueImpl(this.getNamespace(), this.myName, null));
                break;
            }
            case ARRAY: {
                value2 = PsiResourceItem.parseArrayValue(tag, new ArrayResourceValueImpl(this.getNamespace(), this.myName, null){

                    protected int getDefaultIndex() {
                        String index = tag.getAttributeValue("index", "http://schemas.android.com/tools");
                        if (index != null) {
                            return Integer.parseInt(index);
                        }
                        return super.getDefaultIndex();
                    }
                });
                break;
            }
            case PLURALS: {
                value2 = PsiResourceItem.parsePluralsValue(tag, new PluralsResourceValueImpl(this.getNamespace(), this.myName, null, null){

                    public String getValue() {
                        String value2;
                        String quantity = tag.getAttributeValue("quantity", "http://schemas.android.com/tools");
                        if (quantity != null && (value2 = this.getValue(quantity)) != null) {
                            return value2;
                        }
                        return super.getValue();
                    }
                });
                break;
            }
            case STRING: {
                value2 = PsiResourceItem.parseTextValue(tag, new PsiTextResourceValue(this.getNamespace(), this.myName, null, null, null));
                break;
            }
            default: {
                value2 = PsiResourceItem.parseValue(tag, new ResourceValueImpl(this.getNamespace(), this.myType, this.myName, null));
            }
        }
        value2.setNamespaceResolver(ResourceHelper.getNamespaceResolver((XmlElement)tag));
        return value2;
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(19);
        }
        if (attributeName == null) {
            PsiResourceItem.$$$reportNull$$$0(20);
        }
        return tag.getAttributeValue(attributeName);
    }

    @NotNull
    private StyleableResourceValueImpl parseDeclareStyleable(@NotNull XmlTag tag, @NotNull StyleableResourceValueImpl declareStyleable) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(21);
        }
        if (declareStyleable == null) {
            PsiResourceItem.$$$reportNull$$$0(22);
        }
        for (XmlTag child : tag.getSubTags()) {
            ResourceReference resolvedAttr;
            ResourceUrl url;
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name) || (url = ResourceUrl.parseAttrReference((String)name)) == null || (resolvedAttr = url.resolve(this.getNamespace(), ResourceHelper.getNamespaceResolver((XmlElement)tag))) == null) continue;
            AttrResourceValueImpl attr = PsiResourceItem.parseAttrValue(child, new AttrResourceValueImpl(resolvedAttr, null));
            declareStyleable.addValue((AttrResourceValue)attr);
        }
        StyleableResourceValueImpl styleableResourceValueImpl = declareStyleable;
        if (styleableResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(23);
        }
        return styleableResourceValueImpl;
    }

    @NotNull
    private static StyleResourceValueImpl parseStyleValue(@NotNull XmlTag tag, @NotNull StyleResourceValueImpl styleValue) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(24);
        }
        if (styleValue == null) {
            PsiResourceItem.$$$reportNull$$$0(25);
        }
        for (XmlTag child : tag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name)) continue;
            String value2 = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(styleValue.getNamespace(), name, value2, styleValue.getLibraryName());
            itemValue.setNamespaceResolver(ResourceHelper.getNamespaceResolver((XmlElement)child));
            styleValue.addItem((StyleItemResourceValue)itemValue);
        }
        StyleResourceValueImpl styleResourceValueImpl = styleValue;
        if (styleResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(26);
        }
        return styleResourceValueImpl;
    }

    @NotNull
    private static AttrResourceValueImpl parseAttrValue(@NotNull XmlTag attrTag, @NotNull AttrResourceValueImpl attrValue) {
        if (attrTag == null) {
            PsiResourceItem.$$$reportNull$$$0(27);
        }
        if (attrValue == null) {
            PsiResourceItem.$$$reportNull$$$0(28);
        }
        attrValue.setDescription(PsiResourceItem.getDescription(attrTag));
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String formatString = PsiResourceItem.getAttributeValue(attrTag, "format");
        if (formatString != null) {
            formats.addAll(AttributeFormat.parse((String)formatString));
        }
        for (XmlTag child : attrTag.getSubTags()) {
            String tagName = child.getName();
            if ("enum".equals(tagName)) {
                formats.add(AttributeFormat.ENUM);
            } else if ("flag".equals(tagName)) {
                formats.add(AttributeFormat.FLAGS);
            }
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null) continue;
            Integer numericValue = null;
            String value2 = PsiResourceItem.getAttributeValue(child, "value");
            if (value2 != null) {
                try {
                    numericValue = Long.decode(value2).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            attrValue.addValue(name, numericValue, PsiResourceItem.getDescription(child));
        }
        attrValue.setFormats(formats);
        AttrResourceValueImpl attrResourceValueImpl = attrValue;
        if (attrResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(29);
        }
        return attrResourceValueImpl;
    }

    @Nullable
    private static String getDescription(@NotNull XmlTag tag) {
        XmlComment comment;
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(30);
        }
        if ((comment = XmlUtil.findPreviousComment((PsiElement)tag)) != null) {
            String text = comment.getCommentText();
            return text.trim();
        }
        return null;
    }

    @NotNull
    private static ArrayResourceValueImpl parseArrayValue(@NotNull XmlTag tag, @NotNull ArrayResourceValueImpl arrayValue) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(31);
        }
        if (arrayValue == null) {
            PsiResourceItem.$$$reportNull$$$0(32);
        }
        for (XmlTag child : tag.getSubTags()) {
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            arrayValue.addElement(text);
        }
        ArrayResourceValueImpl arrayResourceValueImpl = arrayValue;
        if (arrayResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(33);
        }
        return arrayResourceValueImpl;
    }

    @NotNull
    private static PluralsResourceValueImpl parsePluralsValue(@NotNull XmlTag tag, @NotNull PluralsResourceValueImpl value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(34);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(35);
        }
        for (XmlTag child : tag.getSubTags()) {
            String quantity = child.getAttributeValue("quantity");
            if (quantity == null) continue;
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            value2.addPlural(quantity, text);
        }
        PluralsResourceValueImpl pluralsResourceValueImpl = value2;
        if (pluralsResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(36);
        }
        return pluralsResourceValueImpl;
    }

    @NotNull
    private static ResourceValueImpl parseValue(@NotNull XmlTag tag, @NotNull ResourceValueImpl value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(37);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(38);
        }
        String text = ResourceHelper.getTextContent(tag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value2.setValue(text);
        ResourceValueImpl resourceValueImpl = value2;
        if (resourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(39);
        }
        return resourceValueImpl;
    }

    @NotNull
    private static PsiTextResourceValue parseTextValue(@NotNull XmlTag tag, @NotNull PsiTextResourceValue value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(40);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(41);
        }
        String text = ResourceHelper.getTextContent(tag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value2.setValue(text);
        PsiTextResourceValue psiTextResourceValue = value2;
        if (psiTextResourceValue == null) {
            PsiResourceItem.$$$reportNull$$$0(42);
        }
        return psiTextResourceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlTag getTag() {
        AsyncInitializationData initData = this.myAsyncInitData;
        if (initData == null) {
            return PsiResourceItem.validElementOrNull(this.myTagPointer == null ? null : (XmlTag)this.myTagPointer.getElement());
        }
        AsyncInitializationData asyncInitializationData = initData;
        synchronized (asyncInitializationData) {
            return PsiResourceItem.validElementOrNull(this.myTagPointer != null ? (XmlTag)this.myTagPointer.getElement() : initData.xmlTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiFile getPsiFile() {
        AsyncInitializationData initData = this.myAsyncInitData;
        if (initData == null) {
            return PsiResourceItem.validElementOrNull(this.myFilePointer == null ? null : (PsiFile)this.myFilePointer.getElement());
        }
        AsyncInitializationData asyncInitializationData = initData;
        synchronized (asyncInitializationData) {
            return PsiResourceItem.validElementOrNull(this.myFilePointer != null ? (PsiFile)this.myFilePointer.getElement() : initData.psiFile);
        }
    }

    private static <E extends PsiElement> E validElementOrNull(@Nullable E psiElement) {
        return psiElement == null || !psiElement.isValid() ? null : (E)psiElement;
    }

    public boolean wasTag(@NotNull XmlTag tag) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(43);
        }
        return this.myOriginalTag != null && tag == this.myOriginalTag.get() || tag == this.getTag();
    }

    public boolean recomputeValue() {
        if (this.myResourceValue == null) {
            return false;
        }
        this.myResourceValue = null;
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        PsiFile file;
        MoreObjects.ToStringHelper helper2 = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.myName).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.myType);
        XmlTag tag = this.getTag();
        if (tag != null) {
            helper2.add("tag", (Object)ResourceHelper.getTextContent(tag));
        }
        if ((file = this.getPsiFile()) != null) {
            helper2.add("file", (Object)file.getName());
        }
        return helper2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/PsiResourceItem";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declareStyleable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleValue";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrTag";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayValue";
                break;
            }
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/PsiResourceItem";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDeclareStyleable";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStyleValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttrValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePluralsValue";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forXmlTag";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseDeclareStyleable";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseStyleValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseAttrValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayValue";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parsePluralsValue";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseTextValue";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "wasTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PsiTextResourceValue
    extends TextResourceValueImpl {
        PsiTextResourceValue(@NotNull ResourceNamespace namespace, @Nullable String name, @Nullable String textValue, @Nullable String rawXmlValue, String libraryName) {
            if (namespace == null) {
                PsiTextResourceValue.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PsiTextResourceValue.$$$reportNull$$$0(1);
            }
            super(namespace, name, textValue, rawXmlValue, libraryName);
        }

        public String getRawXmlValue() {
            XmlTag tag = PsiResourceItem.this.getTag();
            if (tag == null || !tag.isValid()) {
                return this.getValue();
            }
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                return tag.getValue().getText();
            }
            return (String)ApplicationManager.getApplication().runReadAction(() -> tag.getValue().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/PsiResourceItem$PsiTextResourceValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AsyncInitializationData {
        @NotNull
        final PsiFile psiFile;
        @Nullable
        final XmlTag xmlTag;

        private AsyncInitializationData(@NotNull PsiFile file, @Nullable XmlTag tag) {
            if (file == null) {
                AsyncInitializationData.$$$reportNull$$$0(0);
            }
            this.psiFile = file;
            this.xmlTag = tag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/PsiResourceItem$AsyncInitializationData", "<init>"));
        }
    }
}

