/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MultiResourceRepository.class);
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ImmutableList<LocalResourceRepository> myLocalResources;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ImmutableList<AarResourceRepository> myLibraryResources;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ImmutableList<ResourceRepository> myChildren;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myLeafsByNamespace;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myRepositoriesByNamespace;
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private ResourceItemComparator myResourceComparator;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long[] myModificationCounts;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final ResourceTable myCachedMaps;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final Table<SingleNamespaceResourceRepository, ResourceType, Set<String>> myResourceNames;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final Table<ResourceNamespace, ResourceType, Set<SingleNamespaceResourceRepository>> myUnreconciledResources;

    MultiResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            MultiResourceRepository.$$$reportNull$$$0(0);
        }
        super(displayName);
        this.myLocalResources = ImmutableList.of();
        this.myLibraryResources = ImmutableList.of();
        this.myChildren = ImmutableList.of();
        this.myLeafsByNamespace = ImmutableListMultimap.of();
        this.myRepositoriesByNamespace = ImmutableListMultimap.of();
        this.myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator((Collection<SingleNamespaceResourceRepository>)ImmutableList.of()));
        this.myCachedMaps = new ResourceTable();
        this.myResourceNames = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));
        this.myUnreconciledResources = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources, @NotNull Collection<? extends ResourceRepository> otherResources) {
        if (localResources == null) {
            MultiResourceRepository.$$$reportNull$$$0(1);
        }
        if (libraryResources == null) {
            MultiResourceRepository.$$$reportNull$$$0(2);
        }
        if (otherResources == null) {
            MultiResourceRepository.$$$reportNull$$$0(3);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myLocalResources = ImmutableList.copyOf(localResources);
            this.myLibraryResources = ImmutableList.copyOf(libraryResources);
            int size = this.myLocalResources.size() + this.myLibraryResources.size() + otherResources.size();
            this.myChildren = ImmutableList.builderWithExpectedSize((int)size).addAll(this.myLocalResources).addAll(this.myLibraryResources).addAll(otherResources).build();
            ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeLeafs((ResourceRepository)this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myLeafsByNamespace = mapBuilder.build();
            mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeNamespaceMap((ResourceRepository)this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myRepositoriesByNamespace = mapBuilder.build();
            this.myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator((Collection<SingleNamespaceResourceRepository>)this.myLeafsByNamespace.values()));
            this.myModificationCounts = new long[localResources.size()];
            if (localResources.size() == 1) {
                LocalResourceRepository child = localResources.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i2 = 0;
            for (LocalResourceRepository child : this.myLocalResources) {
                child.addParent(this);
                this.myModificationCounts[i2++] = child.getModificationCount();
            }
            this.myCachedMaps.clear();
            this.invalidateParentCaches();
        }
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    private static void computeLeafs(@NotNull ResourceRepository repository, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(5);
        }
        if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeLeafs(child, result2);
            }
        } else {
            for (SingleNamespaceResourceRepository resourceRepository : repository.getLeafResourceRepositories()) {
                result2.put((Object)resourceRepository.getNamespace(), (Object)resourceRepository);
            }
        }
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    private static void computeNamespaceMap(@NotNull ResourceRepository repository, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(7);
        }
        if (repository instanceof SingleNamespaceResourceRepository) {
            SingleNamespaceResourceRepository singleNamespaceRepository = (SingleNamespaceResourceRepository)repository;
            ResourceNamespace namespace = singleNamespaceRepository.getNamespace();
            result2.put((Object)namespace, (Object)singleNamespaceRepository);
        } else if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeNamespaceMap(child, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<LocalResourceRepository> getLocalResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLocalResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<AarResourceRepository> getLibraryResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLibraryResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<ResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableList<ResourceRepository> immutableList = this.myChildren;
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        MultiResourceRepository.$$$reportNull$$$0(8);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<SingleNamespaceResourceRepository> getRepositoriesForNamespace(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(9);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableList immutableList = this.myRepositoriesByNamespace.get((Object)namespace);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        MultiResourceRepository.$$$reportNull$$$0(10);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources.size() == 1) {
                return ((LocalResourceRepository)((Object)this.myLocalResources.get(0))).getModificationCount();
            }
            boolean changed = false;
            for (int i2 = 0; i2 < this.myLocalResources.size(); ++i2) {
                LocalResourceRepository child = (LocalResourceRepository)((Object)this.myLocalResources.get(i2));
                long rev = child.getModificationCount();
                if (rev == this.myModificationCounts[i2]) continue;
                this.myModificationCounts[i2] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableSet immutableSet = this.myRepositoriesByNamespace.keySet();
        // MONITOREXIT : object
        if (immutableSet != null) return immutableSet;
        MultiResourceRepository.$$$reportNull$$$0(11);
        return immutableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
        if (visitor == null) {
            MultiResourceRepository.$$$reportNull$$$0(12);
        }
        var2_2 = MultiResourceRepository.ITEM_MAP_LOCK;
        synchronized (var2_2) {
            var3_3 = this.getNamespaces().iterator();
            while (true) {
                if (var3_3.hasNext()) {
                    namespace = var3_3.next();
                    if (!visitor.shouldVisitNamespace(namespace)) continue;
                } else {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 9] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    v0 = ResourceVisitor.VisitResult.CONTINUE;
                    if (v0 == null) {
                        MultiResourceRepository.$$$reportNull$$$0(14);
                    }
                    return v0;
                }
                var5_5 = ResourceType.values();
                var6_6 = var5_5.length;
                var7_7 = 0;
                while (true) {
                    if (var7_7 >= var6_6) ** break;
                    type = var5_5[var7_7];
                    if (visitor.shouldVisitResourceType(type)) {
                        map = this.getMap(namespace, type);
                        for (ResourceItem item : map.values()) {
                            if (visitor.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                            v1 = ResourceVisitor.VisitResult.ABORT;
                            // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 5, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var2_2
                            if (v1 == null) {
                                MultiResourceRepository.$$$reportNull$$$0(13);
                            }
                            return v1;
                        }
                    }
                    ++var7_7;
                }
                break;
            }
        }
    }

    @Override
    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Stopwatch stopwatch;
        ImmutableList repositoriesForNamespace;
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(15);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(16);
        }
        if ((repositoriesForNamespace = this.myLeafsByNamespace.get((Object)namespace)).size() == 1) {
            SingleNamespaceResourceRepository repository = (SingleNamespaceResourceRepository)repositoriesForNamespace.get(0);
            return MultiResourceRepository.getResourcesUnderLock(repository, namespace, type);
        }
        ListMultimap map2 = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
        Set unreconciledRepositories = null;
        if (map2 != null && (unreconciledRepositories = (Set)this.myUnreconciledResources.get((Object)namespace, (Object)type)) == null) {
            ListMultimap listMultimap = map2;
            if (listMultimap == null) {
                MultiResourceRepository.$$$reportNull$$$0(17);
            }
            return listMultimap;
        }
        Object object = stopwatch = LOG.isDebugEnabled() ? Stopwatch.createStarted() : null;
        if (map2 == null) {
            map2 = type == ResourceType.STYLEABLE || type == ResourceType.ID ? ArrayListMultimap.create() : new PerConfigResourceMap(this.myResourceComparator);
            for (SingleNamespaceResourceRepository repository : repositoriesForNamespace) {
                ListMultimap<String, ResourceItem> items2 = MultiResourceRepository.getResourcesUnderLock(repository, namespace, type);
                map2.putAll(items2);
                if (!(repository instanceof LocalResourceRepository)) continue;
                this.myResourceNames.put((Object)repository, (Object)type, (Object)ImmutableSet.copyOf((Collection)items2.keySet()));
            }
        } else {
            for (SingleNamespaceResourceRepository unreconciledRepository : unreconciledRepositories) {
                Predicate<ResourceItem> filter2 = item -> item.getRepository().equals(unreconciledRepository);
                Set names = (Set)this.myResourceNames.get((Object)unreconciledRepository, (Object)type);
                PerConfigResourceMap perConfigMap = map2 instanceof PerConfigResourceMap ? (PerConfigResourceMap)map2 : null;
                for (String name : names) {
                    if (perConfigMap != null) {
                        perConfigMap.removeIf(name, filter2);
                        continue;
                    }
                    List items3 = map2.get((Object)name);
                    items3.removeIf(filter2);
                    if (!items3.isEmpty()) continue;
                    map2.removeAll((Object)name);
                }
                ListMultimap<String, ResourceItem> unreconciledResources = MultiResourceRepository.getResourcesUnderLock(unreconciledRepository, namespace, type);
                map2.putAll(unreconciledResources);
                assert (unreconciledRepository instanceof LocalResourceRepository);
                this.myResourceNames.put((Object)unreconciledRepository, (Object)type, (Object)ImmutableSet.copyOf((Collection)unreconciledResources.keySet()));
            }
            this.myUnreconciledResources.remove((Object)namespace, (Object)type);
        }
        if (stopwatch != null) {
            LOG.debug(String.format(Locale.US, "Merged %d resources of type %s in %s for %s.", map2.size(), type, stopwatch, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        this.myCachedMaps.put((Object)namespace, (Object)type, (Object)map2);
        ListMultimap listMultimap = map2;
        if (listMultimap == null) {
            MultiResourceRepository.$$$reportNull$$$0(18);
        }
        return listMultimap;
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    @NotNull
    private static ListMultimap<String, ResourceItem> getResourcesUnderLock(@NotNull SingleNamespaceResourceRepository repository, @NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(19);
        }
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(20);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(21);
        }
        if (repository instanceof LocalResourceRepository) {
            ListMultimap<String, ResourceItem> map2 = ((LocalResourceRepository)repository).getMapPackageAccessible(namespace, type);
            ListMultimap<String, ResourceItem> listMultimap = map2 == null ? ImmutableListMultimap.of() : map2;
            if (listMultimap == null) {
                MultiResourceRepository.$$$reportNull$$$0(22);
            }
            return listMultimap;
        }
        ListMultimap listMultimap = repository.getResources(namespace, type);
        if (listMultimap == null) {
            MultiResourceRepository.$$$reportNull$$$0(23);
        }
        return listMultimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(24);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(25);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return ((ResourceRepository)this.myChildren.get(0)).hasResources(namespace, type);
            }
            if (this instanceof SingleNamespaceResourceRepository) {
                if (namespace.equals((Object)((SingleNamespaceResourceRepository)this).getNamespace())) {
                    for (ResourceRepository child : this.myChildren) {
                        if (!child.hasResources(namespace, type)) continue;
                        return true;
                    }
                }
                return false;
            }
            ImmutableList repositories = this.myRepositoriesByNamespace.get((Object)namespace);
            for (ResourceRepository repository : repositories) {
                if (!repository.hasResources(namespace, type)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
        }
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    public void invalidateCache() {
        this.myCachedMaps.clear();
        this.myResourceNames.clear();
        this.myUnreconciledResources.clear();
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches();
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    public void invalidateCache(@NotNull SingleNamespaceResourceRepository repository, ResourceType ... types) {
        ResourceNamespace namespace;
        ImmutableList leafs;
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(26);
        }
        if (types == null) {
            MultiResourceRepository.$$$reportNull$$$0(27);
        }
        if ((leafs = this.myLeafsByNamespace.get((Object)(namespace = repository.getNamespace()))) != null && leafs.contains((Object)repository)) {
            if (leafs.size() != 1) {
                for (ResourceType type : types) {
                    if (this.myCachedMaps.get((Object)namespace, (Object)type) == null) continue;
                    HashSet<SingleNamespaceResourceRepository> repositories = (HashSet<SingleNamespaceResourceRepository>)this.myUnreconciledResources.get((Object)namespace, (Object)type);
                    if (repositories == null) {
                        repositories = new HashSet<SingleNamespaceResourceRepository>();
                        this.myUnreconciledResources.put((Object)namespace, (Object)type, repositories);
                    }
                    repositories.add(repository);
                }
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            this.invalidateParentCaches(repository, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isScanPending(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(28);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            for (LocalResourceRepository child : this.myLocalResources) {
                if (!child.isScanPending(psiFile2)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sync() {
        super.sync();
        for (LocalResourceRepository childRepository : this.getLocalResources()) {
            childRepository.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        UnmodifiableIterator unmodifiableIterator = this.myLocalResources.iterator();
        while (true) {
            if (!unmodifiableIterator.hasNext()) {
                HashSet<VirtualFile> hashSet = result2;
                // MONITOREXIT : object
                if (hashSet != null) return hashSet;
                MultiResourceRepository.$$$reportNull$$$0(29);
                return hashSet;
            }
            LocalResourceRepository resourceRepository = (LocalResourceRepository)((Object)unmodifiableIterator.next());
            result2.addAll(resourceRepository.computeResourceDirs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableCollection immutableCollection = this.myLeafsByNamespace.values();
        // MONITOREXIT : object
        if (immutableCollection != null) return immutableCollection;
        MultiResourceRepository.$$$reportNull$$$0(30);
        return immutableCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryResources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherResources";
                break;
            }
            case 4: 
            case 6: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 9: 
            case 15: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesForNamespace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesUnderLock";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafResourceRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeLeafs";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeNamespaceMap";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesForNamespace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesUnderLock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasResources";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCache";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResourceItemComparator
    implements Comparator<ResourceItem> {
        private final Comparator<ResourceItem> myPriorityComparator;

        ResourceItemComparator(Comparator<ResourceItem> priorityComparator) {
            this.myPriorityComparator = priorityComparator;
        }

        @Override
        public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
            int c;
            if (item1 == null) {
                ResourceItemComparator.$$$reportNull$$$0(0);
            }
            if (item2 == null) {
                ResourceItemComparator.$$$reportNull$$$0(1);
            }
            if ((c = item1.getConfiguration().compareTo(item2.getConfiguration())) != 0) {
                return c;
            }
            return this.myPriorityComparator.compare(item1, item2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item2";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/MultiResourceRepository$ResourceItemComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PerConfigResourceMap
    implements ListMultimap<String, ResourceItem> {
        private final Map<String, List<ResourceItem>> myMap;
        private int mySize;
        @NotNull
        private final ResourceItemComparator myComparator;
        @Nullable
        private Values myValues;

        private PerConfigResourceMap(@NotNull ResourceItemComparator comparator2) {
            if (comparator2 == null) {
                PerConfigResourceMap.$$$reportNull$$$0(0);
            }
            this.myMap = new HashMap<String, List<ResourceItem>>();
            this.mySize = 0;
            this.myComparator = comparator2;
        }

        @Nullable
        public List<ResourceItem> get(@Nullable String key) {
            return this.myMap.get(key);
        }

        @NotNull
        public Set<String> keySet() {
            Set<String> set = this.myMap.keySet();
            if (set == null) {
                PerConfigResourceMap.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public Multiset<String> keys() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<ResourceItem> values() {
            Values values = this.myValues;
            if (values == null) {
                this.myValues = values = new Values();
            }
            Values values2 = values;
            if (values2 == null) {
                PerConfigResourceMap.$$$reportNull$$$0(2);
            }
            return values2;
        }

        @NotNull
        public Collection<Map.Entry<String, ResourceItem>> entries() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public List<ResourceItem> removeAll(@Nullable Object key) {
            List<ResourceItem> removed = this.myMap.remove(key);
            if (removed != null) {
                this.mySize -= removed.size();
            }
            return removed;
        }

        boolean removeIf(@NotNull String key, @NotNull Predicate<? super ResourceItem> filter2) {
            List<ResourceItem> list;
            if (key == null) {
                PerConfigResourceMap.$$$reportNull$$$0(3);
            }
            if (filter2 == null) {
                PerConfigResourceMap.$$$reportNull$$$0(4);
            }
            if ((list = this.myMap.get(key)) == null) {
                return false;
            }
            int oldSize = list.size();
            boolean removed = list.removeIf(filter2);
            this.mySize += list.size() - oldSize;
            if (list.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }

        public void clear() {
            this.myMap.clear();
            this.mySize = 0;
        }

        public int size() {
            return this.mySize;
        }

        public boolean isEmpty() {
            return this.myMap.isEmpty();
        }

        public boolean containsKey(@Nullable Object key) {
            return this.myMap.containsKey(key);
        }

        public boolean containsValue(@Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean containsEntry(@Nullable Object key, @Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean put(@Nullable String key, @Nullable ResourceItem item) {
            List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
            int oldSize = list.size();
            boolean added = list.add(item);
            this.mySize += list.size() - oldSize;
            return added;
        }

        public boolean remove(@Nullable Object key, @Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean putAll(@Nullable String key, @NotNull Iterable<? extends ResourceItem> items2) {
            if (items2 == null) {
                PerConfigResourceMap.$$$reportNull$$$0(5);
            }
            List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
            int oldSize = list.size();
            if (items2 instanceof Collection) {
                boolean added = list.addAll((Collection)items2);
                this.mySize += list.size() - oldSize;
                return added;
            }
            boolean added = false;
            for (ResourceItem resourceItem : items2) {
                added = list.add(resourceItem);
            }
            this.mySize += list.size() - oldSize;
            return added;
        }

        public boolean putAll(Multimap<? extends String, ? extends ResourceItem> multimap) {
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                String key = (String)entry.getKey();
                Collection items2 = (Collection)entry.getValue();
                List list = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
                int oldSize = list.size();
                list.addAll(items2);
                this.mySize += list.size() - oldSize;
            }
            return !multimap.isEmpty();
        }

        public List<ResourceItem> replaceValues(@Nullable String key, @NotNull Iterable<? extends ResourceItem> values) {
            if (values == null) {
                PerConfigResourceMap.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException();
        }

        public Map<String, Collection<ResourceItem>> asMap() {
            return this.myMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/MultiResourceRepository$PerConfigResourceMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository$PerConfigResourceMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keySet";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeIf";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "putAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class Values
        extends AbstractCollection<ResourceItem> {
            private Values() {
            }

            @Override
            public Iterator<ResourceItem> iterator() {
                return new ValuesIterator();
            }

            @Override
            public int size() {
                return PerConfigResourceMap.this.mySize;
            }

            private class ValuesIterator
            implements Iterator<ResourceItem> {
                private Iterator<List<ResourceItem>> myOuterCursor;
                private List<ResourceItem> myCurrentList;
                private int myInnerCursor;

                private ValuesIterator() {
                    this.myOuterCursor = PerConfigResourceMap.this.myMap.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.myCurrentList != null || this.myOuterCursor.hasNext();
                }

                @Override
                public ResourceItem next() {
                    if (this.myCurrentList == null) {
                        this.myCurrentList = this.myOuterCursor.next();
                        this.myInnerCursor = 0;
                    }
                    try {
                        ResourceItem item = this.myCurrentList.get(this.myInnerCursor);
                        if (++this.myInnerCursor >= this.myCurrentList.size()) {
                            this.myCurrentList = null;
                        }
                        return item;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new NoSuchElementException();
                    }
                }
            }
        }

        private class PerConfigResourceList
        extends AbstractList<ResourceItem> {
            private final List<List<ResourceItem>> myResourceItems = new ArrayList<List<ResourceItem>>();

            private PerConfigResourceList() {
            }

            @Override
            @NotNull
            public ResourceItem get(int index) {
                ResourceItem resourceItem = this.myResourceItems.get(index).get(0);
                if (resourceItem == null) {
                    PerConfigResourceList.$$$reportNull$$$0(0);
                }
                return resourceItem;
            }

            @Override
            public int size() {
                return this.myResourceItems.size();
            }

            @Override
            public boolean add(@NotNull ResourceItem item) {
                if (item == null) {
                    PerConfigResourceList.$$$reportNull$$$0(1);
                }
                this.add(item, 0);
                return true;
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends ResourceItem> items2) {
                if (items2 == null) {
                    PerConfigResourceList.$$$reportNull$$$0(2);
                }
                if (items2.isEmpty()) {
                    return false;
                }
                if (items2.size() == 1) {
                    return this.add(items2.iterator().next());
                }
                List<ResourceItem> sortedItems = this.sortedItems(items2);
                int start = 0;
                for (ResourceItem item : sortedItems) {
                    start = this.add(item, start);
                }
                return true;
            }

            private int add(ResourceItem item, int start) {
                int index = this.findConfigIndex(item, start, this.myResourceItems.size());
                if (index < 0) {
                    this.myResourceItems.add(index ^= 0xFFFFFFFF, (List<ResourceItem>)new SmartList((Object)item));
                } else {
                    List<ResourceItem> nested = this.myResourceItems.get(index);
                    for (int i2 = 0; i2 < nested.size(); ++i2) {
                        if (PerConfigResourceMap.this.myComparator.myPriorityComparator.compare(item, nested.get(i2)) > 0) continue;
                        nested.add(i2, item);
                        return index;
                    }
                    nested.add(item);
                }
                return index;
            }

            @Override
            public void clear() {
                this.myResourceItems.clear();
            }

            @Override
            public boolean remove(@Nullable Object item) {
                assert (item != null);
                int index = this.remove((ResourceItem)item, this.myResourceItems.size());
                return index >= 0;
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> items2) {
                if (items2 == null) {
                    PerConfigResourceList.$$$reportNull$$$0(3);
                }
                if (items2.isEmpty()) {
                    return false;
                }
                if (items2.size() == 1) {
                    return this.remove(items2.iterator().next());
                }
                List<ResourceItem> itemsToDelete = this.sortedItems(items2);
                boolean modified = false;
                int end = this.myResourceItems.size();
                int i2 = itemsToDelete.size();
                while (--i2 >= 0) {
                    int index = this.remove(itemsToDelete.get(i2), end);
                    if (index > 0) {
                        modified = true;
                        end = index;
                        continue;
                    }
                    end = ~index;
                }
                return modified;
            }

            @Override
            public boolean removeIf(@NotNull Predicate<? super ResourceItem> filter2) {
                if (filter2 == null) {
                    PerConfigResourceList.$$$reportNull$$$0(4);
                }
                boolean removed = false;
                int i2 = this.myResourceItems.size();
                while (--i2 >= 0) {
                    List<ResourceItem> nested = this.myResourceItems.get(i2);
                    int j = nested.size();
                    while (--j >= 0) {
                        ResourceItem item = nested.get(j);
                        if (!filter2.test((ResourceItem)item)) continue;
                        nested.remove(j);
                        removed = true;
                    }
                    if (!nested.isEmpty()) continue;
                    this.myResourceItems.remove(i2);
                }
                return removed;
            }

            private int remove(@NotNull ResourceItem item, int end) {
                int index;
                if (item == null) {
                    PerConfigResourceList.$$$reportNull$$$0(5);
                }
                if ((index = this.findConfigIndex(item, 0, end)) < 0) {
                    return index;
                }
                List<ResourceItem> nested = this.myResourceItems.get(index);
                if (!nested.remove(item)) {
                    return ~(index + 1);
                }
                if (nested.isEmpty()) {
                    this.myResourceItems.remove(index);
                    return index;
                }
                return index + 1;
            }

            @NotNull
            private List<ResourceItem> sortedItems(@NotNull Collection<? extends ResourceItem> items2) {
                if (items2 == null) {
                    PerConfigResourceList.$$$reportNull$$$0(6);
                }
                ArrayList<ResourceItem> sortedItems = new ArrayList<ResourceItem>(items2);
                sortedItems.sort(PerConfigResourceMap.this.myComparator);
                ArrayList<ResourceItem> arrayList = sortedItems;
                if (arrayList == null) {
                    PerConfigResourceList.$$$reportNull$$$0(7);
                }
                return arrayList;
            }

            private int findConfigIndex(@NotNull ResourceItem item, int start, int end) {
                if (item == null) {
                    PerConfigResourceList.$$$reportNull$$$0(8);
                }
                FolderConfiguration config = item.getConfiguration();
                int low = start;
                int high = end;
                while (low < high) {
                    int mid = low + high >>> 1;
                    FolderConfiguration value2 = this.myResourceItems.get(mid).get(0).getConfiguration();
                    int c = value2.compareTo(config);
                    if (c < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (c > 0) {
                        high = mid;
                        continue;
                    }
                    return mid;
                }
                return ~low;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/res/MultiResourceRepository$PerConfigResourceMap$PerConfigResourceList";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "items";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "get";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository$PerConfigResourceMap$PerConfigResourceList";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sortedItems";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "add";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addAll";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "removeAll";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "removeIf";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "remove";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "sortedItems";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "findConfigIndex";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class ResourcePriorityComparator
    implements Comparator<ResourceItem> {
        private final ObjectIntHashMap<SingleNamespaceResourceRepository> repositoryOrdering;

        ResourcePriorityComparator(@NotNull Collection<SingleNamespaceResourceRepository> repositories) {
            if (repositories == null) {
                ResourcePriorityComparator.$$$reportNull$$$0(0);
            }
            this.repositoryOrdering = new ObjectIntHashMap(repositories.size());
            int i2 = 0;
            for (SingleNamespaceResourceRepository repository : repositories) {
                this.repositoryOrdering.put((Object)repository, i2++);
            }
        }

        @Override
        public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
            if (item1 == null) {
                ResourcePriorityComparator.$$$reportNull$$$0(1);
            }
            if (item2 == null) {
                ResourcePriorityComparator.$$$reportNull$$$0(2);
            }
            return Integer.compare(this.getOrdering(item1), this.getOrdering(item2));
        }

        private int getOrdering(@NotNull ResourceItem item) {
            if (item == null) {
                ResourcePriorityComparator.$$$reportNull$$$0(3);
            }
            int ordering = this.repositoryOrdering.get((Object)item.getRepository());
            assert (ordering >= 0);
            return ordering;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository$ResourcePriorityComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrdering";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

