/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.DynamicValueResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModuleResourceRepository
extends MultiResourceRepository
implements SingleNamespaceResourceRepository {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final SourceSet mySourceSet;
    @NotNull
    private final ResourceFolderRegistry myRegistry;

    @NotNull
    static LocalResourceRepository forMainResources(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        ModuleResourceRepository moduleRepository;
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(1);
        }
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet2.getModule().getProject());
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet2);
        if (!AndroidModel.isRequired(facet2)) {
            VirtualFile primaryResourceDir = (VirtualFile)ContainerUtil.getFirstItem(folderManager.getFolders(), null);
            if (primaryResourceDir == null) {
                return new LocalResourceRepository.EmptyRepository(namespace);
            }
            return new ModuleResourceRepository(facet2, namespace, Collections.singletonList(resourceFolderRegistry.get(facet2, primaryResourceDir)), SourceSet.MAIN);
        }
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        DynamicValueResourceRepository dynamicResources = DynamicValueResourceRepository.create(facet2, namespace);
        try {
            ArrayList<LocalResourceRepository> childRepositories = new ArrayList<LocalResourceRepository>(1 + resourceDirectories.size());
            childRepositories.add(dynamicResources);
            ModuleResourceRepository.addRepositoriesInReverseOverlayOrder(resourceDirectories, childRepositories, facet2, resourceFolderRegistry);
            moduleRepository = new ModuleResourceRepository(facet2, namespace, childRepositories, SourceSet.MAIN);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)dynamicResources);
            throw t;
        }
        Disposer.register((Disposable)moduleRepository, (Disposable)dynamicResources);
        ModuleResourceRepository moduleResourceRepository = moduleRepository;
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(2);
        }
        return moduleResourceRepository;
    }

    @NotNull
    static LocalResourceRepository forTestResources(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(4);
        }
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet2.getModule().getProject());
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet2);
        if (!AndroidModel.isRequired(facet2)) {
            return new LocalResourceRepository.EmptyRepository(namespace);
        }
        List<VirtualFile> resourceDirectories = folderManager.getTestFolders();
        ArrayList<LocalResourceRepository> childRepositories = new ArrayList<LocalResourceRepository>(resourceDirectories.size());
        ModuleResourceRepository.addRepositoriesInReverseOverlayOrder(resourceDirectories, childRepositories, facet2, resourceFolderRegistry);
        return new ModuleResourceRepository(facet2, namespace, childRepositories, SourceSet.TEST);
    }

    private static void addRepositoriesInReverseOverlayOrder(@NotNull List<VirtualFile> resourceDirectories, @NotNull List<LocalResourceRepository> childRepositories, @NotNull AndroidFacet facet2, @NotNull ResourceFolderRegistry resourceFolderRegistry) {
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(5);
        }
        if (childRepositories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(6);
        }
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(7);
        }
        if (resourceFolderRegistry == null) {
            ModuleResourceRepository.$$$reportNull$$$0(8);
        }
        int i2 = resourceDirectories.size();
        while (--i2 >= 0) {
            VirtualFile resourceDirectory = resourceDirectories.get(i2);
            ResourceFolderRepository repository = resourceFolderRegistry.get(facet2, resourceDirectory);
            childRepositories.add(repository);
        }
    }

    private ModuleResourceRepository(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull SourceSet sourceSet) {
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(9);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(10);
        }
        if (delegates == null) {
            ModuleResourceRepository.$$$reportNull$$$0(11);
        }
        if (sourceSet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(12);
        }
        super(facet2.getModule().getName());
        this.myFacet = facet2;
        this.myNamespace = namespace;
        this.mySourceSet = sourceSet;
        this.myRegistry = ResourceFolderRegistry.getInstance(facet2.getModule().getProject());
        this.setChildren(delegates, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
        ResourceFolderManager.ResourceFolderListener resourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void mainResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders, @NotNull Collection<? extends VirtualFile> added, @NotNull Collection<? extends VirtualFile> removed) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (folders == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (added == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (removed == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (ModuleResourceRepository.this.mySourceSet == SourceSet.MAIN) {
                    ModuleResourceRepository.this.updateRoots(folders);
                }
            }

            @Override
            public void testResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders, @NotNull Collection<? extends VirtualFile> added, @NotNull Collection<? extends VirtualFile> removed) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (folders == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (added == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (removed == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (ModuleResourceRepository.this.mySourceSet == SourceSet.TEST) {
                    ModuleResourceRepository.this.updateRoots(folders);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "folders";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "added";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "removed";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/res/ModuleResourceRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mainResourceFoldersChanged";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "testResourceFoldersChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFacet.getModule().getMessageBus().connect((Disposable)this).subscribe(ResourceFolderManager.TOPIC, (Object)resourceFolderListener);
    }

    @VisibleForTesting
    void updateRoots(List<? extends VirtualFile> resourceDirectories) {
        ArrayList<LocalResourceRepository> other = null;
        HashMap<VirtualFile, ResourceFolderRepository> map2 = new HashMap<VirtualFile, ResourceFolderRepository>();
        ImmutableList<LocalResourceRepository> children = this.getLocalResources();
        for (LocalResourceRepository repository : children) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map2.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicValueResourceRepository);
            if (other == null) {
                other = new ArrayList<LocalResourceRepository>();
            }
            other.add(repository);
        }
        HashSet<? extends VirtualFile> newDirs = new HashSet<VirtualFile>(resourceDirectories);
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(newDirs.size() + (other != null ? other.size() : 0));
        if (other != null) {
            resources.addAll(other);
        }
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)map2.get(dir);
            if (repository == null) {
                repository = this.myRegistry.get(this.myFacet, dir);
            } else {
                map2.remove(dir);
            }
            resources.add(repository);
        }
        if (resources.equals(children)) {
            assert (map2.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map2.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(13);
        }
        return resourceNamespace;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)this.mySourceSet).toString();
    }

    @VisibleForTesting
    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull Collection<VirtualFile> resourceDirectories, @NotNull ResourceNamespace namespace, @Nullable DynamicValueResourceRepository dynamicResourceValueRepository) {
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(14);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(15);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(16);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<DynamicValueResourceRepository> delegates = new ArrayList<DynamicValueResourceRepository>(resourceDirectories.size() + (dynamicResourceValueRepository == null ? 0 : 1));
        if (dynamicResourceValueRepository != null) {
            delegates.add(dynamicResourceValueRepository);
        }
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet2.getModule().getProject());
        resourceDirectories.forEach(dir -> delegates.add((DynamicValueResourceRepository)((Object)resourceFolderRegistry.get(facet2, (VirtualFile)dir, namespace))));
        ModuleResourceRepository repository = new ModuleResourceRepository(facet2, namespace, delegates, SourceSet.MAIN);
        Disposer.register((Disposable)facet2, (Disposable)repository);
        ModuleResourceRepository moduleResourceRepository = repository;
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(17);
        }
        return moduleResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childRepositories";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderRegistry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forMainResources";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forMainResources";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forTestResources";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoriesInReverseOverlayOrder";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SourceSet {
        MAIN,
        TEST;

    }
}

