/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.PredefinedSampleDataResourceRepository;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoaderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppResourceRepository
extends MultiResourceRepository {
    static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private final Object RESOURCE_MAP_LOCK;
    @Nullable
    private Collection<VirtualFile> myResourceDirs;

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet2, @NotNull Collection<AarResourceRepository> libraryRepositories2) {
        if (facet2 == null) {
            AppResourceRepository.$$$reportNull$$$0(0);
        }
        if (libraryRepositories2 == null) {
            AppResourceRepository.$$$reportNull$$$0(1);
        }
        AppResourceRepository repository = new AppResourceRepository(facet2, AppResourceRepository.computeLocalRepositories(facet2), libraryRepositories2);
        AndroidProjectRootListener.ensureSubscribed(facet2.getModule().getProject());
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(2);
        }
        return appResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Collection<VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirs == null) {
            ImmutableList.Builder result2 = ImmutableList.builder();
            for (LocalResourceRepository resourceRepository : this.getLocalResources()) {
                result2.addAll(resourceRepository.getResourceDirs());
            }
            this.myResourceDirs = result2.build();
        }
        Collection<VirtualFile> collection2 = this.myResourceDirs;
        // MONITOREXIT : object
        if (collection2 != null) return collection2;
        AppResourceRepository.$$$reportNull$$$0(3);
        return collection2;
    }

    private static List<LocalResourceRepository> computeLocalRepositories(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AppResourceRepository.$$$reportNull$$$0(4);
        }
        return ImmutableList.of((Object)((Object)ResourceRepositoryManager.getProjectResources(facet2)), (Object)((Object)SampleDataResourceRepository.getInstance(facet2)));
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> localResources, @NotNull Collection<AarResourceRepository> libraryResources) {
        if (facet2 == null) {
            AppResourceRepository.$$$reportNull$$$0(5);
        }
        if (localResources == null) {
            AppResourceRepository.$$$reportNull$$$0(6);
        }
        if (libraryResources == null) {
            AppResourceRepository.$$$reportNull$$$0(7);
        }
        super(facet2.getModule().getName() + " with modules and libraries");
        this.RESOURCE_MAP_LOCK = new Object();
        this.myFacet = facet2;
        this.setChildren(localResources, libraryResources, (Collection<? extends ResourceRepository>)ImmutableList.of((Object)((Object)PredefinedSampleDataResourceRepository.getInstance())));
    }

    void updateRoots(@NotNull Collection<? extends AarResourceRepository> libraryResources) {
        if (libraryResources == null) {
            AppResourceRepository.$$$reportNull$$$0(8);
        }
        List<LocalResourceRepository> localResources = AppResourceRepository.computeLocalRepositories(this.myFacet);
        this.updateRoots(localResources, libraryResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateRoots(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources) {
        if (localResources == null) {
            AppResourceRepository.$$$reportNull$$$0(9);
        }
        if (libraryResources == null) {
            AppResourceRepository.$$$reportNull$$$0(10);
        }
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        this.invalidateResourceDirs();
        this.setChildren(localResources, libraryResources, (Collection<? extends ResourceRepository>)ImmutableList.of((Object)((Object)PredefinedSampleDataResourceRepository.getInstance())));
        ResourceIdManager.get(this.myFacet.getModule()).resetDynamicIds();
        ModuleClassLoaderManager.get().clearCache(this.myFacet.getModule());
    }

    @VisibleForTesting
    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> modules, @NotNull Collection<AarResourceRepository> libraries) {
        if (facet2 == null) {
            AppResourceRepository.$$$reportNull$$$0(11);
        }
        if (modules == null) {
            AppResourceRepository.$$$reportNull$$$0(12);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(13);
        }
        AppResourceRepository repository = new AppResourceRepository(facet2, modules, libraries);
        Disposer.register((Disposable)facet2, (Disposable)repository);
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(14);
        }
        return appResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResources";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryResources";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeLocalRepositories";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

