/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.lint.AndroidLintWebpUnsupportedInspection;
import com.android.utils.SdkUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertFromWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Convert from WebP to PNG";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        int answer = Messages.showYesNoCancelDialog((Project)project, (String)"Delete .webp files after saving as .png?", (String)TITLE, null);
        if (answer == 2) {
            return;
        }
        boolean delete = answer == 0;
        VirtualFile[] files2 = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.perform(project, files2, delete);
    }

    public void perform(@NotNull Project project, @NotNull VirtualFile[] files2, boolean deleteWebp) {
        if (project == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(2);
        }
        this.convert(project, Arrays.asList(files2), deleteWebp);
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(3);
        }
        if ((files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null && e.getProject() != null) {
            for (VirtualFile file : files2) {
                if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".webp")) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull Collection<VirtualFile> files2, boolean delete) {
        if (project == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(4);
        }
        if (files2 == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().run((Task)new WebpConversionTask(project, files2, delete));
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(6);
        }
        ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>();
        for (VirtualFile file : files2) {
            VirtualFile parent = file.getParent();
            if (parent == null || toRefresh.contains(parent)) continue;
            toRefresh.add(parent);
        }
        ArrayList<VirtualFile> arrayList = toRefresh;
        if (arrayList == null) {
            ConvertFromWebpAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/webp/ConvertFromWebpAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/webp/ConvertFromWebpAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeParentFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeParentFolders";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final Collection<VirtualFile> myFiles;
        private final boolean myDelete;
        private List<VirtualFile> myParentFolders;
        private List<VirtualFile> myConvertedFiles;

        public WebpConversionTask(Project project, Collection<VirtualFile> files2, boolean delete) {
            super(project, ConvertFromWebpAction.TITLE, true);
            this.myProject = project;
            this.myFiles = files2;
            this.myDelete = delete;
        }

        public void onFinished() {
            this.writeImages((Object)this, this.myProject, this.myConvertedFiles);
            ConvertFromWebpAction.refreshFolders(this.myParentFolders);
        }

        private void writeImages(@NotNull Object requestor, @NotNull Project project, @NotNull List<VirtualFile> files2) {
            if (requestor == null) {
                WebpConversionTask.$$$reportNull$$$0(0);
            }
            if (project == null) {
                WebpConversionTask.$$$reportNull$$$0(1);
            }
            if (files2 == null) {
                WebpConversionTask.$$$reportNull$$$0(2);
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (VirtualFile file : files2) {
                    try {
                        BufferedImage image;
                        if (!file.isValid() || (image = ImageIO.read(file.getInputStream())) == null) continue;
                        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                        ImageIO.write((RenderedImage)image, "PNG", stream);
                        byte[] encoded = stream.toByteArray();
                        VirtualFile folder = file.getParent();
                        VirtualFile output = folder.createChildData(requestor, file.getNameWithoutExtension() + ".png");
                        try (BufferedOutputStream fos = new BufferedOutputStream(output.getOutputStream((Object)this));){
                            ((OutputStream)fos).write(encoded);
                        }
                        if (!this.myDelete) continue;
                        file.delete(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(AndroidLintWebpUnsupportedInspection.class).warn(e.getMessage());
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                WebpConversionTask.$$$reportNull$$$0(3);
            }
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = WebpConversionTask.findImages(progressIndicator, images);
            this.myParentFolders = ConvertFromWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        @NotNull
        private static List<VirtualFile> findImages(@NotNull ProgressIndicator progressIndicator, LinkedList<VirtualFile> images) {
            if (progressIndicator == null) {
                WebpConversionTask.$$$reportNull$$$0(4);
            }
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file = images.pop();
                progressIndicator.setText(file.getPresentableUrl());
                if (file.isDirectory()) {
                    for (VirtualFile f : file.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".webp")) continue;
                files2.add(file);
            }
            ArrayList<VirtualFile> arrayList = files2;
            if (arrayList == null) {
                WebpConversionTask.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findImages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "writeImages";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findImages";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

