/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.SdkConstants;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.DomPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.MenuLayoutParserFactory;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public final class LayoutPullParsers {
    static final boolean DEBUG = false;
    private static final String[] VALID_XML_TAGS = new String[]{"appwidget-provider", "PreferenceScreen", SdkConstants.CLASS_SUPPORT_PREFERENCE_SCREEN.oldName(), SdkConstants.CLASS_SUPPORT_PREFERENCE_SCREEN.newName()};
    private static final String[] ADAPTIVE_ICON_TAGS = new String[]{"adaptive-icon", "maskable-icon"};
    private static final String[] FONT_FAMILY_TAGS = new String[]{"font-family"};
    private static final EnumSet<ResourceFolderType> FOLDER_NEEDS_READ_ACCESS = EnumSet.of(ResourceFolderType.DRAWABLE, ResourceFolderType.MENU, ResourceFolderType.XML, ResourceFolderType.FONT);

    private LayoutPullParsers() {
    }

    private static boolean isXmlWithRootTag(@NotNull PsiFile file, @NotNull String[] rootTags) {
        if (file == null) {
            LayoutPullParsers.$$$reportNull$$$0(0);
        }
        if (rootTags == null) {
            LayoutPullParsers.$$$reportNull$$$0(1);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null) {
            return false;
        }
        String tag = rootTag.getName();
        for (String validRootTags : rootTags) {
            if (!validRootTags.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            LayoutPullParsers.$$$reportNull$$$0(2);
        }
        if ((folderType = ResourceHelper.getFolderType(file)) == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case MIPMAP: {
                return LayoutPullParsers.isXmlWithRootTag(file, ADAPTIVE_ICON_TAGS);
            }
            case XML: {
                return LayoutPullParsers.isXmlWithRootTag(file, VALID_XML_TAGS);
            }
            case FONT: {
                return LayoutPullParsers.isXmlWithRootTag(file, FONT_FAMILY_TAGS);
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(@NotNull RenderTask renderTask) {
        ResourceFolderType folderType;
        if (renderTask == null) {
            LayoutPullParsers.$$$reportNull$$$0(3);
        }
        if ((folderType = renderTask.getContext().getFolderType()) == null) {
            return null;
        }
        if (FOLDER_NEEDS_READ_ACCESS.contains(folderType) && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (ILayoutPullParser)ApplicationManager.getApplication().runReadAction(() -> LayoutPullParsers.create(renderTask));
        }
        XmlFile file = renderTask.getXmlFile();
        if (file == null) {
            throw new IllegalArgumentException("RenderTask always should always have PsiFile when it has ResourceFolderType");
        }
        switch (folderType) {
            case LAYOUT: {
                IRenderLogger logger2 = renderTask.getLogger();
                HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                ResourceResolver resourceResolver2 = renderTask.getContext().getConfiguration().getResourceResolver();
                boolean useToolsNamespace = renderTask.getShowWithToolsAttributes();
                return LayoutPsiPullParser.create(file, logger2, Collections.emptySet(), hardwareConfig.getDensity(), resourceResolver2, useToolsNamespace);
            }
            case DRAWABLE: 
            case MIPMAP: {
                renderTask.setDecorations(false);
                return LayoutPullParsers.createDrawableParser(file);
            }
            case MENU: {
                renderTask.setDecorations(true);
                return LayoutPullParsers.createMenuParser(file, renderTask);
            }
            case XML: {
                XmlTag rootTag = file.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals("appwidget-provider")) {
                        renderTask.setDecorations(false);
                        return LayoutPullParsers.createWidgetParser(rootTag);
                    }
                    if (tag.equals("PreferenceScreen") || SdkConstants.CLASS_SUPPORT_PREFERENCE_SCREEN.isEquals(tag)) {
                        IRenderLogger logger3 = renderTask.getLogger();
                        HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                        ResourceResolver resourceResolver3 = renderTask.getContext().getConfiguration().getResourceResolver();
                        return LayoutPsiPullParser.create(file, logger3, Collections.emptySet(), hardwareConfig.getDensity(), resourceResolver3, true);
                    }
                }
                return null;
            }
            case FONT: {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)renderTask.getContext().getModule());
                renderTask.setTransparentBackground();
                renderTask.setDecorations(false);
                renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                return LayoutPullParsers.createFontFamilyParser(file, fontName -> facet2 != null ? new ProjectFonts(facet2).getFont((String)fontName) : null);
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILayoutPullParser createDrawableParser(XmlFile file) {
        String scaleType;
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParsers.addRootElement(document, "ImageView", ResourceHelper.getResourceNamespace((PsiElement)file));
        LayoutPullParsers.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(imageView, "layout_height", "fill_parent");
        ResourceFolderType type = ResourceHelper.getFolderType((PsiFile)file);
        assert (type != null);
        LayoutPullParsers.setAndroidAttr(imageView, "src", file.getVirtualFile().getPath());
        String background = AndroidPsiUtils.getRootTagAttributeSafely((XmlFile)file, (String)"background", (String)"http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "background", background);
        }
        if ((scaleType = AndroidPsiUtils.getRootTagAttributeSafely((XmlFile)file, (String)"scaleType", (String)"http://schemas.android.com/tools")) != null && !scaleType.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "scaleType", scaleType);
        }
        return DomPullParser.createFromDocument(document);
    }

    @NotNull
    private static ILayoutPullParser createMenuParser(@NotNull XmlFile file, @NotNull RenderTask task2) {
        XmlTag tag;
        if (file == null) {
            LayoutPullParsers.$$$reportNull$$$0(4);
        }
        if (task2 == null) {
            LayoutPullParsers.$$$reportNull$$$0(5);
        }
        if ((tag = file.getRootTag()) != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            task2.setDecorations(false);
            ILayoutPullParser iLayoutPullParser = MenuLayoutParserFactory.createInNavigationView((PsiFile)file);
            if (iLayoutPullParser == null) {
                LayoutPullParsers.$$$reportNull$$$0(6);
            }
            return iLayoutPullParser;
        }
        ILayoutPullParser iLayoutPullParser = MenuLayoutParserFactory.create((PsiFile)file, task2.getLayoutlibCallback());
        if (iLayoutPullParser == null) {
            LayoutPullParsers.$$$reportNull$$$0(7);
        }
        return iLayoutPullParser;
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(XmlTag rootTag) {
        String layout2 = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout2 == null && preview == null) {
            return null;
        }
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root2 = LayoutPullParsers.addRootElement(document, layout2 != null ? "include" : "ImageView", ResourceHelper.getResourceNamespace((PsiElement)rootTag));
        if (layout2 != null) {
            root2.setAttribute("layout", layout2);
            LayoutPullParsers.setAndroidAttr(root2, "layout_width", "fill_parent");
            LayoutPullParsers.setAndroidAttr(root2, "layout_height", "fill_parent");
        } else {
            root2.setAttribute("src", preview);
            LayoutPullParsers.setAndroidAttr(root2, "layout_width", "wrap_content");
            LayoutPullParsers.setAndroidAttr(root2, "layout_height", "wrap_content");
        }
        return DomPullParser.createFromDocument(document);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @Nullable
    static ILayoutPullParser createFontFamilyParser(XmlFile file, @NotNull Function<String, FontFamily> getDownloadableFont) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean needSave(@Nullable ResourceFolderType type) {
        return type != ResourceFolderType.LAYOUT;
    }

    public static void saveFileIfNecessary(PsiFile psiFile2) {
        if (!LayoutPullParsers.needSave(ResourceHelper.getFolderType(psiFile2.getVirtualFile()))) {
            return;
        }
        VirtualFile file = psiFile2.getVirtualFile();
        if (file == null) {
            return;
        }
        FileDocumentManager fileManager = FileDocumentManager.getInstance();
        if (!fileManager.isFileModified(file)) {
            return;
        }
        Document document = fileManager.getCachedDocument(file);
        if (document == null || !fileManager.isDocumentUnsaved(document)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> fileManager.saveDocument(document)));
    }

    public static Element addRootElement(@NotNull org.w3c.dom.Document document, @NotNull String tag, @Nullable ResourceNamespace namespace) {
        if (document == null) {
            LayoutPullParsers.$$$reportNull$$$0(9);
        }
        if (tag == null) {
            LayoutPullParsers.$$$reportNull$$$0(10);
        }
        Element root2 = document.createElementNS(namespace != null ? namespace.getXmlNamespaceUri() : null, tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root2.getAttributes().setNamedItemNS(attr);
        document.appendChild(root2);
        return root2;
    }

    public static Element setAndroidAttr(Element element, String name, String value2) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value2);
        return element;
    }

    public static ILayoutPullParser createEmptyParser() {
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root2 = LayoutPullParsers.addRootElement(document, "FrameLayout", null);
        LayoutPullParsers.setAndroidAttr(root2, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(root2, "layout_height", "fill_parent");
        return DomPullParser.createFromDocument(document);
    }

    private static /* synthetic */ void lambda$createFontFamilyParser$6(boolean[] hasElements, org.w3c.dom.Document document, String loremText, String fontColor, Element rootLayout, String[] font) {
        hasElements[0] = true;
        Element fontElement = document.createElement("TextView");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_width", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_height", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "text", loremText);
        LayoutPullParsers.setAndroidAttr(fontElement, "fontFamily", font[0]);
        LayoutPullParsers.setAndroidAttr(fontElement, "textSize", "30sp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textColor", fontColor);
        LayoutPullParsers.setAndroidAttr(fontElement, "paddingBottom", "20dp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textStyle", font[1]);
        rootLayout.appendChild(fontElement);
    }

    private static /* synthetic */ boolean lambda$createFontFamilyParser$5(String[] font) {
        return StringUtil.isNotEmpty((String)font[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTags";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/parsers/LayoutPullParsers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getDownloadableFont";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/parsers/LayoutPullParsers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMenuParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isXmlWithRootTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMenuParser";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFontFamilyParser";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRootElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

