/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.rendering.parsers.LayoutPullParser;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DomPullParser
extends LayoutPullParser {
    @NotNull
    private final List<Element> myNodeStack;
    private final Element myRoot;
    private Map<Element, ?> myViewCookies;

    private DomPullParser(Element root2, Map<Element, ?> viewCookies) {
        this.myRoot = root2;
        this.myNodeStack = new ArrayList<Element>();
        this.myViewCookies = viewCookies;
    }

    @VisibleForTesting
    public Element getRoot() {
        return this.myRoot;
    }

    protected Element getCurrentElement() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    private Attr getAttribute(int i2) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        Element element = this.getCurrentElement();
        if (element != null) {
            return (Attr)element.getAttributes().item(i2);
        }
        return null;
    }

    private void push(@NotNull Element node) {
        if (node == null) {
            DomPullParser.$$$reportNull$$$0(0);
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    private Element pop() {
        Element element = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (element == null) {
            DomPullParser.$$$reportNull$$$0(1);
        }
        return element;
    }

    public Object getViewCookie() {
        Element element = this.getCurrentElement();
        if (this.myViewCookies != null) {
            return this.myViewCookies.get(element);
        }
        return element;
    }

    public ResourceNamespace getLayoutNamespace() {
        if (this.myRoot == null) {
            return ResourceNamespace.RES_AUTO;
        }
        String uri = this.myRoot.getNamespaceURI();
        if (uri == null) {
            return ResourceNamespace.RES_AUTO;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)uri);
        return namespace != null ? namespace : ResourceNamespace.RES_AUTO;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        Element node = this.getCurrentElement();
        if (node != null) {
            return node.getAttributes().getLength();
        }
        return 0;
    }

    public String getAttributeName(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            String localName = attribute.getLocalName();
            if (localName == null) {
                return attribute.getName();
            }
            return localName;
        }
        return null;
    }

    public String getAttributeNamespace(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getNamespaceURI();
        }
        return "";
    }

    public String getAttributePrefix(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getPrefix();
        }
        return null;
    }

    public String getAttributeValue(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        Element element = this.getCurrentElement();
        if (element != null) {
            Attr attribute = element.getAttributeNodeNS(namespace, localName);
            if (attribute == null && namespace != null && !namespace.equals("http://schemas.android.com/apk/res/android")) {
                attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", localName);
            }
            if (attribute != null) {
                return attribute.getValue();
            }
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getTagName();
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getPrefix();
        }
        return null;
    }

    public String getNamespace(String prefix) {
        Element currentNode = this.getCurrentElement();
        return currentNode != null ? currentNode.lookupNamespaceURI(prefix) : null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getChildNodes().getLength() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        Element node = this.getCurrentElement();
        assert (node != null);
        Element first = XmlUtils.getFirstSubTag((Node)node);
        if (first != null) {
            this.push(first);
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        Node sibling;
        Element node = this.getCurrentElement();
        assert (node != null);
        for (sibling = node.getNextSibling(); sibling != null && !(sibling instanceof Element); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            node = (Element)sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    private static DocumentBuilder createNewDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.getInstance(DomPullParser.class).error((Throwable)e);
            return null;
        }
    }

    public static Document createEmptyPlainDocument() {
        DocumentBuilder builder2 = DomPullParser.createNewDocumentBuilder();
        return builder2 != null ? builder2.newDocument() : null;
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document) {
        if (document == null) {
            DomPullParser.$$$reportNull$$$0(2);
        }
        return new DomPullParser(document.getDocumentElement(), null);
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document, @NotNull Map<Element, ?> viewCookies) {
        if (document == null) {
            DomPullParser.$$$reportNull$$$0(3);
        }
        if (viewCookies == null) {
            DomPullParser.$$$reportNull$$$0(4);
        }
        return new DomPullParser(document.getDocumentElement(), viewCookies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/parsers/DomPullParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCookies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/parsers/DomPullParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

