/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.structure.AndroidProjectSettingsService;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.rendering.AllocationStackTrace;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderTaskAllocationTrackerKt;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolFactory;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenderService
implements Disposable {
    private static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS;
    @VisibleForTesting
    public static long ourRenderThreadTimeoutMs;
    private static final AtomicReference<Thread> ourRenderingThread;
    private static ExecutorService ourRenderingExecutor;
    private static final AtomicInteger ourTimeoutExceptionCounter;
    private static final Key<RenderService> KEY;
    private static boolean isFirstCall;
    private final Project myProject;
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential;
    private final ImagePool myImagePool;
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    private static void innerInitializeRenderExecutor() {
        ourRenderingExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread renderingThread = new Thread(null, r, "Layoutlib Render Thread");
            renderingThread.setDaemon(true);
            ourRenderingThread.set(renderingThread);
            return renderingThread;
        });
    }

    @TestOnly
    public static void initializeRenderExecutor() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        RenderService.innerInitializeRenderExecutor();
    }

    private static void shutdownRenderExecutor() {
        ourRenderingExecutor.shutdownNow();
        Thread currentThread = ourRenderingThread.getAndSet(null);
        if (currentThread != null) {
            currentThread.interrupt();
        }
    }

    @TestOnly
    public static void shutdownRenderExecutor(long timeoutSeconds) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (timeoutSeconds > 0L) {
            try {
                ourRenderingExecutor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                Logger.getInstance(RenderService.class).warn("The RenderExecutor does not shutdown after " + timeoutSeconds + " seconds");
            }
        }
        RenderService.shutdownRenderExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static RenderService getInstance(@NotNull Project project) {
        if (project == null) {
            RenderService.$$$reportNull$$$0(0);
        }
        Key<RenderService> key = KEY;
        // MONITORENTER : key
        RenderService renderService2 = (RenderService)project.getUserData(KEY);
        if (renderService2 == null) {
            renderService2 = new RenderService(project);
            project.putUserData(KEY, (Object)renderService2);
        }
        RenderService renderService = renderService2;
        // MONITOREXIT : key
        if (renderService != null) return renderService;
        RenderService.$$$reportNull$$$0(1);
        return renderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void setForTesting(@NotNull Project project, @Nullable RenderService renderService) {
        if (project == null) {
            RenderService.$$$reportNull$$$0(2);
        }
        Key<RenderService> key = KEY;
        synchronized (key) {
            project.putUserData(KEY, (Object)renderService);
        }
    }

    @VisibleForTesting
    protected RenderService(@NotNull Project project) {
        if (project == null) {
            RenderService.$$$reportNull$$$0(3);
        }
        this.myCredential = new Object();
        this.myImagePool = ImagePoolFactory.createImagePool();
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException renderingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParsers.isSupported(file);
    }

    @NotNull
    public RenderLogger createLogger(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            RenderService.$$$reportNull$$$0(4);
        }
        Module module = facet2.getModule();
        return new RenderLogger(module.getName(), module, this.myCredential);
    }

    @NotNull
    public RenderTaskBuilder taskBuilder(@NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        if (facet2 == null) {
            RenderService.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            RenderService.$$$reportNull$$$0(6);
        }
        return new RenderTaskBuilder(this, facet2, configuration, this.myImagePool, this.myCredential);
    }

    public void dispose() {
        this.myProject.putUserData(KEY, null);
        this.myImagePool.dispose();
    }

    @Nullable
    public AndroidPlatform getPlatform(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            RenderService.$$$reportNull$$$0(7);
        }
        return AndroidPlatform.getInstance(facet2.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull AndroidFacet facet2, @Nullable RenderLogger logger2) {
        Module module;
        AndroidPlatform platform;
        if (facet2 == null) {
            RenderService.$$$reportNull$$$0(8);
        }
        if ((platform = AndroidPlatform.getInstance(module = facet2.getModule())) == null && logger2 != null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message2 = RenderProblem.create(HighlightSeverity.ERROR);
                logger2.addMessage(message2);
                message2.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger2.getLinkManager().createRunnableLink(() -> {
                    Project project = module.getProject();
                    ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                    if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() && service instanceof AndroidProjectSettingsService) {
                        ((AndroidProjectSettingsService)service).openSdkSettings();
                        return;
                    }
                    AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                }));
            } else {
                String message3 = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger2.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message3));
            }
        }
        return platform;
    }

    public static void runRenderAction(@NotNull Runnable runnable2) throws Exception {
        if (runnable2 == null) {
            RenderService.$$$reportNull$$$0(9);
        }
        RenderService.runRenderAction(Executors.callable(runnable2));
    }

    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        if (callable == null) {
            RenderService.$$$reportNull$$$0(10);
        }
        try {
            if (ourTimeoutExceptionCounter.get() > 3) {
                ourRenderingExecutor.submit(() -> ourTimeoutExceptionCounter.set(0)).get(50L, TimeUnit.MILLISECONDS);
            }
            long timeout = ourRenderThreadTimeoutMs;
            if (isFirstCall) {
                isFirstCall = false;
                timeout *= 2L;
            }
            T result2 = ourRenderingExecutor.submit(callable).get(timeout, TimeUnit.MILLISECONDS);
            ourTimeoutExceptionCounter.set(0);
            return result2;
        }
        catch (TimeoutException e) {
            ourTimeoutExceptionCounter.incrementAndGet();
            Thread renderingThread = ourRenderingThread.get();
            TimeoutException timeoutException = new TimeoutException("Preview timed out while rendering the layout.\nThis typically happens when there is an infinite loop or unbounded recursion in one of the custom views.");
            if (renderingThread != null) {
                timeoutException.setStackTrace(renderingThread.getStackTrace());
            }
            throw timeoutException;
        }
    }

    @NotNull
    public static <T> CompletableFuture<T> runAsyncRenderAction(@NotNull Supplier<T> callable) {
        if (callable == null) {
            RenderService.$$$reportNull$$$0(11);
        }
        CompletableFuture<T> completableFuture = CompletableFuture.supplyAsync(callable, ourRenderingExecutor);
        if (completableFuture == null) {
            RenderService.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    public static void runAsyncRenderAction(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            RenderService.$$$reportNull$$$0(13);
        }
        ourRenderingExecutor.execute(runnable2);
    }

    @NotNull
    public static ViewInfo getSafeBounds(@NotNull ViewInfo view) {
        if (view == null) {
            RenderService.$$$reportNull$$$0(14);
        }
        int left2 = Math.abs(view.getLeft());
        int right2 = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom2 = Math.abs(view.getBottom());
        if (left2 < 0x2000000 && right2 < 0x2000000 && top < 0x2000000 && bottom2 < 0x2000000) {
            ViewInfo viewInfo = view;
            if (viewInfo == null) {
                RenderService.$$$reportNull$$$0(15);
            }
            return viewInfo;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static XmlTag getXmlTag(@NotNull ViewInfo view) {
        Object cookie;
        if (view == null) {
            RenderService.$$$reportNull$$$0(16);
        }
        if ((cookie = view.getCookie()) != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof XmlTag) {
                return (XmlTag)cookie;
            }
        }
        return null;
    }

    @NotNull
    public ImagePool getSharedImagePool() {
        ImagePool imagePool = this.myImagePool;
        if (imagePool == null) {
            RenderService.$$$reportNull$$$0(17);
        }
        return imagePool;
    }

    static {
        ourRenderThreadTimeoutMs = DEFAULT_RENDER_THREAD_TIMEOUT_MS = Long.getLong("layoutlib.thread.timeout", TimeUnit.SECONDS.toMillis(ApplicationManager.getApplication().isUnitTestMode() ? 60L : 6L)).longValue();
        ourRenderingThread = new AtomicReference();
        ourTimeoutExceptionCounter = new AtomicInteger(0);
        KEY = Key.create((String)RenderService.class.getName());
        isFirstCall = true;
        RenderService.innerInitializeRenderExecutor();
        ShutDownTracker.getInstance().registerShutdownTask(RenderService::shutdownRenderExecutor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderService";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncRenderAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafeBounds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedImagePool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setForTesting";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLogger";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "taskBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runRenderAction";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncRenderAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSafeBounds";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getXmlTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RenderTaskBuilder {
        private final RenderService myService;
        private final AndroidFacet myFacet;
        private final Configuration myConfiguration;
        private final Object myCredential;
        @NotNull
        private ImagePool myImagePool;
        @Nullable
        private PsiFile myPsiFile;
        @Nullable
        private RenderLogger myLogger;
        @Nullable
        private ILayoutPullParserFactory myParserFactory;
        private boolean isSecurityManagerEnabled;
        private float myDownscaleFactor;
        private boolean showDecorations;
        private boolean showWithToolsAttributes;
        private int myMaxRenderWidth;
        private int myMaxRenderHeight;
        private boolean isShadowEnabled;
        private boolean useHighQualityShadows;
        private SessionParams.RenderingMode myRenderingMode;
        private boolean useTransparentBackground;

        private RenderTaskBuilder(@NotNull RenderService service, @NotNull AndroidFacet facet2, @NotNull Configuration configuration, @NotNull ImagePool defaultImagePool, @NotNull Object credential) {
            if (service == null) {
                RenderTaskBuilder.$$$reportNull$$$0(0);
            }
            if (facet2 == null) {
                RenderTaskBuilder.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                RenderTaskBuilder.$$$reportNull$$$0(2);
            }
            if (defaultImagePool == null) {
                RenderTaskBuilder.$$$reportNull$$$0(3);
            }
            if (credential == null) {
                RenderTaskBuilder.$$$reportNull$$$0(4);
            }
            this.isSecurityManagerEnabled = true;
            this.myDownscaleFactor = 1.0f;
            this.showDecorations = true;
            this.showWithToolsAttributes = true;
            this.myMaxRenderWidth = -1;
            this.myMaxRenderHeight = -1;
            this.isShadowEnabled = (Boolean)StudioFlags.NELE_ENABLE_SHADOW.get();
            this.useHighQualityShadows = (Boolean)StudioFlags.NELE_RENDER_HIGH_QUALITY_SHADOW.get();
            this.myRenderingMode = null;
            this.useTransparentBackground = false;
            this.myService = service;
            this.myFacet = facet2;
            this.myConfiguration = configuration;
            this.myImagePool = defaultImagePool;
            this.myCredential = credential;
        }

        @NotNull
        public RenderTaskBuilder withPsiFile(@NotNull PsiFile psiFile2) {
            if (psiFile2 == null) {
                RenderTaskBuilder.$$$reportNull$$$0(5);
            }
            this.myPsiFile = psiFile2;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(6);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder withLogger(@NotNull RenderLogger logger2) {
            if (logger2 == null) {
                RenderTaskBuilder.$$$reportNull$$$0(7);
            }
            this.myLogger = logger2;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(8);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder withParserFactory(@NotNull ILayoutPullParserFactory parserFactory) {
            if (parserFactory == null) {
                RenderTaskBuilder.$$$reportNull$$$0(9);
            }
            this.myParserFactory = parserFactory;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(10);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder disableImagePool() {
            this.myImagePool = ImagePoolFactory.getNonPooledPool();
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(11);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder withDownscaleFactor(float downscaleFactor) {
            this.myDownscaleFactor = downscaleFactor;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(12);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder withMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
            this.myMaxRenderWidth = maxRenderWidth;
            this.myMaxRenderHeight = maxRenderHeight;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(13);
            }
            return renderTaskBuilder;
        }

        @TestOnly
        @VisibleForTesting
        @NotNull
        public RenderTaskBuilder disableSecurityManager() {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("This method can only be called in unit test mode");
            }
            this.isSecurityManagerEnabled = false;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(14);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder disableDecorations() {
            this.showDecorations = false;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(15);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder disableShadow() {
            this.isShadowEnabled = false;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(16);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder disableHighQualityShadow() {
            this.useHighQualityShadows = false;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(17);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder disableToolsAttributes() {
            this.showWithToolsAttributes = false;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(18);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder withRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
            if (renderingMode == null) {
                RenderTaskBuilder.$$$reportNull$$$0(19);
            }
            this.myRenderingMode = renderingMode;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(20);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public RenderTaskBuilder useTransparentBackground() {
            this.useTransparentBackground = true;
            RenderTaskBuilder renderTaskBuilder = this;
            if (renderTaskBuilder == null) {
                RenderTaskBuilder.$$$reportNull$$$0(21);
            }
            return renderTaskBuilder;
        }

        @NotNull
        public CompletableFuture<RenderTask> build() {
            if (this.myLogger == null) {
                this.withLogger(this.myService.createLogger(this.myFacet));
            }
            AllocationStackTrace stackTraceElement = RenderTaskAllocationTrackerKt.captureAllocationStackTrace();
            CompletableFuture<RenderTask> completableFuture = CompletableFuture.supplyAsync(() -> {
                LayoutLibrary layoutLib;
                AndroidPlatform platform = RenderService.getPlatform(this.myFacet, this.myLogger);
                if (platform == null) {
                    return null;
                }
                IAndroidTarget target = this.myConfiguration.getTarget();
                if (target == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
                    return null;
                }
                Module module = this.myFacet.getModule();
                try {
                    layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(module.getProject());
                }
                catch (UnsupportedJavaRuntimeException e) {
                    RenderProblem.Html javaVersionProblem = RenderProblem.create(HighlightSeverity.ERROR);
                    javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", RenderService.JDK_INSTALL_URL);
                    this.myLogger.addMessage(javaVersionProblem);
                    return null;
                }
                catch (RenderingException e) {
                    String message2 = e.getPresentableMessage();
                    message2 = message2 != null ? message2 : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, module.getProject(), this.myLogger.getLinkManager(), e));
                    return null;
                }
                Device device = this.myConfiguration.getDevice();
                if (device == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
                    return null;
                }
                try {
                    RenderTask task2 = new RenderTask(this.myFacet, this.myService, this.myConfiguration, this.myLogger, layoutLib, device, this.myCredential, (CrashReporter)StudioCrashReporter.getInstance(), this.myImagePool, this.myParserFactory, this.isSecurityManagerEnabled, this.myDownscaleFactor, stackTraceElement);
                    if (this.myPsiFile instanceof XmlFile) {
                        task2.setXmlFile((XmlFile)this.myPsiFile);
                    }
                    task2.setDecorations(this.showDecorations).setHighQualityShadows(this.useHighQualityShadows).setShadowEnabled(this.isShadowEnabled).setShowWithToolsAttributes(this.showWithToolsAttributes);
                    if (this.myMaxRenderWidth != -1 && this.myMaxRenderHeight != -1) {
                        task2.setMaxRenderSize(this.myMaxRenderWidth, this.myMaxRenderHeight);
                    }
                    if (this.useTransparentBackground) {
                        task2.setTransparentBackground();
                    }
                    if (this.myRenderingMode != null) {
                        task2.setRenderingMode(this.myRenderingMode);
                    }
                    return task2;
                }
                catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
                    if (!module.isDisposed()) {
                        throw e;
                    }
                    return null;
                }
            }, AppExecutorUtil.getAppExecutorService());
            if (completableFuture == null) {
                RenderTaskBuilder.$$$reportNull$$$0(22);
            }
            return completableFuture;
        }

        @Deprecated
        @Nullable
        public RenderTask buildSynchronously() {
            return (RenderTask)Futures.getUnchecked(this.build());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultImagePool";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credential";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/RenderService$RenderTaskBuilder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parserFactory";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderingMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/RenderService$RenderTaskBuilder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPsiFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLogger";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withParserFactory";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableImagePool";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDownscaleFactor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withMaxRenderSize";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableSecurityManager";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableDecorations";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableShadow";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableHighQualityShadow";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableToolsAttributes";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRenderingMode";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useTransparentBackground";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withPsiFile";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withLogger";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withParserFactory";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "withRenderingMode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

