/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.android.tools.idea.rendering.RenderPropertiesAccessUtil;
import com.android.tools.idea.rendering.RenderSecurityException;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Permission;
import java.util.PropertyPermission;

public class RenderSecurityManager
extends SecurityManager {
    public static final String ENABLED_PROPERTY = "android.render.sandbox";
    public static final boolean RESTRICT_READS = false;
    public static boolean sEnabled = !"false".equals(System.getProperty("android.render.sandbox"));
    private static ThreadLocal<Boolean> sIsRenderThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        protected synchronized Boolean childValue(Boolean parentValue) {
            return parentValue;
        }
    };
    private static Object sCredential;
    private static String sLastFailedPath;
    private boolean mAllowSetSecurityManager;
    private boolean mDisabled;
    private String mSdkPath;
    private String mProjectPath;
    private String mTempDir;
    private String mNormalizedTempDir;
    private String mCanonicalTempDir;
    private String mAppTempDir;
    private SecurityManager myPreviousSecurityManager;
    private ILogger mLogger;

    public static RenderSecurityManager getCurrent() {
        SecurityManager securityManager;
        if (sIsRenderThread.get().booleanValue() && (securityManager = System.getSecurityManager()) instanceof RenderSecurityManager) {
            RenderSecurityManager manager = (RenderSecurityManager)securityManager;
            return manager.isRelevant() ? manager : null;
        }
        return null;
    }

    public RenderSecurityManager(String sdkPath, String projectPath) {
        this.mSdkPath = sdkPath;
        this.mProjectPath = projectPath;
        this.mTempDir = System.getProperty("java.io.tmpdir");
        this.mNormalizedTempDir = new File(this.mTempDir).getPath();
        sLastFailedPath = null;
    }

    public RenderSecurityManager setLogger(ILogger logger2) {
        this.mLogger = logger2;
        return this;
    }

    public RenderSecurityManager setAppTempDir(String appTempDir) {
        this.mAppTempDir = appTempDir;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active, Object credential) {
        boolean isActive;
        SecurityManager current = System.getSecurityManager();
        boolean bl = isActive = current == this;
        if (active == isActive) {
            return;
        }
        if (active) {
            assert (!(current instanceof RenderSecurityManager));
            this.myPreviousSecurityManager = current;
            sIsRenderThread.set(true);
            this.mDisabled = false;
            System.setSecurityManager(this);
            sCredential = credential;
        } else {
            if (credential != sCredential) {
                throw RenderSecurityException.create("Invalid credential");
            }
            this.mAllowSetSecurityManager = true;
            try {
                if (current instanceof RenderSecurityManager) {
                    System.setSecurityManager(this.myPreviousSecurityManager);
                } else if (this.mLogger != null) {
                    sIsRenderThread.set(false);
                    this.mLogger.warning("Security manager was changed behind the scenes: ", new Object[]{current});
                }
            }
            finally {
                this.mDisabled = true;
                this.mAllowSetSecurityManager = false;
                sIsRenderThread.set(false);
            }
        }
    }

    private boolean isRelevant() {
        return sEnabled && !this.mDisabled && sIsRenderThread.get() != false;
    }

    public void dispose(Object credential) {
        this.setActive(false, credential);
    }

    public static boolean enterSafeRegion(Object credential) {
        boolean token = sEnabled;
        if (credential == sCredential) {
            sEnabled = false;
        }
        return token;
    }

    public static void exitSafeRegion(boolean token) {
        sEnabled = token;
    }

    public static String getLastFailedPath() {
        return sLastFailedPath;
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (which == 1 && this.isRelevant() && RenderSecurityException.class.getName().equals(clazz.getName())) {
            throw RenderSecurityException.create("Reflection", clazz.getName());
        }
    }

    @Override
    public void checkPropertyAccess(String property2) {
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.isRelevant() && !RenderPropertiesAccessUtil.isPropertyAccessAllowed()) {
            throw RenderSecurityException.create("Property", null);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.isRelevant() && (lib.indexOf(47) != -1 || lib.indexOf(92) != -1)) {
            if (lib.startsWith(System.getProperty("java.home"))) {
                return;
            }
            if (lib.equals(new File(WebpNativeLibHelper.getLibLocation(), WebpNativeLibHelper.getLibName()).getAbsolutePath())) {
                return;
            }
            throw RenderSecurityException.create("Link", lib);
        }
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkRead(String file) {
    }

    @Override
    public void checkRead(String file, Object context) {
    }

    private boolean isReadingAllowed(String path2) {
        return true;
    }

    private boolean isWritingAllowed(String path2) {
        return this.isTempDirPath(path2);
    }

    private boolean isTempDirPath(String path2) {
        if (path2.startsWith(this.mTempDir) || path2.startsWith(this.mNormalizedTempDir)) {
            return true;
        }
        if (this.mAppTempDir != null && path2.startsWith(this.mAppTempDir)) {
            return true;
        }
        try {
            if (this.mCanonicalTempDir == null) {
                this.mCanonicalTempDir = new File(this.mNormalizedTempDir).getCanonicalPath();
            }
            if (path2.startsWith(this.mCanonicalTempDir) || new File(path2).getCanonicalPath().startsWith(this.mCanonicalTempDir)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sLastFailedPath = path2;
        return false;
    }

    private static boolean isPropertyWriteAllowed(String name) {
        if (name.equals("sun.font.fontmanager")) {
            return true;
        }
        if (name.startsWith("sun.awt.") || name.startsWith("apple.awt.")) {
            return true;
        }
        return name.equals("user.timezone");
    }

    @Override
    public void checkExit(int status) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exit", String.valueOf(status));
        }
        super.checkExit(status);
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Package", pkg);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exec", cmd);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", "port " + port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", null);
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress, byte ttl) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file)) {
                return;
            }
            throw RenderSecurityException.create("Delete", file);
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Event", null);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Write", fileDescriptor.toString());
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file)) {
                return;
            }
            throw RenderSecurityException.create("Write", file);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Print", null);
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Clipboard", null);
        }
    }

    public boolean checkTopLevelWindow(Object context) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Window", null);
        }
        return false;
    }

    @Override
    public void checkAccess(Thread thread) {
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
    }

    @Override
    public void checkPermission(Permission permission) {
        String actions2;
        String name = permission.getName();
        if ("setSecurityManager".equals(name)) {
            if (this.isRelevant()) {
                if (!this.mAllowSetSecurityManager) {
                    throw RenderSecurityException.create("Security", null);
                }
            } else if (this.mLogger != null) {
                this.mLogger.warning("RenderSecurityManager being replaced by another thread", new Object[0]);
            }
        } else if (!(!this.isRelevant() || (actions2 = permission.getActions()).isEmpty() || actions2.equals("read") || permission instanceof FilePermission && this.isWritingAllowed(name))) {
            if (permission instanceof PropertyPermission && RenderSecurityManager.isPropertyWriteAllowed(name)) {
                return;
            }
            throw RenderSecurityException.create("Write", name);
        }
    }
}

