/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.lint.UpgradeConstraintLayoutFix;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
extends LayoutLog
implements IRenderLogger {
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    public static final String TAG_STILL_BUILDING = "project.building";
    static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderLogger");
    private static final boolean LOG_ALL = Boolean.getBoolean("adt.renderLog") || ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    @VisibleForTesting
    static final int RENDER_PROBLEMS_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.RENDER_PROBLEMS_LIMIT", 100);
    @VisibleForTesting
    static final int STACK_OVERFLOW_TRACE_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.STACK_OVERFLOW_TRACE_LIMIT", 100);
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final Module myModule;
    private final String myName;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Multiset<String> myTags;
    @GuardedBy(value="myMessages")
    private final List<RenderProblem> myMessages = new ArrayList<RenderProblem>();
    @GuardedBy(value="myMessages")
    private int myMessagesOverflowCounter;
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private Map<String, Throwable> myClassesWithIncorrectFormat;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;
    private static final int ANDROID_LOG_UNKNOWN = 0;
    private static final int ANDROID_LOG_DEFAULT = 1;
    private static final int ANDROID_LOG_VERBOSE = 2;
    private static final int ANDROID_LOG_DEBUG = 3;
    private static final int ANDROID_LOG_INFO = 4;
    private static final int ANDROID_LOG_WARN = 5;
    private static final int ANDROID_LOG_ERROR = 6;
    private static final int ANDROID_LOG_FATAL = 7;
    private static final int ANDROID_LOG_SILENT = 8;

    public RenderLogger(@Nullable String name, @Nullable Module module, @Nullable Object credential) {
        this.myName = name;
        this.myModule = module;
        this.myCredential = credential;
    }

    public RenderLogger(@Nullable String name, @Nullable Module module) {
        this(name, module, null);
    }

    @VisibleForTesting
    static void resetFidelityErrorsFilters() {
        ourIgnoreAllFidelityWarnings = false;
        if (ourIgnoredFidelityWarnings != null) {
            ourIgnoredFidelityWarnings.clear();
        }
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (clientData == null) {
            RenderLogger.$$$reportNull$$$0(0);
        }
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new HashSet<String>();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message2, @Nullable Throwable throwable) {
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            return throwable != null && throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        String string = message2;
        if (string == null) {
            RenderLogger.$$$reportNull$$$0(1);
        }
        return string;
    }

    static boolean isIssue164378(@Nullable Throwable throwable) {
        StackTraceElement[] stackTrace;
        return throwable instanceof NoSuchFieldError && (stackTrace = throwable.getStackTrace()).length >= 1 && stackTrace[0].getClassName().startsWith("android.support");
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    public Project getProject() {
        if (this.myModule != null) {
            return this.myModule.getProject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageToIdeaLog(@NotNull String message2, @Nullable Throwable t) {
        Object logMessage;
        if (message2 == null) {
            RenderLogger.$$$reportNull$$$0(2);
        }
        if (t == null) {
            logMessage = message2;
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            writer.println(t.getMessage());
            t.printStackTrace(writer);
            logMessage = message2 + "\n" + stringWriter.toString();
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            LOG.debug((String)logMessage);
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private void logMessageToIdeaLog(@NotNull String message2) {
        if (message2 == null) {
            RenderLogger.$$$reportNull$$$0(3);
        }
        this.logMessageToIdeaLog(message2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(@NotNull RenderProblem message2) {
        if (message2 == null) {
            RenderLogger.$$$reportNull$$$0(4);
        }
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            if (this.myMessages.size() < RENDER_PROBLEMS_LIMIT) {
                this.myMessages.add(message2);
            } else {
                ++this.myMessagesOverflowCounter;
            }
        }
        this.logMessageToIdeaLog(XmlUtils.fromXmlAttributeValue((String)message2.getHtml()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RenderProblem> getMessages() {
        int overflowCounter;
        ImmutableList.Builder builder2 = ImmutableList.builder();
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            builder2.addAll(this.myMessages);
            overflowCounter = this.myMessagesOverflowCounter;
        }
        if (overflowCounter > 0) {
            builder2.add((Object)RenderProblem.createPlain(HighlightSeverity.WARNING, String.format(Locale.US, "Too many errors (%d more errors not displayed)", overflowCounter)));
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            RenderLogger.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.myFidelityWarnings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean hasMessage;
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            hasMessage = !this.myMessages.isEmpty();
        }
        return this.myHaveExceptions || hasMessage || this.myClassesWithIncorrectFormat != null || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<RenderProblem> getFidelityWarnings() {
        List<RenderProblem> list = this.myFidelityWarnings != null ? this.myFidelityWarnings : Collections.emptyList();
        if (list == null) {
            RenderLogger.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        AndroidFacet facet2;
        Object description = RenderLogger.describe(message2, null);
        if (tag == null && message2 != null && (message2.startsWith("Failed to find style ") || message2.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        if ("resources.resolve.theme".equals(tag) && this.myModule != null && BuildSettings.getInstance(this.myModule.getProject()).getBuildMode() == BuildMode.SOURCE_GEN && (facet2 = AndroidFacet.getInstance((Module)this.myModule)) != null && AndroidModel.isRequired(facet2)) {
            description = "Still building project; theme resources from libraries may be missing. Layout should refresh when the build is complete.\n\n" + (String)description;
            tag = TAG_STILL_BUILDING;
            this.addTag(tag);
        }
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, (String)description).tag(tag));
    }

    @NotNull
    private static StackOverflowError summarizeStackOverFlowException(@NotNull StackOverflowError stackOverflowError) {
        StackTraceElement[] stackTraceElements;
        int traceSize;
        if (stackOverflowError == null) {
            RenderLogger.$$$reportNull$$$0(7);
        }
        if ((traceSize = (stackTraceElements = stackOverflowError.getStackTrace()).length) < STACK_OVERFLOW_TRACE_LIMIT) {
            StackOverflowError stackOverflowError2 = stackOverflowError;
            if (stackOverflowError2 == null) {
                RenderLogger.$$$reportNull$$$0(8);
            }
            return stackOverflowError2;
        }
        int elementsToCopy = STACK_OVERFLOW_TRACE_LIMIT / 2;
        StackTraceElement[] newStackTraceElements = new StackTraceElement[elementsToCopy * 2 + 1];
        newStackTraceElements[elementsToCopy] = new StackTraceElement("omitted", "omitted", "omitted", -1);
        System.arraycopy(stackTraceElements, 0, newStackTraceElements, 0, elementsToCopy);
        System.arraycopy(stackTraceElements, stackTraceElements.length - elementsToCopy, newStackTraceElements, elementsToCopy + 1, elementsToCopy);
        stackOverflowError.setStackTrace(newStackTraceElements);
        StackOverflowError stackOverflowError3 = stackOverflowError;
        if (stackOverflowError3 == null) {
            RenderLogger.$$$reportNull$$$0(9);
        }
        return stackOverflowError3;
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        Object description = RenderLogger.describe(message2, throwable);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (RenderLogger.isIssue164378(throwable)) {
                return;
            }
            if ("Unable to find the layout for Action Bar.".equals(description)) {
                description = (String)description + "\nConsider updating to a more recent version of appcompat, or switch the rendering library in the IDE down to API 21";
            }
            if (((String)description).isEmpty()) {
                description = "Exception raised during rendering";
            } else if (((String)description).equals(throwable.getLocalizedMessage()) || ((String)description).equals(throwable.getMessage())) {
                description = "Exception raised during rendering: " + (String)description;
            } else {
                if (message2 != null && message2.equals("onMeasure error") && throwable.toString().startsWith("java.lang.NoSuchMethodError: android.support.constraint.solver.widgets.Guideline.setRelative")) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    String issue2 = "214853";
                    problem.tag(issue2);
                    problem.throwable(throwable);
                    HtmlBuilder builder2 = problem.getHtmlBuilder();
                    builder2.add("You appear to be using constraint layout version alpha3 or earlier; you must use version alpha4 or later with this version of the layout editor (because the API for guidelines changed incompatibly as of alpha4.)");
                    builder2.add(" (");
                    builder2.addLink("Update Library", this.getLinkManager().createRunnableLink(() -> UpgradeConstraintLayoutFix.apply(this.myModule)));
                    builder2.add(", ");
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.getProject(), throwable);
                    builder2.addLink("Show Exception", this.getLinkManager().createRunnableLink(detailsFix));
                    builder2.add(")");
                    this.addMessage(problem);
                    return;
                }
                if (message2 != null && message2.startsWith("Failed to configure parser for ") && message2.endsWith(".png")) {
                    StackTraceElement[] frames;
                    for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                        if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                            String basePath;
                            String path2 = message2.substring("Failed to configure parser for ".length());
                            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                            problem.tag("bitmapAsColor");
                            HtmlBuilder builder3 = problem.getHtmlBuilder();
                            builder3.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                            builder3.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                            builder3.newline().newline();
                            path2 = FileUtil.toSystemIndependentName((String)path2);
                            String string = basePath = this.getProject() != null && this.getProject().getBasePath() != null ? FileUtil.toSystemIndependentName((String)this.getProject().getBasePath()) : null;
                            if (basePath != null && path2.startsWith(basePath)) {
                                path2 = path2.substring(basePath.length());
                                path2 = StringUtil.trimStart((String)path2, (String)File.separator);
                            }
                            path2 = FileUtil.toSystemDependentName((String)path2);
                            builder3.add("The relevant image is ").add(path2);
                            HashSet<String> widgets = new HashSet<String>();
                            for (StackTraceElement f : frames) {
                                String className;
                                if (!f.getMethodName().equals("<init>") || !(className = f.getClassName()).startsWith("android.widget.")) continue;
                                widgets.add(className.substring(className.lastIndexOf(46) + 1));
                            }
                            if (!widgets.isEmpty()) {
                                ArrayList sorted2 = Lists.newArrayList(widgets);
                                Collections.sort(sorted2);
                                builder3.newline().newline().add("Widgets possibly involved: ").add(Joiner.on((String)", ").join((Iterable)sorted2));
                            }
                            this.addMessage(problem);
                            return;
                        }
                        if (!frame.getClassName().startsWith("com.android.tools.")) {
                            continue;
                        }
                        break;
                    }
                } else {
                    if (message2 != null && message2.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                        int end;
                        int index;
                        XmlPullParserException e = (XmlPullParserException)throwable;
                        Object msg = e.getMessage();
                        if (((String)msg).startsWith("Binary XML file ") && (index = ((String)msg).indexOf(58)) != -1 && index < ((String)msg).length() - 1) {
                            msg = ((String)msg).substring(index + 1).trim();
                        }
                        int lineNumber = e.getLineNumber();
                        int column = e.getColumnNumber();
                        String reader = " in java.io.InputStreamReader@";
                        int index2 = ((String)msg).indexOf(reader);
                        if (index2 != -1 && (end = ((String)msg).indexOf(41, index2 + 1)) != -1) {
                            msg = ((String)msg).substring(0, index2) + ((String)msg).substring(end);
                        }
                        String path3 = message2.substring("Failed to parse file ".length());
                        RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                        problem.tag("xmlParse");
                        HtmlBuilder builder4 = problem.getHtmlBuilder();
                        if (lineNumber != -1) {
                            builder4.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                        }
                        builder4.add((String)msg);
                        if (lineNumber != -1) {
                            builder4.add(" (");
                            File file = new File(path3);
                            String url = HtmlLinkManager.createFilePositionUrl(file, lineNumber, column);
                            if (url != null) {
                                builder4.addLink("Show", url);
                                builder4.add(")");
                            }
                        }
                        this.addMessage(problem);
                        return;
                    }
                    if (throwable instanceof StackOverflowError) {
                        throwable = RenderLogger.summarizeStackOverFlowException((StackOverflowError)throwable);
                    }
                }
            }
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        if (this.getProject() == null) {
            this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, (String)description).tag(tag).throwable(throwable));
        } else {
            this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, (String)description, this.getProject(), this.getLinkManager(), throwable).tag(tag));
        }
    }

    public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        if (message2 == null) {
            RenderLogger.$$$reportNull$$$0(10);
        }
        String description = RenderLogger.describe(message2, null);
        if ("info".equals(tag)) {
            Logger.getInstance(this.getClass()).info(description);
            return;
        }
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description.equals("You must supply a layout_width attribute.") || description.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value2 = matcher.group(1);
                problem.setClientData(new String[]{attribute, value2});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value2);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value3 = matcher.group(1);
                problem.setClientData(new String[]{attribute, value3});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value3);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else if (TAG_MISSING_FRAGMENT.equals(tag)) {
            if (!ourIgnoreFragments) {
                if (this.myMissingFragments == null) {
                    this.myMissingFragments = new ArrayList<String>();
                }
                String name = data instanceof String ? (String)data : null;
                this.myMissingFragments.add(name);
            }
            return;
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.WARNING, description).tag(tag));
    }

    public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message2)) {
            return;
        }
        String description = RenderLogger.describe(message2, throwable);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description)) {
            return;
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem error = RenderProblem.createDeferred(HighlightSeverity.ERROR, tag, description, throwable);
        error.setClientData(description);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = new HashSet<String>();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description);
        this.addTag(tag);
    }

    private void addTag(@Nullable String tag) {
        if (tag == null) {
            return;
        }
        if (this.myTags == null) {
            this.myTags = HashMultiset.create();
        }
        this.myTags.add((Object)tag);
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (prefix == null) {
            RenderLogger.$$$reportNull$$$0(11);
        }
        if (this.myTags == null) {
            return false;
        }
        return this.myTags.stream().anyMatch(s -> s.startsWith(prefix));
    }

    @Override
    @NotNull
    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = new HtmlLinkManager();
        }
        HtmlLinkManager htmlLinkManager = this.myLinkManager;
        if (htmlLinkManager == null) {
            RenderLogger.$$$reportNull$$$0(12);
        }
        return htmlLinkManager;
    }

    @Override
    public void setHasLoadedClasses() {
        this.myHasLoadedClasses = true;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Override
    public void setMissingResourceClass() {
        this.myMissingResourceClass = true;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Override
    public void setResourceClass(@NotNull String resourceClass) {
        if (resourceClass == null) {
            RenderLogger.$$$reportNull$$$0(13);
        }
        this.myResourceClass = resourceClass;
    }

    @NotNull
    public Map<String, Throwable> getClassesWithIncorrectFormat() {
        Map<String, Throwable> map2 = this.myClassesWithIncorrectFormat != null ? this.myClassesWithIncorrectFormat : Collections.emptyMap();
        if (map2 == null) {
            RenderLogger.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NotNull
    public Map<String, Throwable> getBrokenClasses() {
        Map<String, Throwable> map2 = this.myBrokenClasses != null ? this.myBrokenClasses : Collections.emptyMap();
        if (map2 == null) {
            RenderLogger.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @NotNull
    public Set<String> getMissingClasses() {
        Set<String> set = this.myMissingClasses != null ? this.myMissingClasses : Collections.emptySet();
        if (set == null) {
            RenderLogger.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Override
    public void addMissingClass(@NotNull String className) {
        if (className == null) {
            RenderLogger.$$$reportNull$$$0(17);
        }
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
            this.logMessageToIdeaLog("Class not found " + className);
        }
    }

    @Override
    public void addIncorrectFormatClass(@NotNull String className, @NotNull Throwable exception) {
        if (className == null) {
            RenderLogger.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            RenderLogger.$$$reportNull$$$0(19);
        }
        if (this.myClassesWithIncorrectFormat == null) {
            this.myClassesWithIncorrectFormat = new HashMap<String, Throwable>();
        }
        this.myClassesWithIncorrectFormat.put(className, exception);
        this.logMessageToIdeaLog("Class with incorrect format " + className, exception);
    }

    @Override
    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        if (className == null) {
            RenderLogger.$$$reportNull$$$0(20);
        }
        if (exception == null) {
            RenderLogger.$$$reportNull$$$0(21);
        }
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
        this.logMessageToIdeaLog("Broken class " + className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logAndroidFramework(int priority, String tag, String message2) {
        if ((Boolean)StudioFlags.NELE_LOG_ANDROID_FRAMEWORK.get() == false) return;
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            String fullMessage = tag + ": " + message2;
            switch (priority) {
                case 2: 
                case 3: {
                    LOG.debug(fullMessage);
                    return;
                }
                case 4: {
                    LOG.info(fullMessage);
                    return;
                }
                case 5: 
                case 6: {
                    LOG.warn(fullMessage);
                    return;
                }
                case 7: {
                    LOG.error(fullMessage);
                    return;
                }
            }
            return;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientData";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderLogger";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackOverflowError";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceClass";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFidelityWarnings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "summarizeStackOverFlowException";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesWithIncorrectFormat";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ignoreFidelityWarning";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logMessageToIdeaLog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "summarizeStackOverFlowException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "seenTagPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setResourceClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMissingClass";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addIncorrectFormatClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addBrokenClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

