/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.util.PathString;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.HashCodes;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    @NotNull
    private final ResourceResolver myResourceResolver;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Configuration myConfiguration;

    public GutterIconRenderer(@NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2, @NotNull VirtualFile file, @NotNull Configuration configuration) {
        if (resourceResolver2 == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GutterIconRenderer.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            GutterIconRenderer.$$$reportNull$$$0(3);
        }
        this.myResourceResolver = resourceResolver2;
        this.myFacet = facet2;
        this.myFile = file;
        this.myConfiguration = configuration;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = GutterIconCache.getInstance().getIcon(this.myFile, (RenderResources)this.myResourceResolver, this.myFacet);
        Icon icon3 = icon2 == null ? EmptyIcon.ICON_0 : icon2;
        if (icon3 == null) {
            GutterIconRenderer.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    @NotNull
    public AnAction getClickAction() {
        return new GutterIconClickAction(this.myFile, this.myResourceResolver, this.myFacet, this.myConfiguration);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myFacet.equals((Object)that.myFacet)) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myFacet.hashCode(), (int)this.myFile.hashCode());
    }

    @NotNull
    private static PathString getResourcesRoot(@NotNull IAndroidTarget target) {
        String targetResources;
        if (target == null) {
            GutterIconRenderer.$$$reportNull$$$0(5);
        }
        if (SdkUtils.endsWithIgnoreCase((String)(targetResources = target.getPath(11)), (String)".jar")) {
            return new PathString("jar", targetResources + "!/");
        }
        PathString pathString = new PathString("file", targetResources).getParentOrRoot();
        if (pathString == null) {
            GutterIconRenderer.$$$reportNull$$$0(6);
        }
        return pathString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static interface NavigationTargetProvider {
        @Nullable
        public VirtualFile getNavigationTarget();
    }

    private static final class GutterIconClickAction
    extends AnAction
    implements NavigationTargetProvider {
        private static final int PREVIEW_MAX_WIDTH = JBUIScale.scale((int)128);
        private static final int PREVIEW_MAX_HEIGHT = JBUIScale.scale((int)128);
        private static final String PREVIEW_TEXT = "Click Image to Open Resource";
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ResourceResolver myResourceResolver;
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final Configuration myConfiguration;
        @Nullable
        private VirtualFile myNavigationTarget;
        private boolean myNavigationTargetComputed;

        private GutterIconClickAction(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
            if (file == null) {
                GutterIconClickAction.$$$reportNull$$$0(0);
            }
            if (resourceResolver2 == null) {
                GutterIconClickAction.$$$reportNull$$$0(1);
            }
            if (facet2 == null) {
                GutterIconClickAction.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                GutterIconClickAction.$$$reportNull$$$0(3);
            }
            this.myFile = file;
            this.myResourceResolver = resourceResolver2;
            this.myFacet = facet2;
            this.myConfiguration = configuration;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Project project;
            Editor editor2;
            if (event == null) {
                GutterIconClickAction.$$$reportNull$$$0(4);
            }
            if ((editor2 = (Editor)event.getData(CommonDataKeys.EDITOR)) != null && (project = editor2.getProject()) != null) {
                VirtualFile navigationTarget = this.getNavigationTarget();
                Runnable onClick = navigationTarget == null ? null : () -> GutterIconClickAction.openImageResourceTab(project, navigationTarget);
                JBPopup preview = this.createPreview(onClick);
                if (preview != null) {
                    preview.show(new RelativePoint((MouseEvent)event.getInputEvent()));
                } else if (navigationTarget != null) {
                    GutterIconClickAction.openImageResourceTab(project, navigationTarget);
                }
            }
        }

        @Nullable
        private JBPopup createPreview(final @Nullable Runnable onClick) {
            Icon icon2 = GutterIconFactory.createIcon(this.myFile, (RenderResources)this.myResourceResolver, PREVIEW_MAX_WIDTH, PREVIEW_MAX_HEIGHT, this.myFacet);
            if (icon2 == null) {
                return null;
            }
            final JBLabel label = new JBLabel(icon2);
            ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null);
            if (onClick != null) {
                builder2.setAdText(PREVIEW_TEXT, 0);
            }
            final JBPopup popup2 = builder2.createPopup();
            if (onClick != null) {
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        onClick.run();
                        popup2.cancel();
                        label.removeMouseListener((MouseListener)this);
                    }
                });
            }
            return popup2;
        }

        private static void openImageResourceTab(@NotNull Project project, @NotNull VirtualFile navigationTarget) {
            if (project == null) {
                GutterIconClickAction.$$$reportNull$$$0(5);
            }
            if (navigationTarget == null) {
                GutterIconClickAction.$$$reportNull$$$0(6);
            }
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, navigationTarget, -1);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
        }

        @Override
        @VisibleForTesting
        @Nullable
        public VirtualFile getNavigationTarget() {
            if (!this.myNavigationTargetComputed) {
                IAndroidTarget target = this.myConfiguration.getTarget();
                if (target instanceof CompatibilityRenderTarget) {
                    PathString renderResourcesRoot = GutterIconRenderer.getResourcesRoot(target);
                    PathString path2 = FileExtensions.toPathString(this.myFile);
                    if (path2.startsWith(renderResourcesRoot)) {
                        PathString resourcesRoot;
                        VirtualFile file;
                        IAndroidTarget projectTarget = ConfigurationManager.getOrCreateInstance(this.myFacet).getProjectTarget();
                        if (projectTarget != null && (file = FileExtensions.toVirtualFile(path2 = (resourcesRoot = GutterIconRenderer.getResourcesRoot(projectTarget)).resolve(renderResourcesRoot.relativize(path2)))) != null && file.exists()) {
                            this.myNavigationTarget = file;
                        }
                    } else {
                        this.myNavigationTarget = this.myFile;
                    }
                }
                this.myNavigationTargetComputed = true;
            }
            return this.myNavigationTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceResolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationTarget";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer$GutterIconClickAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "openImageResourceTab";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

