/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.projectsystem.GradleSyncResultPublisher;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystemSyncManager;", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncResultPublisher", "Lcom/android/tools/idea/gradle/project/sync/projectsystem/GradleSyncResultPublisher;", "convertReasonToTrigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "reason", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncReason;", "getLastSyncResult", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResult;", "isSyncInProgress", "", "isSyncNeeded", "requestSync", "Lcom/google/common/util/concurrent/ListenableFuture;", "syncProject", "intellij.android.projectSystem.gradle"})
public final class GradleProjectSystemSyncManager
implements ProjectSystemSyncManager {
    private final GradleSyncResultPublisher syncResultPublisher;
    @NotNull
    private final Project project;

    @Contract(pure=true)
    private final GradleSyncStats.Trigger convertReasonToTrigger(ProjectSystemSyncManager.SyncReason reason) {
        return reason == ProjectSystemSyncManager.SyncReason.PROJECT_LOADED ? GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED : (reason == ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED ? GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED : GradleSyncStats.Trigger.TRIGGER_USER_REQUEST);
    }

    private final ListenableFuture<ProjectSystemSyncManager.SyncResult> requestSync(Project project, ProjectSystemSyncManager.SyncReason reason) {
        GradleSyncStats.Trigger trigger = this.convertReasonToTrigger(reason);
        SettableFuture syncResult = SettableFuture.create();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        boolean bl = false;
        boolean bl2 = false;
        MessageBusConnection $this$apply = messageBusConnection;
        boolean bl3 = false;
        $this$apply.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new ProjectSystemSyncManager.SyncResultListener($this$apply, syncResult){
            final /* synthetic */ MessageBusConnection $this_apply;
            final /* synthetic */ SettableFuture $syncResult$inlined;
            {
                this.$this_apply = $receiver;
                this.$syncResult$inlined = settableFuture;
            }

            public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                this.$this_apply.disconnect();
                this.$syncResult$inlined.set((Object)((Object)result2));
            }
        });
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.conne\u2026\n        }\n      })\n    }");
        MessageBusConnection connection = messageBusConnection2;
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        request.runInBackground = true;
        try {
            GradleSyncInvoker.getInstance().requestProjectSync(project, request);
        }
        catch (Throwable t) {
            if (!Disposer.isDisposed((Disposable)((Disposable)connection))) {
                connection.disconnect();
            }
            syncResult.setException(t);
        }
        SettableFuture settableFuture = syncResult;
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"syncResult");
        return (ListenableFuture)settableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<ProjectSystemSyncManager.SyncResult> syncProject(@NotNull ProjectSystemSyncManager.SyncReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        SettableFuture syncResult = SettableFuture.create();
        if (this.isSyncInProgress()) {
            syncResult.setException((Throwable)new RuntimeException("A sync was requested while one is already in progress. Use ProjectSystemSyncManager.isSyncInProgress to detect this scenario."));
        } else if (this.project.isInitialized()) {
            syncResult.setFuture(this.requestSync(this.project, reason));
        } else {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(this, syncResult, reason){
                final /* synthetic */ GradleProjectSystemSyncManager this$0;
                final /* synthetic */ SettableFuture $syncResult;
                final /* synthetic */ ProjectSystemSyncManager.SyncReason $reason;

                public final void run() {
                    GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(this.this$0.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo, (String)"GradleProjectInfo.getInstance(project)");
                    if (!gradleProjectInfo.isImportedProject()) {
                        this.$syncResult.setFuture(GradleProjectSystemSyncManager.access$requestSync(this.this$0, this.this$0.getProject(), this.$reason));
                    } else {
                        this.$syncResult.set((Object)((Object)ProjectSystemSyncManager.SyncResult.SKIPPED));
                    }
                }
                {
                    this.this$0 = gradleProjectSystemSyncManager;
                    this.$syncResult = settableFuture;
                    this.$reason = syncReason;
                }
            });
        }
        SettableFuture settableFuture = syncResult;
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"syncResult");
        return (ListenableFuture)settableFuture;
    }

    @Override
    public boolean isSyncInProgress() {
        return GradleSyncState.Companion.getInstance(this.project).isSyncInProgress();
    }

    @Override
    public boolean isSyncNeeded() {
        return GradleSyncState.Companion.getInstance(this.project).isSyncNeeded() != ThreeState.NO;
    }

    @Override
    @NotNull
    public ProjectSystemSyncManager.SyncResult getLastSyncResult() {
        return this.syncResultPublisher.getLastSyncResult();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GradleProjectSystemSyncManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.syncResultPublisher = GradleSyncResultPublisher.Companion.getInstance(this.project);
    }

    public static final /* synthetic */ ListenableFuture access$requestSync(GradleProjectSystemSyncManager $this, Project project, ProjectSystemSyncManager.SyncReason reason) {
        return $this.requestSync(project, reason);
    }
}

