/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.view.nodes.CaptureNode;
import com.android.tools.idea.profiling.view.nodes.CaptureRootNode;
import com.android.tools.idea.profiling.view.nodes.CaptureTypeNode;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CapturesTreeStructure
extends SimpleTreeStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    CaptureRootNode myRoot;
    @NotNull
    Map<Capture, CaptureNode> myCaptureNodes;
    @NotNull
    Map<CaptureType, CaptureTypeNode> myTypeNodes;

    public CapturesTreeStructure(@NotNull Project project) {
        if (project == null) {
            CapturesTreeStructure.$$$reportNull$$$0(0);
        }
        this.myCaptureNodes = Maps.newHashMap();
        this.myTypeNodes = Maps.newHashMap();
        this.myProject = project;
        this.myRoot = new CaptureRootNode();
    }

    public void update() {
        CaptureService service = CaptureService.getInstance(this.myProject);
        this.myRoot.clear();
        HashMap types = Maps.newHashMap();
        for (CaptureType type : service.getTypes()) {
            CaptureTypeNode typeNode = this.myTypeNodes.get(type);
            if (typeNode == null) {
                typeNode = new CaptureTypeNode(type);
            }
            types.put(type, typeNode);
            this.myRoot.addType(typeNode);
        }
        this.myTypeNodes = types;
        HashMap captures = Maps.newHashMap();
        for (Map.Entry entry : service.getCapturesByType().asMap().entrySet()) {
            CaptureTypeNode typeNode = this.myTypeNodes.get(entry.getKey());
            typeNode.clear();
            for (Capture capture : (Collection)entry.getValue()) {
                CaptureNode captureNode = this.myCaptureNodes.get(capture);
                if (captureNode == null) {
                    captureNode = new CaptureNode(this.myProject, capture);
                } else {
                    captureNode.update();
                }
                captures.put(capture, captureNode);
                typeNode.addCapture(captureNode);
            }
        }
        this.myCaptureNodes = captures;
    }

    public CaptureNode getNode(Capture capture) {
        return this.myCaptureNodes.get(capture);
    }

    @NotNull
    public Object getRootElement() {
        CaptureRootNode captureRootNode = this.myRoot;
        if (captureRootNode == null) {
            CapturesTreeStructure.$$$reportNull$$$0(1);
        }
        return captureRootNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profiling/view/CapturesTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profiling/view/CapturesTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

