/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.ListBoxChooserDialog;
import com.android.tools.idea.profilers.TemporaryProfilerPreferences;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigService;
import com.android.tools.idea.profilers.stacktrace.IntelliJNativeFrameSymbolizer;
import com.android.tools.idea.profilers.stacktrace.IntellijCodeNavigator;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.SymbolFilesLocatorKt;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerPreferences;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Query;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerServices
implements IdeProfilerServices,
Disposable {
    private final IntellijCodeNavigator myCodeNavigator;
    @NotNull
    private final NativeFrameSymbolizer myNativeSymbolizer;
    private final StudioFeatureTracker myFeatureTracker;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IntellijProfilerPreferences myPersistentPreferences;
    @NotNull
    private final TemporaryProfilerPreferences myTemporaryPreferences;

    private static Logger getLogger() {
        return Logger.getInstance(IntellijProfilerServices.class);
    }

    public IntellijProfilerServices(@NotNull Project project) {
        if (project == null) {
            IntellijProfilerServices.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFeatureTracker = new StudioFeatureTracker(this.myProject);
        NativeSymbolizer nativeSymbolizer = NativeSymbolizerKt.createNativeSymbolizer(project);
        Disposer.register((Disposable)this, nativeSymbolizer::stop);
        this.myNativeSymbolizer = new IntelliJNativeFrameSymbolizer(nativeSymbolizer);
        this.myCodeNavigator = new IntellijCodeNavigator(project, nativeSymbolizer, this.myFeatureTracker);
        this.myPersistentPreferences = new IntellijProfilerPreferences();
        this.myTemporaryPreferences = new TemporaryProfilerPreferences();
    }

    public void dispose() {
    }

    @NotNull
    public Executor getMainExecutor() {
        Executor executor = arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0);
        if (executor == null) {
            IntellijProfilerServices.$$$reportNull$$$0(1);
        }
        return executor;
    }

    @NotNull
    public Executor getPoolExecutor() {
        Executor executor = arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        if (executor == null) {
            IntellijProfilerServices.$$$reportNull$$$0(2);
        }
        return executor;
    }

    public Set<String> getAllProjectClasses() {
        Query query = AllClassesSearch.search((SearchScope)ProjectScope.getProjectScope((Project)this.myProject), (Project)this.myProject);
        HashSet<String> classNames = new HashSet<String>();
        query.forEach(aClass -> classNames.add(aClass.getQualifiedName()));
        return classNames;
    }

    public void saveFile(@NotNull File file, @NotNull Consumer<FileOutputStream> fileOutputStreamConsumer, @Nullable Runnable postRunnable) {
        File parentDir;
        if (file == null) {
            IntellijProfilerServices.$$$reportNull$$$0(3);
        }
        if (fileOutputStreamConsumer == null) {
            IntellijProfilerServices.$$$reportNull$$$0(4);
        }
        if (!(parentDir = file.getParentFile()).exists()) {
            parentDir.mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    IntellijProfilerServices.getLogger().error("Could not create new file at: " + file.getPath());
                    return;
                }
            }
            catch (IOException e) {
                IntellijProfilerServices.getLogger().error((Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fileOutputStreamConsumer.accept(fos);
        }
        catch (IOException e) {
            IntellijProfilerServices.getLogger().error((Throwable)e);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            virtualFile.refresh(true, false, postRunnable);
        }
    }

    @NotNull
    public String getApplicationId() {
        ArrayList<String> applicationIds = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModel androidModuleModel = AndroidModel.get(module);
            if (androidModuleModel == null) continue;
            applicationIds.add(androidModuleModel.getApplicationId());
        }
        String string = applicationIds.isEmpty() ? "" : (String)applicationIds.get(0);
        if (string == null) {
            IntellijProfilerServices.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public NativeFrameSymbolizer getNativeFrameSymbolizer() {
        NativeFrameSymbolizer nativeFrameSymbolizer = this.myNativeSymbolizer;
        if (nativeFrameSymbolizer == null) {
            IntellijProfilerServices.$$$reportNull$$$0(6);
        }
        return nativeFrameSymbolizer;
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        IntellijCodeNavigator intellijCodeNavigator = this.myCodeNavigator;
        if (intellijCodeNavigator == null) {
            IntellijProfilerServices.$$$reportNull$$$0(7);
        }
        return intellijCodeNavigator;
    }

    @NotNull
    public FeatureTracker getFeatureTracker() {
        StudioFeatureTracker studioFeatureTracker = this.myFeatureTracker;
        if (studioFeatureTracker == null) {
            IntellijProfilerServices.$$$reportNull$$$0(8);
        }
        return studioFeatureTracker;
    }

    public void enableAdvancedProfiling() {
        RunnerAndConfigurationSettings configurationSettings;
        AndroidRunConfigurationBase androidConfiguration = null;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && configurationSettings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            androidConfiguration = (AndroidRunConfigurationBase)configurationSettings.getConfiguration();
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(true);
        }
        EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(this.myProject);
        dialog2.show();
        if (androidConfiguration != null) {
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(false);
        }
    }

    @NotNull
    public FeatureConfig getFeatureConfig() {
        return new FeatureConfig(){

            public boolean isCpuApiTracingEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_API_TRACING.get();
            }

            public boolean isCpuCaptureStageEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_CAPTURE_STAGE.get();
            }

            public boolean isCpuNewRecordingWorkflowEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_NEW_RECORDING_WORKFLOW.get();
            }

            public boolean isEnergyProfilerEnabled() {
                return (Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get();
            }

            public boolean isJniReferenceTrackingEnabled() {
                return (Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get();
            }

            public boolean isLiveAllocationsEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get();
            }

            public boolean isLiveAllocationsSamplingEnabled() {
                return (Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get();
            }

            public boolean isMemorySnapshotEnabled() {
                return (Boolean)StudioFlags.PROFILER_MEMORY_SNAPSHOT.get();
            }

            public boolean isPerfettoEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_PERFETTO.get();
            }

            public boolean isPerformanceMonitoringEnabled() {
                return (Boolean)StudioFlags.PROFILER_PERFORMANCE_MONITORING.get();
            }

            public boolean isAuditsEnabled() {
                return (Boolean)StudioFlags.PROFILER_AUDITS.get();
            }

            public boolean isStartupCpuProfilingEnabled() {
                return (Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get();
            }

            public boolean isUnifiedPipelineEnabled() {
                return (Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get();
            }

            public boolean isCustomEventVisualizationEnabled() {
                return (Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get();
            }
        };
    }

    @NotNull
    public ProfilerPreferences getTemporaryProfilerPreferences() {
        TemporaryProfilerPreferences temporaryProfilerPreferences = this.myTemporaryPreferences;
        if (temporaryProfilerPreferences == null) {
            IntellijProfilerServices.$$$reportNull$$$0(9);
        }
        return temporaryProfilerPreferences;
    }

    @NotNull
    public ProfilerPreferences getPersistentProfilerPreferences() {
        IntellijProfilerPreferences intellijProfilerPreferences = this.myPersistentPreferences;
        if (intellijProfilerPreferences == null) {
            IntellijProfilerServices.$$$reportNull$$$0(10);
        }
        return intellijProfilerPreferences;
    }

    public void openYesNoDialog(String message2, String title, Runnable yesCallback, Runnable noCallback) {
        int dialogResult = Messages.showYesNoDialog((Project)this.myProject, (String)message2, (String)title, (Icon)Messages.getWarningIcon());
        (dialogResult == 0 ? yesCallback : noCallback).run();
    }

    public <T> T openListBoxChooserDialog(@NotNull String title, @Nullable String message2, @NotNull T[] options, @NotNull Function<T, String> listBoxPresentationAdapter) {
        if (title == null) {
            IntellijProfilerServices.$$$reportNull$$$0(11);
        }
        if (options == null) {
            IntellijProfilerServices.$$$reportNull$$$0(12);
        }
        if (listBoxPresentationAdapter == null) {
            IntellijProfilerServices.$$$reportNull$$$0(13);
        }
        Object[] selectedValue = new Object[1];
        Supplier<Object> dialog2 = () -> {
            ListBoxChooserDialog<Object> listBoxDialog = new ListBoxChooserDialog<Object>(title, message2, options, listBoxPresentationAdapter);
            listBoxDialog.show();
            return listBoxDialog.getExitCode() != 0 ? null : listBoxDialog.getSelectedValue();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            selectedValue[0] = dialog2.get();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                ApplicationManager.getApplication().invokeLater(() -> {
                    selectedValue[0] = dialog2.get();
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (T)selectedValue[0];
    }

    @NotNull
    public List<String> getNativeSymbolsDirectories() {
        String arch = this.myCodeNavigator.fetchCpuAbiArch();
        Map<String, Set<File>> archToDirectories = SymbolFilesLocatorKt.getArchToSymDirsMap(this.myProject);
        if (!archToDirectories.containsKey(arch)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                IntellijProfilerServices.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<String> list = archToDirectories.get(arch).stream().map(file -> file.getAbsolutePath()).collect(Collectors.toList());
        if (list == null) {
            IntellijProfilerServices.$$$reportNull$$$0(15);
        }
        return list;
    }

    public List<ProfilingConfiguration> getUserCpuProfilerConfigs() {
        CpuProfilerConfigsState configsState = CpuProfilerConfigsState.getInstance(this.myProject);
        CpuProfilingConfigService oldService = CpuProfilingConfigService.getInstance(this.myProject);
        oldService.getConfigurations().forEach(old2 -> configsState.addUserConfig(CpuProfilerConfigConverter.fromProto(old2.toProto())));
        oldService.setConfigurations(Collections.emptyList());
        return CpuProfilerConfigConverter.toProto(configsState.getUserConfigs()).stream().map(ProfilingConfiguration::fromProto).collect(Collectors.toList());
    }

    public List<ProfilingConfiguration> getDefaultCpuProfilerConfigs() {
        return CpuProfilerConfigConverter.toProto(CpuProfilerConfigsState.getDefaultConfigs()).stream().map(ProfilingConfiguration::fromProto).collect(Collectors.toList());
    }

    public boolean isNativeProfilingConfigurationPreferred() {
        ImmutableList nativeExtensions = ImmutableList.of((Object)"c", (Object)"cc", (Object)"cpp", (Object)"cxx", (Object)"c++", (Object)"h", (Object)"hh", (Object)"hpp", (Object)"hxx", (Object)"h++");
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).anyMatch(file -> {
            String extension = file.getExtension();
            return extension != null && nativeExtensions.contains((Object)StringUtil.toLowerCase((String)extension));
        });
    }

    public void showNotification(@NotNull Notification notification) {
        if (notification == null) {
            IntellijProfilerServices.$$$reportNull$$$0(16);
        }
        NotificationType type = null;
        switch (notification.getSeverity()) {
            case INFO: {
                type = NotificationType.INFORMATION;
                break;
            }
            case WARNING: {
                type = NotificationType.WARNING;
                break;
            }
            case ERROR: {
                type = NotificationType.ERROR;
            }
        }
        Notification.UrlData urlData = notification.getUrlData();
        if (urlData != null) {
            OpenUrlHyperlink hyperlink = new OpenUrlHyperlink(urlData.getUrl(), urlData.getText());
            AndroidNotification.getInstance(this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, false, hyperlink);
        } else {
            AndroidNotification.getInstance(this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, new NotificationHyperlink[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerServices";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOutputStreamConsumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listBoxPresentationAdapter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerServices";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoolExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeFrameSymbolizer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeNavigator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryProfilerPreferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentProfilerPreferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeSymbolsDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openListBoxChooserDialog";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

