/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static final String ID = "Android Profiler";
    private static final String PROFILER_TOOL_WINDOW_TITLE = "Profiler";
    private static final Map<Content, AndroidProfilerToolWindow> PROJECT_PROFILER_MAP = new HashMap<Content, AndroidProfilerToolWindow>();

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(1);
        }
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow window;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((window = toolWindowManager.getToolWindow(AndroidProfilerToolWindowFactory.ID)) == null) {
                    return;
                }
                AndroidProfilerToolWindow profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
                if (window.isVisible() && profilerToolWindow == null) {
                    AndroidProfilerToolWindowFactory.createContent(project, window);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/android/tools/idea/profilers/AndroidProfilerToolWindowFactory$1", "stateChanged"));
            }
        });
    }

    public void init(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(2);
        }
        toolWindow.setStripeTitle(PROFILER_TOOL_WINDOW_TITLE);
        toolWindow.setShowStripeButton(false);
        AndroidProfilerService.getInstance();
    }

    private static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(3);
        }
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(4);
        }
        AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(toolWindow, project);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent(view.getComponent(), "", false);
        Disposer.register((Disposable)project, (Disposable)view);
        toolWindow.getContentManager().addContent(content2);
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        PROJECT_PROFILER_MAP.put(content2, view);
        Disposer.register((Disposable)content2, () -> PROJECT_PROFILER_MAP.remove(content2));
        toolWindow.show(null);
    }

    @Nullable
    public static AndroidProfilerToolWindow getProfilerToolWindow(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(5);
        }
        if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow(ID)) == null) {
            return null;
        }
        ContentManager contentManager = window.getContentManager();
        if (contentManager.getContentCount() == 0) {
            return null;
        }
        return PROJECT_PROFILER_MAP.get(contentManager.getContent(0));
    }

    public static void removeContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(6);
        }
        if (toolWindow.getContentManager().getContentCount() > 0) {
            Content content2 = toolWindow.getContentManager().getContent(0);
            PROJECT_PROFILER_MAP.remove(content2);
            toolWindow.getContentManager().removeAllContents(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProfilerToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

