/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.Receiver;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListenerManager {
    private final List<ListenerPairing> myListeners;
    private final Map<Receiver<?>, InvalidationListener> myReceiverMapping;
    private final List<CompositeListener> myCompositeListeners;
    private final BatchInvoker myInvoker;

    public ListenerManager() {
        this.myListeners = new ArrayList<ListenerPairing>();
        this.myReceiverMapping = Maps.newHashMap();
        this.myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
        this.myInvoker = new BatchInvoker();
    }

    public ListenerManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        if (invokeStrategy == null) {
            ListenerManager.$$$reportNull$$$0(0);
        }
        this.myListeners = new ArrayList<ListenerPairing>();
        this.myReceiverMapping = Maps.newHashMap();
        this.myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public void listen(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener2) {
        if (src == null) {
            ListenerManager.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            ListenerManager.$$$reportNull$$$0(2);
        }
        this.myListeners.add(new ListenerPairing(src, listener2));
    }

    public <T> void listen(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver) {
        if (src == null) {
            ListenerManager.$$$reportNull$$$0(3);
        }
        if (receiver == null) {
            ListenerManager.$$$reportNull$$$0(4);
        }
        InvalidationListener listenerWrapper = () -> receiver.receive(src.get());
        this.myReceiverMapping.put(receiver, listenerWrapper);
        this.listen(src, listenerWrapper);
    }

    public void listenAndFire(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener2) {
        if (src == null) {
            ListenerManager.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            ListenerManager.$$$reportNull$$$0(6);
        }
        this.listen(src, listener2);
        listener2.onInvalidated();
    }

    public <T> void listenAndFire(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver) {
        if (src == null) {
            ListenerManager.$$$reportNull$$$0(7);
        }
        if (receiver == null) {
            ListenerManager.$$$reportNull$$$0(8);
        }
        this.listen(src, receiver);
        receiver.receive(src.get());
    }

    @NotNull
    public CompositeListener listenAll(ObservableValue<?> ... values) {
        if (values == null) {
            ListenerManager.$$$reportNull$$$0(9);
        }
        CompositeListener listener2 = new CompositeListener(values);
        this.myCompositeListeners.add(listener2);
        CompositeListener compositeListener = listener2;
        if (compositeListener == null) {
            ListenerManager.$$$reportNull$$$0(10);
        }
        return compositeListener;
    }

    @NotNull
    public CompositeListener listenAll(@NotNull Collection<? extends ObservableValue<?>> values) {
        if (values == null) {
            ListenerManager.$$$reportNull$$$0(11);
        }
        CompositeListener compositeListener = this.listenAll((ObservableValue[])Iterables.toArray(values, ObservableValue.class));
        if (compositeListener == null) {
            ListenerManager.$$$reportNull$$$0(12);
        }
        return compositeListener;
    }

    public void release(@NotNull InvalidationListener listener2) {
        if (listener2 == null) {
            ListenerManager.$$$reportNull$$$0(13);
        }
        Iterator<ListenerPairing> i2 = this.myListeners.iterator();
        while (i2.hasNext()) {
            ListenerPairing listenerPairing = i2.next();
            if (listenerPairing.myListener != listener2) continue;
            listenerPairing.dispose();
            i2.remove();
        }
    }

    public void release(@NotNull Receiver<?> receiver) {
        InvalidationListener listenerWrapper;
        if (receiver == null) {
            ListenerManager.$$$reportNull$$$0(14);
        }
        if ((listenerWrapper = this.myReceiverMapping.get(receiver)) == null) {
            return;
        }
        this.release(listenerWrapper);
    }

    public void release(@NotNull ObservableValue<?> observable2) {
        if (observable2 == null) {
            ListenerManager.$$$reportNull$$$0(15);
        }
        Iterator<ListenerPairing> i2 = this.myListeners.iterator();
        while (i2.hasNext()) {
            ListenerPairing listenerPairing = i2.next();
            if (listenerPairing.myObservable != observable2) continue;
            listenerPairing.dispose();
            i2.remove();
        }
    }

    public void release(@NotNull Runnable listenAllRunnable) {
        if (listenAllRunnable == null) {
            ListenerManager.$$$reportNull$$$0(16);
        }
        Iterator<CompositeListener> iterator = this.myCompositeListeners.iterator();
        while (iterator.hasNext()) {
            CompositeListener listener2 = iterator.next();
            if (!listener2.ownsRunnable(listenAllRunnable)) continue;
            listener2.dispose();
            iterator.remove();
        }
    }

    public void releaseAll() {
        for (ListenerPairing listenerPairing : this.myListeners) {
            listenerPairing.dispose();
        }
        this.myListeners.clear();
        for (CompositeListener compositeListener : this.myCompositeListeners) {
            compositeListener.dispose();
        }
        this.myCompositeListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeStrategy";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/observable/ListenerManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenAllRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/observable/ListenerManager";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "listenAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listen";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listenAndFire";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listenAll";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class CompositeListener
    implements InvalidationListener,
    Runnable {
        @NotNull
        private final ObservableValue<?>[] myValues;
        @Nullable
        private Runnable myOnAnyInvalidated;

        public CompositeListener(ObservableValue<?> ... values) {
            if (values == null) {
                CompositeListener.$$$reportNull$$$0(0);
            }
            for (ObservableValue<?> value2 : this.myValues = values) {
                value2.addListener(this);
            }
        }

        public void dispose() {
            for (ObservableValue<?> value2 : this.myValues) {
                value2.removeListener(this);
            }
        }

        public void with(@NotNull Runnable onAnyInvalidated) {
            if (onAnyInvalidated == null) {
                CompositeListener.$$$reportNull$$$0(1);
            }
            this.myOnAnyInvalidated = onAnyInvalidated;
        }

        public void withAndFire(@NotNull Runnable onAnyInvalidated) {
            if (onAnyInvalidated == null) {
                CompositeListener.$$$reportNull$$$0(2);
            }
            this.with(onAnyInvalidated);
            this.run();
        }

        boolean ownsRunnable(@NotNull Runnable onAnyInvalidated) {
            if (onAnyInvalidated == null) {
                CompositeListener.$$$reportNull$$$0(3);
            }
            return onAnyInvalidated.equals(this.myOnAnyInvalidated);
        }

        @Override
        public void onInvalidated() {
            ListenerManager.this.myInvoker.enqueue(this);
        }

        @Override
        public void run() {
            if (this.myOnAnyInvalidated != null) {
                this.myOnAnyInvalidated.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onAnyInvalidated";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/observable/ListenerManager$CompositeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "with";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withAndFire";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ownsRunnable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ListenerPairing {
        private final ObservableValue<?> myObservable;
        private final InvalidationListener myListener;

        public ListenerPairing(ObservableValue<?> src, InvalidationListener listener2) {
            this.myObservable = src;
            this.myListener = listener2;
            src.addListener(listener2);
        }

        public void dispose() {
            this.myObservable.removeListener(this.myListener);
        }
    }
}

