/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.npw.module.ModuleModelKt;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/npw/validator/ModuleValidator;", "Lcom/android/tools/adtui/validation/Validator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectPath", "Lcom/android/tools/idea/observable/core/StringProperty;", "(Lcom/android/tools/idea/observable/core/StringProperty;)V", "ILLEGAL_CHAR_MATCHER", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "pathValidator", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "name", "intellij.android.core"})
public final class ModuleValidator
implements Validator<String> {
    private Project project;
    private final PathValidator pathValidator;
    private final CharMatcher ILLEGAL_CHAR_MATCHER;
    private final StringProperty projectPath;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Validator.Result validate(@NotNull String name) {
        Validator.Result result2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int illegalCharIdx = this.ILLEGAL_CHAR_MATCHER.indexIn((CharSequence)name);
        CharSequence charSequence = name;
        boolean bl = false;
        if (charSequence.length() == 0) {
            String string = AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026idate.empty.module.name\")");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
            return result2;
        }
        if (this.project != null) {
            Project project = this.project;
            Intrinsics.checkNotNull((Object)project);
            if (ModuleManager.getInstance((Project)project).findModuleByName(name) != null) {
                String string = AndroidBundle.message("android.wizard.validate.module.already.exists", name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026le.already.exists\", name)");
                result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
                return result2;
            }
        }
        if (illegalCharIdx >= 0) {
            String string = AndroidBundle.message("android.wizard.validate.module.illegal.character", Character.valueOf(name.charAt(illegalCharIdx)), name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026me[illegalCharIdx], name)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
            return result2;
        }
        Object t = this.projectPath.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"projectPath.get()");
        result2 = this.pathValidator.validate(ModuleModelKt.getModuleRoot((String)t, name));
        return result2;
    }

    public ModuleValidator(@NotNull StringProperty projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
        this.pathValidator = PathValidator.Companion.createDefault("module location");
        this.ILLEGAL_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-: ")).negate();
    }

    public ModuleValidator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        this(new StringValueProperty(string));
        this.project = project;
    }
}

