/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.AndroidVersionsInfoKt;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.ui.TemplateIcon;
import com.android.tools.idea.npw.validator.ProjectNameValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.template.Template;
import com.android.tools.idea.wizard.template.TemplateConstraint;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModuleModel> {
    private final NewProjectModel myProjectModel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JTextField myPackageName;
    private JComboBox<Language> myProjectLanguage;
    private JBCheckBox myAppCompatCheck;
    private JBCheckBox myWearCheck;
    private JBCheckBox myTvCheck;
    private JBLabel myAppCompatHelp;
    private JBLabel myTemplateIconTitle;
    private JBLabel myTemplateIconDetail;
    private JPanel myFormFactorSdkControlsPanel;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureAndroidProjectStep(@NotNull NewProjectModuleModel newProjectModuleModel, @NotNull NewProjectModel projectModel) {
        if (newProjectModuleModel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(0);
        }
        if (projectModel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(1);
        }
        super(newProjectModuleModel, AndroidBundle.message("android.wizard.project.new.configure", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myProjectModel = projectModel;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)StudioWizardStepPanel.wrappedWithVScroll(this.myPanel));
        this.myAppCompatHelp.setIcon(AllIcons.General.ContextHelp);
        HelpTooltip helpTooltip = new HelpTooltip().setDescription(AndroidBundle.message("android.wizard.project.help.appcompat", new Object[0]));
        helpTooltip.installOn((JComponent)this.myAppCompatCheck);
        helpTooltip.installOn((JComponent)this.myAppCompatHelp);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        LicenseAgreementStep licenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfoKt.getSdkManagerLocalPath()), this.myInstallLicenseRequests);
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false);
        ArrayList arrayList = Lists.newArrayList((Object[])new ModelWizardStep[]{licenseAgreementStep, installPackagesStep});
        if (arrayList == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(3);
        }
        ((GridLayoutManager)this.myPanel.getLayout()).setVGap(2);
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), this.myProjectModel.getApplicationName());
        String basePackage = NewProjectModel.getSuggestedProjectPackage();
        Expression<String> computedPackageName = this.myProjectModel.getApplicationName().transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.nameToJavaPackage(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(this.myProjectModel.getPackageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        Expression<String> computedLocation = this.myProjectModel.getApplicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty(this.myProjectLocation.getTextField());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(this.myProjectModel.getProjectLocation(), locationText);
        this.myListeners.listen(locationText, value2 -> isLocationSynced.set(value2.equals(computedLocation.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((NewProjectModuleModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myProjectLanguage), this.myProjectModel.getLanguage());
        this.myBindings.bindTwoWay(this.myProjectModel.getUseAppCompat(), new SelectedProperty((AbstractButton)this.myAppCompatCheck));
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getApplicationName(), (Validator)new ProjectNameValidator(), new ObservableValue[0]);
        Expression<File> locationFile = this.myProjectModel.getProjectLocation().transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, (Validator)PathValidator.createDefault("project location"), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getPackageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getLanguage(), value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.select.language", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerTest((ObservableValue)this.myProjectModel.getUseAppCompat().not(), Validator.Severity.WARNING, AndroidBundle.message("android.wizard.validate.select.appcompat", new Object[0]));
        this.myProjectLocation.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myListeners.listenAll(((NewProjectModuleModel)this.getModel()).formFactor, this.myProjectModel.getEnableCppSupport()).withAndFire(() -> {
            FormFactor formFactor = ((NewProjectModuleModel)this.getModel()).formFactor.get();
            this.myFormFactorSdkControls.showStatsPanel(formFactor == FormFactor.MOBILE);
            this.myWearCheck.setVisible(formFactor == FormFactor.WEAR);
            this.myTvCheck.setVisible(formFactor == FormFactor.TV);
        });
        this.myListeners.listenAndFire(androidSdkInfo, () -> this.updateAppCompatCheckBox());
        this.myListeners.listenAndFire(androidSdkInfo, sender -> this.updateAppCompatCheckBox());
    }

    @Override
    protected void onEntering() {
        boolean isKotlinOnly;
        FormFactor formFactor = ((NewProjectModuleModel)this.getModel()).formFactor.get();
        TemplateHandle templateHandle = (TemplateHandle)((NewProjectModuleModel)this.getModel()).renderTemplateHandle.getValueOrNull();
        Template newTemplate = (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValueOrNull();
        assert (templateHandle == null || newTemplate == null);
        int minSdk = templateHandle == null ? (newTemplate == null ? formFactor.getMinOfflineApiLevel() : newTemplate.getMinSdk()) : templateHandle.getMetadata().getMinSdk();
        this.myFormFactorSdkControls.startDataLoading(formFactor, minSdk);
        if (newTemplate != null) {
            this.setTemplateThumbnail(newTemplate);
            isKotlinOnly = newTemplate.getConstraints().contains(TemplateConstraint.Kotlin);
        } else {
            this.setTemplateThumbnail(templateHandle);
            isKotlinOnly = templateHandle != null && templateHandle.getMetadata().getConstraints().contains((Object)TemplateMetadata.TemplateConstraint.KOTLIN);
        }
        this.myProjectLanguage.setEnabled(!isKotlinOnly);
        if (isKotlinOnly) {
            this.myProjectModel.getLanguage().setValue(Language.KOTLIN);
        }
        this.updateAppCompatCheckBox();
    }

    @Override
    protected void onProceeding() {
        ((NewProjectModuleModel)this.getModel()).hasCompanionApp.set(this.myWearCheck.isVisible() && this.myWearCheck.isSelected() || this.myTvCheck.isVisible() && this.myTvCheck.isSelected() || ((NewProjectModuleModel)this.getModel()).formFactor.get() == FormFactor.AUTOMOTIVE);
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        this.myInstallRequests.addAll(this.myFormFactorSdkControls.getSdkInstallPackageList());
        this.myInstallLicenseRequests.addAll(ContainerUtil.map(this.myInstallRequests, UpdatablePackage::getRemote));
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(4);
        }
        return validatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(5);
        }
        return observableBool;
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        if (applicationName == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(6);
        }
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format(Locale.US, "%s%d", applicationName, counter++));
        }
        String string = projectDirectory.getPath();
        if (string == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void setTemplateThumbnail(@Nullable TemplateHandle templateHandle) {
        this.setTemplateThumbnail(ActivityGallery.getTemplateIcon(templateHandle), ActivityGallery.getTemplateImageLabel(templateHandle), ActivityGallery.getTemplateDescription(templateHandle));
    }

    private void setTemplateThumbnail(@NotNull Template template) {
        if (template == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(8);
        }
        this.setTemplateThumbnail(ActivityGallery.getTemplateIcon(template), template.getName(), template.getDescription());
    }

    private void setTemplateThumbnail(@Nullable TemplateIcon defaultIcon, @NotNull String name, @NotNull String description) {
        boolean isCppTemplate;
        TemplateIcon icon2;
        if (name == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(9);
        }
        if (description == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(10);
        }
        TemplateIcon templateIcon = icon2 = (isCppTemplate = this.myProjectModel.getEnableCppSupport().get().booleanValue()) ? ActivityGallery.getCppIcon() : defaultIcon;
        if (icon2 != null) {
            icon2.cropBlankWidth();
            icon2.setHeight(256);
            this.myTemplateIconTitle.setIcon((Icon)((Object)icon2));
            this.myTemplateIconTitle.setText(isCppTemplate ? AndroidBundle.message("android.wizard.gallery.item.add.cpp", new Object[0]) : name);
            this.myTemplateIconDetail.setText("<html>" + (isCppTemplate ? AndroidBundle.message("android.wizard.gallery.item.add.cpp.Desc", new Object[0]) : description) + "</html>");
        }
        this.myTemplateIconTitle.setVisible(icon2 != null);
        this.myTemplateIconDetail.setVisible(icon2 != null);
    }

    private void updateAppCompatCheckBox() {
        boolean hasAndroidxConstraint;
        AndroidVersionsInfo.VersionItem androidVersion = ((NewProjectModuleModel)this.getModel()).androidSdkInfo().getValueOrNull();
        boolean isAndroidxApi = androidVersion != null && androidVersion.getMinApiLevel() >= 29;
        TemplateHandle templateHandle = (TemplateHandle)((NewProjectModuleModel)this.getModel()).renderTemplateHandle.getValueOrNull();
        Template newTemplate = (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValueOrNull();
        assert (templateHandle == null || newTemplate == null);
        if (newTemplate != null) {
            hasAndroidxConstraint = newTemplate.getConstraints().contains(TemplateConstraint.AndroidX);
        } else {
            boolean bl = hasAndroidxConstraint = templateHandle != null && templateHandle.getMetadata().getConstraints().contains((Object)TemplateMetadata.TemplateConstraint.ANDROIDX);
        }
        if (isAndroidxApi || hasAndroidxConstraint) {
            this.myAppCompatCheck.setSelected(false);
            this.myAppCompatCheck.setEnabled(false);
        } else {
            this.myAppCompatCheck.setEnabled(true);
        }
    }

    private void createUIComponents() {
        this.myProjectLanguage = new LanguageComboProvider().createComponent();
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectModuleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProjectLocation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateThumbnail";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox3;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(18, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 0, -1, jBLabel4.getFont());
        if (font != null) {
            jBLabel4.setFont(font);
        }
        jBLabel4.setText("Name");
        jBLabel4.setDisplayedMnemonic('N');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jBLabel4.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        JBLabel jBLabel5 = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, 0, -1, jBLabel5.getFont());
        if (font2 != null) {
            jBLabel5.setFont(font2);
        }
        jBLabel5.setText("Package name");
        jBLabel5.setDisplayedMnemonic('P');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jBLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel5, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, 0, -1, jBLabel6.getFont());
        if (font3 != null) {
            jBLabel6.setFont(font3);
        }
        jBLabel6.setText("Language");
        jBLabel6.setDisplayedMnemonic('L');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jBLabel6.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel6, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel7 = new JBLabel();
        Font font4 = this.$$$getFont$$$(null, 0, -1, jBLabel7.getFont());
        if (font4 != null) {
            jBLabel7.setFont(font4);
        }
        jBLabel7.setText("Save location");
        jBLabel7.setDisplayedMnemonic('S');
        jBLabel7.setDisplayedMnemonicIndex(0);
        jBLabel7.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel7, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComboBox<Language> jComboBox = this.myProjectLanguage;
        jPanel.add(jComboBox, new GridConstraints(10, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 17, 1, 0, 3, 3, 3, null, new Dimension(250, -1), new Dimension(250, -1)));
        this.myTemplateIconTitle = jBLabel3 = new JBLabel();
        Font font5 = this.$$$getFont$$$(null, -1, 14, jBLabel3.getFont());
        if (font5 != null) {
            jBLabel3.setFont(font5);
        }
        jBLabel3.setHorizontalAlignment(0);
        jBLabel3.setHorizontalTextPosition(0);
        jBLabel3.setText("Template Label");
        jBLabel3.setVerticalTextPosition(3);
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 6, 6, null, null, null));
        this.myTemplateIconDetail = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        Font font6 = this.$$$getFont$$$(null, -1, 11, jBLabel2.getFont());
        if (font6 != null) {
            jBLabel2.setFont(font6);
        }
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setHorizontalAlignment(0);
        jBLabel2.setHorizontalTextPosition(0);
        jBLabel2.setText("Detail");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 1, 1, 7, 7, null, null, null));
        JPanel jPanel3 = this.myFormFactorSdkControlsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(13, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add((Component)jPanel4, new GridConstraints(14, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myAppCompatCheck = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setMargin(new Insets(2, 2, 2, 2));
        jBCheckBox3.setText("Use legacy android.support libraries");
        Component component3 = jPanel4.add((Component)jBCheckBox3);
        this.myAppCompatHelp = jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(2);
        jBLabel.setText(" ");
        jBLabel.setToolTipText(" ");
        Component component4 = jPanel4.add((Component)jBLabel);
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(17, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myWearCheck = jBCheckBox2 = new JBCheckBox();
        Font font7 = this.$$$getFont$$$(null, 0, -1, jBCheckBox2.getFont());
        if (font7 != null) {
            jBCheckBox2.setFont(font7);
        }
        jBCheckBox2.setLabel("Pair with Empty Phone app");
        jBCheckBox2.setText("Pair with Empty Phone app");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(15, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTvCheck = jBCheckBox = new JBCheckBox();
        Font font8 = this.$$$getFont$$$(null, 0, -1, jBCheckBox.getFont());
        if (font8 != null) {
            jBCheckBox.setFont(font8);
        }
        jBCheckBox.setLabel("Pair with companion Phone app");
        jBCheckBox.setText("Pair with companion Phone app");
        jPanel.add((Component)jBCheckBox, new GridConstraints(16, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(11, 1, 1, 1, 1, 1, 0, 1, null, new Dimension(-1, 15), null));
        jBLabel4.setLabelFor(jTextField2);
        jBLabel5.setLabelFor(jTextField);
        jBLabel6.setLabelFor(jComboBox);
        jBLabel7.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel.setLabelFor((Component)jBCheckBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

