/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.Iterables;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a,\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0017\u0010\u000b\u001a\u00020\u0001*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0080\u0010\u00a8\u0006\u000e"}, d2={"atMostTwo", "", "names", "", "size", "", "formatElementListString", "values", "oneElementMessage", "twoOrThreeElementsMessage", "moreThenThreeElementsMessage", "relativeTo", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseFile", "intellij.android.core"})
@JvmName(name="ImportUIUtil")
public final class ImportUIUtil {
    @NotNull
    public static final String formatElementListString(@NotNull Iterable<String> values, @NotNull String oneElementMessage, @NotNull String twoOrThreeElementsMessage, @NotNull String moreThenThreeElementsMessage) {
        String string;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)oneElementMessage, (String)"oneElementMessage");
        Intrinsics.checkNotNullParameter((Object)twoOrThreeElementsMessage, (String)"twoOrThreeElementsMessage");
        Intrinsics.checkNotNullParameter((Object)moreThenThreeElementsMessage, (String)"moreThenThreeElementsMessage");
        int size = Iterables.size(values);
        if (size == 0) {
            string = "<validation error>";
        } else if (size == 1) {
            String string2 = oneElementMessage;
            Object[] objectArray = new Object[]{CollectionsKt.first(values)};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        } else if (size <= 3) {
            String string4 = twoOrThreeElementsMessage;
            Object[] objectArray = new Object[]{ImportUIUtil.atMostTwo(values, size), CollectionsKt.last(values)};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
        } else {
            String string6 = moreThenThreeElementsMessage;
            Object[] objectArray = new Object[]{ImportUIUtil.atMostTwo(values, size), size - 2};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(this, *args)");
        }
        return string;
    }

    private static final String atMostTwo(Iterable<String> names, int size) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.take(names, (int)RangesKt.coerceAtMost((int)(size - 1), (int)2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String relativeTo(@NotNull VirtualFile $this$relativeTo, @Nullable VirtualFile baseFile) {
        String string;
        block4: {
            while (true) {
                Intrinsics.checkNotNullParameter((Object)$this$relativeTo, (String)"$this$relativeTo");
                if (baseFile == null) {
                    String string2 = $this$relativeTo.getPath();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
                    break block4;
                }
                if (baseFile.isDirectory()) break;
                baseFile = baseFile.getParent();
            }
            if (Intrinsics.areEqual((Object)$this$relativeTo.getFileSystem(), (Object)baseFile.getFileSystem())) {
                String string3 = FilesKt.relativeTo((File)FileExtensions.toIoFile($this$relativeTo), (File)FileExtensions.toIoFile(baseFile)).getPath();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toIoFile().relativeTo(baseFile.toIoFile()).path");
            } else {
                String string4 = $this$relativeTo.getPath();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
            }
        }
        return string;
    }
}

