/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ArchiveToGradleModuleStep
extends SkippableWizardStep<ArchiveToGradleModuleModel> {
    private static final Set<String> SUPPORTED_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"aar");
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private JTextField myGradlePath;
    private TextFieldWithBrowseButton myArchivePath;
    private JCheckBox myRemoveOriginalFileCheckBox;

    public ArchiveToGradleModuleStep(@NotNull ArchiveToGradleModuleModel model2) {
        if (model2 == null) {
            ArchiveToGradleModuleStep.$$$reportNull$$$0(0);
        }
        super(model2, AndroidBundle.message("android.wizard.module.import.library.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myArchivePath.addBrowseFolderListener(AndroidBundle.message("android.wizard.module.import.library.browse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.library.browse.description", new Object[0]), model2.getProject(), new FileChooserDescriptor(true, false, true, true, false, false).withFileFilter(ArchiveToGradleModuleStep::isValidExtension));
        this.myBindings.bindTwoWay(new TextProperty(this.myArchivePath.getTextField()), model2.archive);
        this.myBindings.bindTwoWay(new TextProperty(this.myGradlePath), model2.gradlePath);
        this.myListeners.listenAndFire(model2.archive, archivePath -> model2.gradlePath.set(Files.getNameWithoutExtension((String)archivePath)));
        SelectedProperty removeOriginal = new SelectedProperty(this.myRemoveOriginalFileCheckBox);
        this.myBindings.bind(model2.moveArchive, removeOriginal.and(model2.inModule()));
        this.myBindings.bind(removeOriginal, model2.moveArchive);
        this.myBindings.bind(new VisibleProperty(this.myRemoveOriginalFileCheckBox), model2.inModule());
    }

    static boolean isValidExtension(VirtualFile file) {
        String extension = file.getExtension();
        return extension != null && SUPPORTED_EXTENSIONS.contains(StringUtil.toLowerCase((String)extension));
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ArchiveToGradleModuleStep.$$$reportNull$$$0(1);
        }
        ArchiveToGradleModuleModel model2 = (ArchiveToGradleModuleModel)this.getModel();
        this.myValidatorPanel.registerValidator((ObservableValue)model2.archive, (Validator)new ArchiveValidator(), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.gradlePath, (Validator)new GradleValidator(model2.getProject()), new ObservableValue[0]);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ArchiveToGradleModuleStep.$$$reportNull$$$0(2);
        }
        return validatorPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        JTextField jTextField = this.myArchivePath.getTextField();
        if (jTextField == null) {
            ArchiveToGradleModuleStep.$$$reportNull$$$0(3);
        }
        return jTextField;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ArchiveToGradleModuleStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(96, 16, 0, 0), -1, -1, false, false));
        this.myArchivePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGradlePath = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("File name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Subproject name:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveOriginalFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Remove original file");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    @VisibleForTesting
    static final class GradleValidator
    implements Validator<String> {
        private Project myProject;

        GradleValidator(@NotNull Project project) {
            if (project == null) {
                GradleValidator.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        public Validator.Result validate(@NotNull String gradlePath) {
            if (gradlePath == null) {
                GradleValidator.$$$reportNull$$$0(1);
            }
            if (Strings.isNullOrEmpty((String)gradlePath)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.name", new Object[0]));
            }
            int invalidCharIndex = GradleUtil.isValidGradlePath(gradlePath);
            if (invalidCharIndex >= 0) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.name", Character.valueOf(gradlePath.charAt(invalidCharIndex))));
            }
            if (GradleUtil.hasModule(this.myProject, gradlePath)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.taken.name", gradlePath));
            }
            Validator.Result result2 = Validator.Result.OK;
            if (result2 == null) {
                GradleValidator.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradlePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    static final class ArchiveValidator
    implements Validator<String> {
        ArchiveValidator() {
        }

        @NotNull
        public Validator.Result validate(@NotNull String archive) {
            if (archive == null) {
                ArchiveValidator.$$$reportNull$$$0(0);
            }
            if (Strings.isNullOrEmpty((String)archive)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.path", new Object[0]));
            }
            File archiveFile = new File(archive);
            if (!archiveFile.isFile()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.path", new Object[0]));
            }
            VirtualFile archiveVirtualFile = VfsUtil.findFileByIoFile((File)archiveFile, (boolean)true);
            if (!ArchiveToGradleModuleStep.isValidExtension(archiveVirtualFile)) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.extension", new Object[0]));
            }
            Validator.Result result2 = Validator.Result.OK;
            if (result2 == null) {
                ArchiveValidator.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "archive";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

