/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SwingWorker;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconGenerationProcessor {
    @Nullable
    private Request myQueuedRequest;
    @Nullable
    private Request myRunningRequest;

    public void enqueue(@NotNull IconGenerator iconGenerator, @NotNull Consumer<IconGeneratorResult> onDone) {
        if (iconGenerator == null) {
            IconGenerationProcessor.$$$reportNull$$$0(0);
        }
        if (onDone == null) {
            IconGenerationProcessor.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (((Optional)iconGenerator.sourceAsset().get()).isPresent()) {
            IconGenerator.IconOptions options = iconGenerator.createOptions(true);
            this.myQueuedRequest = new Request(iconGenerator, options, onDone);
        }
        this.processNextRequest();
    }

    private void processNextRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQueuedRequest == null) {
            return;
        }
        if (this.myRunningRequest != null) {
            this.myRunningRequest.cancel();
        }
        this.myRunningRequest = this.myQueuedRequest;
        this.myQueuedRequest = null;
        Request request = this.myRunningRequest;
        if (request != null) {
            Worker worker = new Worker(request, () -> {
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.myRunningRequest = null;
                this.processNextRequest();
            });
            worker.start();
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(IconGenerationProcessor.class);
        if (logger2 == null) {
            IconGenerationProcessor.$$$reportNull$$$0(2);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Worker
    extends SwingWorker<Request> {
        @NotNull
        private final Request myRequest;
        @NotNull
        private final Runnable myOnDone;

        Worker(@NotNull Request request, @NotNull Runnable onDone) {
            if (request == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (onDone == null) {
                Worker.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.myOnDone = onDone;
        }

        @NotNull
        public Request construct() {
            long start = System.currentTimeMillis();
            this.myRequest.run();
            long end = System.currentTimeMillis();
            IconGenerationProcessor.getLog().info(String.format(Locale.US, "Icons generated in %.2g sec", (double)(end - start) / 1000.0));
            Request request = this.myRequest;
            if (request == null) {
                Worker.$$$reportNull$$$0(2);
            }
            return request;
        }

        public void finished() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                this.myRequest.done();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(this.myOnDone, ModalityState.any());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDone";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Worker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Worker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "construct";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Request {
        @NotNull
        private final IconGenerator myIconGenerator;
        @NotNull
        private final Consumer<IconGeneratorResult> myOnDone;
        @NotNull
        private final IconGenerator.IconOptions myOptions;
        @Nullable
        private IconGeneratorResult myGeneratorResult;
        private boolean isCanceled;

        Request(@NotNull IconGenerator iconGenerator, @NotNull IconGenerator.IconOptions options, @NotNull Consumer<IconGeneratorResult> onDone) {
            if (iconGenerator == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (options == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (onDone == null) {
                Request.$$$reportNull$$$0(2);
            }
            this.myIconGenerator = iconGenerator;
            this.myOptions = options;
            this.myOnDone = onDone;
        }

        public void run() {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            this.myGeneratorResult = this.myIconGenerator.generateIcons(this.myOptions);
        }

        public void done() {
            if (!this.isCanceled) {
                this.myOnDone.accept(this.myGeneratorResult);
            }
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iconGenerator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "onDone";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/wizard/IconGenerationProcessor$Request";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

