/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorTextRenderer;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAsset
extends BaseAsset {
    private static final String TEXT_PROPERTY = "text";
    private static final String FONT_FAMILY_PROPERTY = "fontFamily";
    private static final String DEFAULT_TEXT = "Aa";
    private static final String PREFERRED_FONT_FAMILY = "Roboto";
    private static final int FONT_SIZE = 144;
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final List<String> myAllFontFamilies;
    @NotNull
    private String myDefaultText = "Aa";
    @NotNull
    private String myDefaultFontFamily;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;

    public TextAsset() {
        this.myAllFontFamilies = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.myDefaultFontFamily = this.normalizeFontFamily(PREFERRED_FONT_FAMILY);
        if (!this.myDefaultFontFamily.isEmpty()) {
            this.myFontFamily.set(this.myDefaultFontFamily);
        }
        InvalidationListener listener2 = () -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myXmlDrawableFuture = null;
            }
        };
        this.myText.addListener(listener2);
        this.myFontFamily.addListener(listener2);
        this.color().setValue(Color.BLACK);
        this.color().addListener(listener2);
    }

    @UiThread
    public void setDefaultText(@NotNull String text) {
        if (text == null) {
            TextAsset.$$$reportNull$$$0(0);
        }
        boolean wasDefault = ((String)this.myText.get()).equals(this.myDefaultText);
        this.myDefaultText = text;
        if (wasDefault) {
            this.myText.set(this.myDefaultText);
        }
    }

    @UiThread
    public void setDefaultFontFamily(@NotNull String fontFamily) {
        if (fontFamily == null) {
            TextAsset.$$$reportNull$$$0(1);
        }
        boolean wasDefault = ((String)this.myFontFamily.get()).equals(this.myDefaultFontFamily);
        this.myDefaultFontFamily = this.normalizeFontFamily(fontFamily);
        if (wasDefault) {
            this.selectFontFamily(this.myDefaultFontFamily);
        }
    }

    private void selectFontFamily(@NotNull String fontFamily) {
        String family;
        if (fontFamily == null) {
            TextAsset.$$$reportNull$$$0(2);
        }
        if (!(family = this.normalizeFontFamily(fontFamily)).isEmpty()) {
            this.myFontFamily.set(family);
        }
    }

    @NotNull
    private String normalizeFontFamily(@NotNull String fontFamily) {
        if (fontFamily == null) {
            TextAsset.$$$reportNull$$$0(3);
        }
        String string = this.myAllFontFamilies.contains(fontFamily) ? fontFamily : (this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0));
        if (string == null) {
            TextAsset.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        ImmutableList immutableList = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if (immutableList == null) {
            TextAsset.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @NotNull
    public StringProperty text() {
        StringProperty stringProperty = this.myText;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty fontFamily() {
        StringProperty stringProperty = this.myFontFamily;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    @NotNull
    public String defaultFontFamily() {
        if (this.myAllFontFamilies.contains(PREFERRED_FONT_FAMILY)) {
            return PREFERRED_FONT_FAMILY;
        }
        String string = this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0);
        if (string == null) {
            TextAsset.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @AnyThread
    @NotNull
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myXmlDrawableFuture == null) {
            String text = (String)this.myText.get();
            String fontFamily = (String)this.myFontFamily.get();
            Color color = (Color)this.color().getValueOrNull();
            int opacityPercent = (Integer)this.opacityPercent().get();
            this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> VectorTextRenderer.renderToVectorDrawable(text, fontFamily, 144, color, (double)opacityPercent / 100.0));
        }
        ListenableFuture<String> listenableFuture = this.myXmlDrawableFuture;
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        TextAsset.$$$reportNull$$$0(9);
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<BufferedImage> toImage() {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " 144");
        options.foregroundColor = this.color().getValueOr(Color.BLACK).getRGB();
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)TextRenderUtil.renderTextImage((String)this.myText.get(), 1, options));
        if (listenableFuture == null) {
            TextAsset.$$$reportNull$$$0(10);
        }
        return listenableFuture;
    }

    @Override
    @UiThread
    public PersistentState getState() {
        PersistentState state = super.getState();
        state.set(TEXT_PROPERTY, (String)this.myText.get(), this.myDefaultText);
        state.set(FONT_FAMILY_PROPERTY, (String)this.myFontFamily.get(), this.myDefaultFontFamily);
        return state;
    }

    @Override
    @UiThread
    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            TextAsset.$$$reportNull$$$0(11);
        }
        super.loadState(state);
        String text = state.get(TEXT_PROPERTY, this.myDefaultText);
        if (!text.isEmpty()) {
            this.myText.set(text);
        }
        String fontFamily = state.get(FONT_FAMILY_PROPERTY, this.myDefaultFontFamily);
        this.selectFontFamily(fontFamily);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEXT_PROPERTY;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = FONT_FAMILY_PROPERTY;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFontFamily";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFontFamilies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = TEXT_PROPERTY;
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = FONT_FAMILY_PROPERTY;
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFontFamily";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlDrawable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultFontFamily";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectFontFamily";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFontFamily";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

