/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.Slow;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredImageConverter {
    private DecimalFormat myFormat;
    private final DecimalFormat myMiterFormat = new DecimalFormat("#.####");
    private final DecimalFormat myOpacityFormat = new DecimalFormat("#.##");

    LayeredImageConverter() {
    }

    @Slow
    @NotNull
    String toVectorDrawableXml(@NotNull File path2) throws IOException {
        if (path2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(0);
        }
        FileInputStream in = new FileInputStream(path2);
        Image image = PixelProbe.probe((InputStream)in, (Decoder.Options)new Decoder.Options().decodeLayerImageData(false).decodeLayerTextData(false).decodeLayerAdjustmentData(false).decodeGuides(false));
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
        this.myFormat = LayeredImageConverter.createDecimalFormat((float)bounds.getWidth(), (float)bounds.getHeight());
        Element vector = new Element("vector");
        this.extractPathLayers(vector, image.getLayers());
        vector.attribute("width", String.valueOf((int)bounds.getWidth()) + "dp").attribute("height", String.valueOf((int)bounds.getHeight()) + "dp").attribute("viewportWidth", String.valueOf((int)bounds.getWidth())).attribute("viewportHeight", String.valueOf((int)bounds.getHeight()));
        String xml = LayeredImageConverter.toVectorDrawable(vector);
        in.close();
        String string = xml;
        if (string == null) {
            LayeredImageConverter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void extractPathLayers(@NotNull Element root2, @NotNull List<Layer> layers) {
        if (root2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(2);
        }
        if (layers == null) {
            LayeredImageConverter.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < layers.size(); ++i2) {
            Layer layer = layers.get(i2);
            if (!layer.isVisible()) continue;
            Layer.Type type = layer.getType();
            if (type == Layer.Type.SHAPE) {
                Shape path2;
                if (layer.getShapeInfo().getStyle() == ShapeInfo.Style.NONE || (path2 = LayeredImageConverter.getTransformedPath(layer)).getBounds2D().isEmpty()) continue;
                Area clipPath = null;
                float opacityModifier = 1.0f;
                boolean fullyClipped = false;
                if (!layer.isClipBase()) {
                    for (int j = i2 + 1; j < layers.size(); ++j) {
                        Layer clipBase = layers.get(j);
                        if (!clipBase.isClipBase()) continue;
                        if (!clipBase.isVisible()) {
                            fullyClipped = true;
                            break;
                        }
                        if (clipBase.getType() != Layer.Type.SHAPE) break;
                        opacityModifier = clipBase.getOpacity();
                        Area source = new Area(path2);
                        clipPath = new Area(LayeredImageConverter.getTransformedPath(clipBase));
                        source.intersect(clipPath);
                        path2 = source;
                        break;
                    }
                }
                if (fullyClipped) continue;
                Element element = new Element("path");
                boolean hasFillOrStroke = this.extractFill(layer, element, opacityModifier);
                if (!(hasFillOrStroke |= this.extractStroke(layer, path2, clipPath, root2, element, opacityModifier))) continue;
                element.attribute("name", StringUtil.escapeXml((String)layer.getName()));
                element.attribute("pathData", LayeredImageConverter.toPathData(path2, this.myFormat));
                root2.childAtFront(element);
                continue;
            }
            if (type != Layer.Type.GROUP) continue;
            this.extractPathLayers(root2, layer.getChildren());
        }
    }

    @NotNull
    private static Shape getTransformedPath(Layer layer) {
        Area area;
        List paths = layer.getShapeInfo().getPaths();
        if (paths.isEmpty()) {
            return new Path2D.Float();
        }
        Rectangle2D layerBounds = layer.getBounds();
        AffineTransform transform = AffineTransform.getTranslateInstance(layerBounds.getX(), layerBounds.getY());
        ShapeInfo.Path shapePath = (ShapeInfo.Path)paths.get(0);
        if (shapePath.getOp() == ShapeInfo.PathOp.SUBTRACT) {
            area = new Area(new Rectangle2D.Double(0.0, 0.0, layerBounds.getWidth(), layerBounds.getHeight()));
            area.subtract(new Area(shapePath.getPath()));
        } else {
            Path2D path2 = shapePath.getPath();
            if (paths.size() == 1) {
                path2.transform(transform);
                Path2D path2D = path2;
                if (path2D == null) {
                    LayeredImageConverter.$$$reportNull$$$0(4);
                }
                return path2D;
            }
            area = new Area(path2);
        }
        block6: for (int i2 = 1; i2 < paths.size(); ++i2) {
            shapePath = (ShapeInfo.Path)paths.get(i2);
            switch (shapePath.getOp()) {
                case ADD: {
                    area.add(new Area(shapePath.getPath()));
                    continue block6;
                }
                case SUBTRACT: {
                    area.subtract(new Area(shapePath.getPath()));
                    continue block6;
                }
                case INTERSECT: {
                    area.intersect(new Area(shapePath.getPath()));
                    continue block6;
                }
                case EXCLUSIVE_OR: {
                    area.exclusiveOr(new Area(shapePath.getPath()));
                }
            }
        }
        area.transform(transform);
        Area area2 = area;
        if (area2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(5);
        }
        return area2;
    }

    private boolean extractStroke(@NotNull Layer layer, @NotNull Shape path2, @Nullable Area clipPath, @NotNull Element root2, @NotNull Element element, float opacityModifier) {
        ShapeInfo shapeInfo;
        if (layer == null) {
            LayeredImageConverter.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(7);
        }
        if (root2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(8);
        }
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(9);
        }
        if ((shapeInfo = layer.getShapeInfo()).getStyle() != ShapeInfo.Style.FILL) {
            BasicStroke stroke;
            boolean isBasicStroke = shapeInfo.getStroke() instanceof BasicStroke;
            if (isBasicStroke && ((stroke = (BasicStroke)shapeInfo.getStroke()).getDashArray() != null || clipPath != null || shapeInfo.getStrokeAlignment() != ShapeInfo.Alignment.CENTER)) {
                this.extractStrokeAsPath(layer, path2, clipPath, root2, opacityModifier);
                return false;
            }
            Paint strokePaint = shapeInfo.getStrokePaint();
            Color color = Color.BLACK;
            if (strokePaint instanceof Color) {
                color = (Color)strokePaint;
            }
            float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
            element.attribute("strokeColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (strokeAlpha < 1.0f) {
                element.attribute("strokeAlpha", this.myOpacityFormat.format(strokeAlpha));
            }
            if (isBasicStroke) {
                BasicStroke stroke2 = (BasicStroke)shapeInfo.getStroke();
                element.attribute("strokeWidth", this.myFormat.format(stroke2.getLineWidth()));
                if (stroke2.getLineJoin() != 0) {
                    element.attribute("strokeLineJoin", LayeredImageConverter.getJoinValue(stroke2.getLineJoin()));
                } else {
                    element.attribute("strokeMiterLimit", this.myMiterFormat.format(stroke2.getMiterLimit()));
                }
                if (stroke2.getEndCap() != 0) {
                    element.attribute("strokeLineCap", LayeredImageConverter.getCapValue(stroke2.getEndCap()));
                }
            } else {
                element.attribute("strokeWidth", String.valueOf(0.0f));
            }
            return true;
        }
        return false;
    }

    private void extractStrokeAsPath(@NotNull Layer layer, @NotNull Shape path2, @Nullable Area clipPath, @NotNull Element root2, float opacityModifier) {
        if (layer == null) {
            LayeredImageConverter.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(11);
        }
        if (root2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(12);
        }
        ShapeInfo shapeInfo = layer.getShapeInfo();
        BasicStroke stroke = (BasicStroke)shapeInfo.getStroke();
        Shape strokedPath = null;
        switch (shapeInfo.getStrokeAlignment()) {
            case INSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path2);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).intersect(new Area(path2));
                break;
            }
            case CENTER: {
                strokedPath = stroke.createStrokedShape(path2);
                if (clipPath == null) break;
                strokedPath = new Area(strokedPath);
                break;
            }
            case OUTSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path2);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).subtract(new Area(path2));
            }
        }
        if (clipPath != null) {
            ((Area)strokedPath).intersect(new Area(clipPath));
        }
        Paint strokePaint = shapeInfo.getStrokePaint();
        Color color = Color.BLACK;
        if (strokePaint instanceof Color) {
            color = (Color)strokePaint;
        }
        float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
        Element element = new Element("path").attribute("name", StringUtil.escapeXml((String)layer.getName())).attribute("pathData", LayeredImageConverter.toPathData(strokedPath, this.myFormat)).attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
        if (strokeAlpha < 1.0f) {
            element.attribute("fillAlpha", this.myOpacityFormat.format(strokeAlpha));
        }
        root2.childAtFront(element);
    }

    private static String optimizedHex(Color color) {
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            char r = Integer.toHexString(color.getRed()).charAt(0);
            return new String(new char[]{r, r, r});
        }
        return ColorUtil.toHex((Color)color);
    }

    @NotNull
    private static BasicStroke copyStroke(@NotNull BasicStroke stroke, float widthScale) {
        if (stroke == null) {
            LayeredImageConverter.$$$reportNull$$$0(13);
        }
        return new BasicStroke(stroke.getLineWidth() * widthScale, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
    }

    private boolean extractFill(@NotNull Layer layer, @NotNull Element element, float opacityModifier) {
        ShapeInfo shapeInfo;
        if (layer == null) {
            LayeredImageConverter.$$$reportNull$$$0(14);
        }
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(15);
        }
        if ((shapeInfo = layer.getShapeInfo()).getStyle() != ShapeInfo.Style.STROKE) {
            Paint fillPaint = shapeInfo.getFillPaint();
            Color color = Color.BLACK;
            if (fillPaint instanceof Color) {
                color = (Color)fillPaint;
            }
            float fillAlpha = layer.getOpacity() * shapeInfo.getFillOpacity() * opacityModifier;
            element.attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (fillAlpha < 1.0f) {
                element.attribute("fillAlpha", this.myOpacityFormat.format(fillAlpha));
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static String getCapValue(int endCap) {
        switch (endCap) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return "inherit";
    }

    @NotNull
    private static String getJoinValue(int lineJoin) {
        switch (lineJoin) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return "inherit";
    }

    @NotNull
    private static String toPathData(@NotNull Shape path2, @NotNull DecimalFormat format) {
        if (path2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(16);
        }
        if (format == null) {
            LayeredImageConverter.$$$reportNull$$$0(17);
        }
        StringBuilder buffer = new StringBuilder(1024);
        float[] coords = new float[6];
        PathIterator iterator = path2.getPathIterator(null);
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstX = 0.0f;
        float firstY = 0.0f;
        boolean implicitLineTo = false;
        while (!iterator.isDone()) {
            int segment = iterator.currentSegment(coords);
            switch (segment) {
                case 0: {
                    buffer.append('m');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    firstX = lastX = coords[0];
                    firstY = lastY = coords[1];
                    implicitLineTo = true;
                    break;
                }
                case 1: {
                    if (coords[0] == lastX) {
                        if (coords[1] != lastY) {
                            buffer.append('v');
                            buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                            implicitLineTo = false;
                        }
                    } else if (coords[1] == lastY) {
                        if (coords[0] != lastX) {
                            buffer.append('h');
                            buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                            implicitLineTo = false;
                        }
                    } else if (coords[0] != lastX && coords[1] != lastY) {
                        buffer.append(implicitLineTo ? (char)' ' : 'l');
                        buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                        buffer.append(' ');
                        buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    }
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 3: {
                    buffer.append('c');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[4] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[5] - lastY, format));
                    implicitLineTo = false;
                    lastX = coords[4];
                    lastY = coords[5];
                    break;
                }
                case 2: {
                    buffer.append('q');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format));
                    implicitLineTo = false;
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 4: {
                    buffer.append('z');
                    lastX = firstX;
                    lastY = firstY;
                }
            }
            iterator.next();
        }
        String string = buffer.toString();
        if (string == null) {
            LayeredImageConverter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static DecimalFormat createDecimalFormat(float viewportWidth, float viewportHeight) {
        float minSize = Math.min(viewportHeight, viewportWidth);
        float exponent = Math.round(Math.log10(minSize));
        int decimalPlace = (int)Math.floor(exponent - 4.0f);
        Object decimalFormatString = "#";
        if (decimalPlace < 0) {
            if (decimalPlace < -6) {
                decimalPlace = -6;
            }
            decimalFormatString = (String)decimalFormatString + ".";
            for (int i2 = 0; i2 < -decimalPlace; ++i2) {
                decimalFormatString = (String)decimalFormatString + "#";
            }
        }
        DecimalFormatSymbols fractionSeparator = new DecimalFormatSymbols();
        fractionSeparator.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat((String)decimalFormatString, fractionSeparator);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        DecimalFormat decimalFormat2 = decimalFormat;
        if (decimalFormat2 == null) {
            LayeredImageConverter.$$$reportNull$$$0(19);
        }
        return decimalFormat2;
    }

    @NotNull
    private static String cleanup(float value2, @NotNull DecimalFormat format) {
        if (format == null) {
            LayeredImageConverter.$$$reportNull$$$0(20);
        }
        if (value2 == (float)((long)value2)) {
            String string = String.valueOf((long)value2);
            if (string == null) {
                LayeredImageConverter.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = format.format(value2);
        if (string == null) {
            LayeredImageConverter.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String toVectorDrawable(@NotNull Element element) {
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(23);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        LayeredImageConverter.outputElement(element, out, true, 0);
        out.flush();
        String string = stringWriter.toString();
        if (string == null) {
            LayeredImageConverter.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void outputElement(@NotNull Element element, @NotNull PrintWriter out, boolean isRoot, int indent) {
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(25);
        }
        if (out == null) {
            LayeredImageConverter.$$$reportNull$$$0(26);
        }
        LayeredImageConverter.indent(out, indent);
        out.write("<");
        out.write(element.name);
        if (isRoot) {
            out.write(" xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        }
        out.write("\n");
        boolean hasChildren = !element.children.isEmpty();
        LayeredImageConverter.outputAttributes(element, out, ++indent);
        if (hasChildren) {
            out.write(">\n");
            LayeredImageConverter.outputChildren(element, out, indent);
        } else {
            out.write(" />");
        }
        --indent;
        if (hasChildren) {
            LayeredImageConverter.indent(out, indent);
            out.write("</");
            out.write(element.name);
            out.write(">");
        }
        out.write("\n");
    }

    private static void outputChildren(@NotNull Element element, @NotNull PrintWriter out, int indent) {
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(27);
        }
        if (out == null) {
            LayeredImageConverter.$$$reportNull$$$0(28);
        }
        for (Element child : element.children) {
            LayeredImageConverter.outputElement(child, out, false, indent);
        }
    }

    private static void outputAttributes(@NotNull Element element, @NotNull PrintWriter out, int indent) {
        if (element == null) {
            LayeredImageConverter.$$$reportNull$$$0(29);
        }
        if (out == null) {
            LayeredImageConverter.$$$reportNull$$$0(30);
        }
        List<Attribute> attributes = element.attributes;
        int size = attributes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute = attributes.get(i2);
            LayeredImageConverter.indent(out, indent);
            out.write("android:");
            out.write(attribute.name);
            out.write("=\"");
            out.write(attribute.value);
            out.write("\"");
            if (i2 == size - 1) continue;
            out.write("\n");
        }
    }

    private static void indent(@NotNull PrintWriter out, int indent) {
        if (out == null) {
            LayeredImageConverter.$$$reportNull$$$0(31);
        }
        for (int i2 = 0; i2 < indent; ++i2) {
            out.write("    ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 9: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stroke";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toVectorDrawableXml";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformedPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toPathData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecimalFormat";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanup";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toVectorDrawable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toVectorDrawableXml";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractPathLayers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractStroke";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractStrokeAsPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyStroke";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractFill";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toPathData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toVectorDrawable";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "outputElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "outputChildren";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "outputAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Element {
        final String name;
        final List<Element> children;
        final List<Attribute> attributes;

        Element(@NotNull String name) {
            if (name == null) {
                Element.$$$reportNull$$$0(0);
            }
            this.children = new ArrayList<Element>();
            this.attributes = new ArrayList<Attribute>();
            this.name = name;
        }

        Element attribute(@NotNull String name, @NotNull String value2) {
            if (name == null) {
                Element.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                Element.$$$reportNull$$$0(2);
            }
            this.attributes.add(new Attribute(name, value2));
            return this;
        }

        Element childAtFront(@NotNull Element child) {
            if (child == null) {
                Element.$$$reportNull$$$0(3);
            }
            this.children.add(0, child);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Element";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "attribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAtFront";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Attribute {
        final String name;
        final String value;

        Attribute(@NotNull String name, @NotNull String value2) {
            if (name == null) {
                Attribute.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                Attribute.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.value = value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Attribute";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

