/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.Gravity;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvBannerGenerator
extends IconGenerator {
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(0xFFFFFF);
    private static final Rectangle IMAGE_SIZE_ADAPTIVE_DP = new Rectangle(0, 0, 320, 180);
    private static final Dimension SIZE_ADAPTIVE_DP = IMAGE_SIZE_ADAPTIVE_DP.getSize();
    private static final double ADAPTIVE_ICON_SCALE_FACTOR = 0.6666666666666666;
    private static final Density LEGACY_DENSITY = Density.XHIGH;
    private static final double IMAGE_TEXT_RATIO = 0.4;
    private static final double DEFAULT_TEXT_SCALE = 0.82;
    private static final double IMAGE_MARGIN = 0.03;
    private static final double PREVIEW_SCALE = 0.31;
    private final ObjectProperty<Color> myBackgroundColor;
    private final BoolProperty myGenerateLegacyIcon;
    private final OptionalProperty<TextAsset> myTextAsset;
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    private final StringProperty myForegroundLayerName;
    private final StringProperty myBackgroundLayerName;

    public TvBannerGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        if (project == null) {
            TvBannerGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
        this.myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
        this.myGenerateLegacyIcon = new BoolValueProperty(true);
        this.myTextAsset = new OptionalValueProperty<TextAsset>();
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
        this.myForegroundLayerName = new StringValueProperty();
        this.myBackgroundLayerName = new StringValueProperty();
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(1);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        BoolProperty boolProperty = this.myGenerateLegacyIcon;
        if (boolProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<TextAsset> textAsset() {
        OptionalProperty<TextAsset> optionalProperty = this.myTextAsset;
        if (optionalProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(3);
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        OptionalProperty<ImageAsset> optionalProperty = this.myBackgroundImageAsset;
        if (optionalProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(4);
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        StringProperty stringProperty = this.myForegroundLayerName;
        if (stringProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        StringProperty stringProperty = this.myBackgroundLayerName;
        if (stringProperty == null) {
            TvBannerGenerator.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @Override
    @NotNull
    public TvBannerOptions createOptions(boolean forPreview) {
        TextAsset textAsset;
        TvBannerOptions options = new TvBannerOptions(forPreview);
        ImageAsset foregroundAsset = (ImageAsset)this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null && foregroundAsset.imagePath().getValueOrNull() != null) {
            double scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext());
        }
        if ((textAsset = this.myTextAsset.getValueOrNull()) != null && !StringUtil.trimTrailing((String)((String)textAsset.text().get())).isEmpty()) {
            double scaleFactor = (double)((Integer)textAsset.scalingPercent().get()).intValue() / 100.0;
            options.foregroundText = new TransformedImageAsset(textAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext());
            Color color = (Color)textAsset.color().getValueOrNull();
            options.foregroundTextColor = color == null ? 0 : color.getRGB();
        }
        TvBannerGenerator.shiftImageAndText(options);
        ImageAsset backgroundAsset = this.myBackgroundImageAsset.getValueOrNull();
        if (backgroundAsset != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_ADAPTIVE_DP, scaleFactor, null, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        TvBannerOptions tvBannerOptions = options;
        if (tvBannerOptions == null) {
            TvBannerGenerator.$$$reportNull$$$0(7);
        }
        return tvBannerOptions;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(8);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(9);
        }
        if (name == null) {
            TvBannerGenerator.$$$reportNull$$$0(10);
        }
        TvBannerOptions tvBannerOptions = (TvBannerOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, tvBannerOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, tvBannerOptions, tasks);
        TvBannerGenerator.createPreviewImagesTasks(context, tvBannerOptions, tasks);
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            TvBannerGenerator.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvBannerOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(12);
        }
        if (name == null) {
            TvBannerGenerator.$$$reportNull$$$0(13);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(14);
        }
        if (tasks == null) {
            TvBannerGenerator.$$$reportNull$$$0(15);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        TvBannerOptions localOptions = options.clone();
        localOptions.density = LEGACY_DENSITY;
        this.createOutputIconsForSingleDensityTasks(context, name, localOptions, tasks);
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvBannerOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(16);
        }
        if (name == null) {
            TvBannerGenerator.$$$reportNull$$$0(17);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(18);
        }
        if (tasks == null) {
            TvBannerGenerator.$$$reportNull$$$0(19);
        }
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvBannerOptions foregroundOptions = options.clone();
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = TvBannerGenerator.generateIconForegroundLayer(foregroundOptions, false);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, options.density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvBannerOptions backgroundOptions = options.clone();
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = TvBannerGenerator.generateIconBackgroundLayer(context, backgroundOptions, false);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, options.density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                TvBannerOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = TvBannerGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, options.density, legacy);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull TvBannerOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (name == null) {
            TvBannerGenerator.$$$reportNull$$$0(20);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(21);
        }
        if (tasks == null) {
            TvBannerGenerator.$$$reportNull$$$0(22);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        TvBannerOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        TransformedImageAsset image = options.foregroundImage;
        TransformedImageAsset text = options.foregroundText;
        if (image == null ? text != null : image.isDrawable()) {
            tasks.add(() -> {
                TvBannerOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String imageDrawable = null;
                String textDrawable = null;
                if (image != null && (imageDrawable = image.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    imageDrawable = "<vector/>";
                }
                if (text != null && (textDrawable = text.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed foreground text is null", new Throwable());
                    textDrawable = "<vector/>";
                }
                String xmlDrawableText = imageDrawable == null ? textDrawable : (textDrawable == null ? imageDrawable : VectorDrawableTransformer.merge(imageDrawable, textDrawable));
                xmlDrawableText = TvBannerGenerator.applyAdaptiveIconScaleFactor(xmlDrawableText);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            TransformedImageAsset backgroundImage = options.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvBannerOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!backgroundImage.isDrawable()) {
                    TvBannerGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = backgroundImage.getTransformedDrawable()) == null) {
                    TvBannerGenerator.getLog().error("Transformed background drawable is null" + (backgroundImage.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                xmlDrawableText = TvBannerGenerator.applyAdaptiveIconScaleFactor(xmlDrawableText);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                TvBannerOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private static String applyAdaptiveIconScaleFactor(@NotNull String xmlDrawableText) {
        if (xmlDrawableText == null) {
            TvBannerGenerator.$$$reportNull$$$0(23);
        }
        String string = VectorDrawableTransformer.transform(xmlDrawableText, SIZE_ADAPTIVE_DP, Gravity.CENTER, 0.6666666666666666, null, null, null, 1.0);
        if (string == null) {
            TvBannerGenerator.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void shiftImageAndText(@NotNull TvBannerOptions options) {
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(25);
        }
        TransformedImageAsset image = options.foregroundImage;
        TransformedImageAsset text = options.foregroundText;
        if (text != null) {
            if (image != null) {
                image.setShift(new Point2D.Double(-0.27, 0.0));
                double scaleFactor = text.getScaleFactor();
                double shift = 0.2 + 0.3 * (scaleFactor * 0.82 - 1.0);
                text.setShift(new Point2D.Double(shift, 0.0));
                text.setGravity(Gravity.WEST);
                text.applyAdditionalScaleFactor(0.49199999999999994);
            } else {
                text.applyAdditionalScaleFactor(0.82);
            }
        }
    }

    private static BufferedImage mergeImages(@NotNull BufferedImage image1, @NotNull BufferedImage image2) {
        if (image1 == null) {
            TvBannerGenerator.$$$reportNull$$$0(26);
        }
        if (image2 == null) {
            TvBannerGenerator.$$$reportNull$$$0(27);
        }
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)image1.getWidth(), (int)image1.getHeight());
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        gOut.drawImage((Image)image1, 0, 0, null);
        gOut.drawImage((Image)image2, 0, 0, null);
        gOut.dispose();
        return outImage;
    }

    @NotNull
    private String getAdaptiveIconXml(@NotNull TvBannerOptions options) {
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(28);
        }
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        String string = String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
        if (string == null) {
            TvBannerGenerator.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(30);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(31);
        }
        if (tasks == null) {
            TvBannerGenerator.$$$reportNull$$$0(32);
        }
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.ADAPTIVE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                TvBannerOptions localOptions = options.clone();
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                try {
                    image = TvBannerGenerator.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    TvBannerGenerator.getLog().error(e);
                    image = TvBannerGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name) {
        if (categoryMap == null) {
            TvBannerGenerator.$$$reportNull$$$0(33);
        }
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(34);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(35);
        }
        if (name == null) {
            TvBannerGenerator.$$$reportNull$$$0(36);
        }
        TvBannerOptions tvBannerOptions = (TvBannerOptions)options;
        TvBannerOptions localOptions = tvBannerOptions.clone();
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            TvBannerOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(37);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(38);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                TvBannerGenerator.$$$reportNull$$$0(39);
            }
            return annotatedImage;
        }
        return TvBannerGenerator.generatePreviewImage(context, (TvBannerOptions)options);
    }

    @NotNull
    private static AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(40);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(41);
        }
        switch (options.previewShape) {
            case ADAPTIVE: 
            case LEGACY: {
                Layers layers = TvBannerGenerator.generateIconLayers(context, options, true);
                AnnotatedImage mergedImage = TvBannerGenerator.mergeLayers(layers);
                BufferedImage image = mergedImage.getImage();
                return new AnnotatedImage(image, mergedImage.getErrorMessage());
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(42);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(43);
        }
        Layers layers = TvBannerGenerator.generateIconLayers(context, options, false);
        AnnotatedImage mergedImage = TvBannerGenerator.mergeLayers(layers);
        BufferedImage image = mergedImage.getImage();
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private static AnnotatedImage mergeLayers(@NotNull Layers layers) {
        if (layers == null) {
            TvBannerGenerator.$$$reportNull$$$0(44);
        }
        BufferedImage backgroundImage = layers.background.getImage();
        BufferedImage foregroundImage = layers.foreground.getImage();
        int width = Math.max(backgroundImage.getWidth(), foregroundImage.getWidth());
        int height = Math.max(backgroundImage.getHeight(), foregroundImage.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        gOut.drawImage((Image)backgroundImage, 0, 0, null);
        gOut.drawImage((Image)foregroundImage, 0, 0, null);
        gOut.dispose();
        String errorMessage = layers.foreground.getErrorMessage();
        if (errorMessage == null) {
            errorMessage = layers.background.getErrorMessage();
        }
        return new AnnotatedImage(outImage, errorMessage);
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options, boolean forPreview) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(45);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(46);
        }
        AnnotatedImage backgroundImage = TvBannerGenerator.generateIconBackgroundLayer(context, options, forPreview);
        AnnotatedImage foregroundImage = TvBannerGenerator.generateIconForegroundLayer(options, forPreview);
        return new Layers(backgroundImage, foregroundImage);
    }

    @NotNull
    private static AnnotatedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull TvBannerOptions options, boolean forPreview) {
        BufferedImage image;
        TransformedImageAsset imageAsset;
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(47);
        }
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(48);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                TvBannerGenerator.$$$reportNull$$$0(49);
            }
            return annotatedImage;
        }
        String errorMessage = null;
        Rectangle imageRect = IMAGE_SIZE_ADAPTIVE_DP;
        if (forPreview) {
            Density density = options.previewShape == PreviewShape.LEGACY ? LEGACY_DENSITY : Density.XXXHIGH;
            double scale = TvBannerGenerator.getMdpiScaleFactor(density) * 0.31;
            imageRect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scale);
        }
        if ((imageAsset = options.backgroundImage) == null) {
            image = TvBannerGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
        } else {
            try {
                image = TvBannerGenerator.generateIconBackgroundLayer(context, imageAsset, imageRect);
            }
            catch (RuntimeException e) {
                errorMessage = TvBannerGenerator.composeErrorMessage(e, "background", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static String composeErrorMessage(@NotNull Exception e, @NotNull String role, @Nullable TransformedImageAsset imageAsset) {
        if (e == null) {
            TvBannerGenerator.$$$reportNull$$$0(50);
        }
        if (role == null) {
            TvBannerGenerator.$$$reportNull$$$0(51);
        }
        String errorMessage = imageAsset != null && imageAsset.isDrawable() ? String.format("Unable to generate image, possibly invalid %s drawable", role) : String.format("Failed to transform %s image", role);
        String exceptionMessage = e.getMessage();
        Object object = exceptionMessage == null ? errorMessage : errorMessage + ": " + exceptionMessage;
        if (object == null) {
            TvBannerGenerator.$$$reportNull$$$0(52);
        }
        return object;
    }

    @NotNull
    private static AnnotatedImage generateIconForegroundLayer(@NotNull TvBannerOptions options, boolean forPreview) {
        BufferedImage image;
        if (options == null) {
            TvBannerGenerator.$$$reportNull$$$0(53);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                TvBannerGenerator.$$$reportNull$$$0(54);
            }
            return annotatedImage;
        }
        String errorMessage = null;
        Rectangle imageRect = IMAGE_SIZE_ADAPTIVE_DP;
        if (forPreview) {
            Density density = options.previewShape == PreviewShape.LEGACY ? LEGACY_DENSITY : Density.XXXHIGH;
            double scale = TvBannerGenerator.getMdpiScaleFactor(density) * 0.31;
            imageRect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scale);
        }
        TransformedImageAsset foregroundImage = options.foregroundImage;
        TransformedImageAsset foregroundText = options.foregroundText;
        try {
            image = TvBannerGenerator.generateIconForegroundLayer(imageRect, foregroundImage, foregroundText);
        }
        catch (RuntimeException e) {
            errorMessage = TvBannerGenerator.composeErrorMessage(e, "foreground", foregroundImage);
            image = foregroundImage == null ? AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height) : foregroundImage.createErrorImage(imageRect.getSize());
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        if (color == null) {
            TvBannerGenerator.$$$reportNull$$$0(55);
        }
        if (imageRect == null) {
            TvBannerGenerator.$$$reportNull$$$0(56);
        }
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        BufferedImage bufferedImage = result2;
        if (bufferedImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(57);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull Rectangle imageRect, @Nullable TransformedImageAsset image, @Nullable TransformedImageAsset text) {
        BufferedImage foregroundImage;
        if (imageRect == null) {
            TvBannerGenerator.$$$reportNull$$$0(58);
        }
        BufferedImage bufferedImage = foregroundImage = image == null ? null : image.getTransformedImage(imageRect.getSize());
        if (text == null) {
            if (foregroundImage != null) {
                BufferedImage bufferedImage2 = foregroundImage;
                if (bufferedImage2 == null) {
                    TvBannerGenerator.$$$reportNull$$$0(59);
                }
                return bufferedImage2;
            }
        } else {
            BufferedImage textImage = text.getTransformedImage(imageRect.getSize());
            if (foregroundImage != null) {
                BufferedImage bufferedImage3 = TvBannerGenerator.mergeImages(foregroundImage, textImage);
                if (bufferedImage3 == null) {
                    TvBannerGenerator.$$$reportNull$$$0(60);
                }
                return bufferedImage3;
            }
            BufferedImage bufferedImage4 = textImage;
            if (bufferedImage4 == null) {
                TvBannerGenerator.$$$reportNull$$$0(61);
            }
            return bufferedImage4;
        }
        BufferedImage bufferedImage5 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage5 == null) {
            TvBannerGenerator.$$$reportNull$$$0(62);
        }
        return bufferedImage5;
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect) {
        String scaledDrawable;
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(63);
        }
        if (sourceImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(64);
        }
        if (imageRect == null) {
            TvBannerGenerator.$$$reportNull$$$0(65);
        }
        if ((scaledDrawable = sourceImage.getTransformedDrawable()) != null) {
            return TvBannerGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return TvBannerGenerator.generateIconBackgroundLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor());
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(66);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        block8: {
            BufferedImage bufferedImage;
            if (context == null) {
                TvBannerGenerator.$$$reportNull$$$0(67);
            }
            if (xmlDrawable == null) {
                TvBannerGenerator.$$$reportNull$$$0(68);
            }
            if (imageRect == null) {
                TvBannerGenerator.$$$reportNull$$$0(69);
            }
            Future<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
            try {
                BufferedImage image = imageFuture.get();
                if (image == null) break block8;
                bufferedImage = image;
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e.getCause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bufferedImage == null) {
                TvBannerGenerator.$$$reportNull$$$0(70);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(71);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor) {
        if (context == null) {
            TvBannerGenerator.$$$reportNull$$$0(72);
        }
        if (sourceImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(73);
        }
        if (imageRect == null) {
            TvBannerGenerator.$$$reportNull$$$0(74);
        }
        Callable<Future> generator2 = () -> FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            return iconImage;
        });
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            /*
             * WARNING - void declaration
             */
            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
                void fillColor;
                if (source == null) {
                    CacheKey.$$$reportNull$$$0(0);
                }
                if (imageRect == null) {
                    CacheKey.$$$reportNull$$$0(1);
                }
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "imageRect";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/npw/assetstudio/TvBannerGenerator$1CacheKey";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, false, 0);
        Future<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator2);
        BufferedImage bufferedImage = (BufferedImage)Futures.getUnchecked(imageFuture);
        if (bufferedImage == null) {
            TvBannerGenerator.$$$reportNull$$$0(75);
        }
        return bufferedImage;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            TvBannerGenerator.$$$reportNull$$$0(76);
        }
        return density == Density.XHIGH;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(TvBannerGenerator.class);
        if (logger2 == null) {
            TvBannerGenerator.$$$reportNull$$$0(77);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 29: 
            case 39: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 70: 
            case 71: 
            case 75: 
            case 77: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 29: 
            case 39: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 70: 
            case 71: 
            case 75: 
            case 77: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 29: 
            case 39: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 70: 
            case 71: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/TvBannerGenerator";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 63: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image2";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 56: 
            case 58: 
            case 65: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageRect";
                break;
            }
            case 64: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/TvBannerGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "textAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundImageAsset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundLayerName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundLayerName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAdaptiveIconScaleFactor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconXml";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 49: 
            case 66: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconBackgroundLayer";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "composeErrorMessage";
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconForegroundLayer";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFlatColorRectangle";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayer";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 29: 
            case 39: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 70: 
            case 71: 
            case 75: 
            case 77: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsTasks";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsForSingleDensityTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createXmlDrawableResourcesTasks";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyAdaptiveIconScaleFactor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shiftImageAndText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mergeImages";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAdaptiveIconXml";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewImagesTasks";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewImage";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateLegacyImage";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mergeLayers";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayers";
                break;
            }
            case 47: 
            case 48: 
            case 63: 
            case 64: 
            case 65: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "generateIconBackgroundLayer";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "composeErrorMessage";
                break;
            }
            case 53: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "generateIconForegroundLayer";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "generateFlatColorRectangle";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayer";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 29: 
            case 39: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 70: 
            case 71: 
            case 75: 
            case 77: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Layers {
        @NotNull
        public AnnotatedImage background;
        @NotNull
        public AnnotatedImage foreground;

        Layers(@NotNull AnnotatedImage background, @NotNull AnnotatedImage foreground) {
            if (background == null) {
                Layers.$$$reportNull$$$0(0);
            }
            if (foreground == null) {
                Layers.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.foreground = foreground;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/TvBannerGenerator$Layers";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        ADAPTIVE("adaptive", "Adaptive (anydpi)"),
        LEGACY("legacy", "Legacy (xhdpi)");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            if (id == null) {
                PreviewShape.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                PreviewShape.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.displayName = displayName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/TvBannerGenerator$PreviewShape";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TvBannerOptions
    extends IconGenerator.IconOptions
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        @Nullable
        public TransformedImageAsset foregroundImage;
        @Nullable
        public TransformedImageAsset foregroundText;
        public int foregroundTextColor = 0;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public PreviewShape previewShape = PreviewShape.NONE;

        public TvBannerOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public TvBannerOptions clone() {
            TvBannerOptions tvBannerOptions = (TvBannerOptions)super.clone();
            if (tvBannerOptions == null) {
                TvBannerOptions.$$$reportNull$$$0(0);
            }
            return tvBannerOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/TvBannerGenerator$TvBannerOptions", "clone"));
        }
    }
}

