/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialDesignIcons {
    private static final String DEFAULT_ICON_NAME = "action/ic_android_black_24dp.xml";
    private static final String PATH = "images/material_design_icons/";
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("images/material_design_icons/(\\w+)/");

    private MaterialDesignIcons() {
    }

    @Nullable
    public static String getPathForBasename(@NotNull String basename) {
        if (basename == null) {
            MaterialDesignIcons.$$$reportNull$$$0(0);
        }
        return MaterialDesignIcons.getBasenameToPathMap(path2 -> BuiltInImages.getResourcesNames(path2, ".xml")).get(basename);
    }

    @NotNull
    @VisibleForTesting
    static Map<String, String> getBasenameToPathMap(@NotNull Function<String, List<String>> generator2) {
        if (generator2 == null) {
            MaterialDesignIcons.$$$reportNull$$$0(1);
        }
        ImmutableMap.Builder builder2 = new ImmutableMap.Builder();
        int dotXmlLength = ".xml".length();
        for (String category : MaterialDesignIcons.getCategories()) {
            String path2 = PATH + category + "/";
            for (String name : generator2.apply(path2)) {
                builder2.put((Object)name.substring(0, name.length() - dotXmlLength), (Object)(path2 + name));
            }
        }
        ImmutableMap immutableMap = builder2.build();
        if (immutableMap == null) {
            MaterialDesignIcons.$$$reportNull$$$0(2);
        }
        return immutableMap;
    }

    @NotNull
    public static Collection<String> getCategories() {
        Collection<String> collection2 = MaterialDesignIcons.getCategories(MaterialDesignIcons.getResourceUrl(PATH));
        if (collection2 == null) {
            MaterialDesignIcons.$$$reportNull$$$0(3);
        }
        return collection2;
    }

    @NotNull
    public static List<String> getIconNames(@NotNull String categoryName) {
        if (categoryName == null) {
            MaterialDesignIcons.$$$reportNull$$$0(4);
        }
        List<String> list = BuiltInImages.getResourcesNames(MaterialDesignIcons.getIconDirectoryPath(categoryName), ".xml");
        if (list == null) {
            MaterialDesignIcons.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static URL getIcon(@NotNull String iconName, @NotNull String categoryName) {
        if (iconName == null) {
            MaterialDesignIcons.$$$reportNull$$$0(6);
        }
        if (categoryName == null) {
            MaterialDesignIcons.$$$reportNull$$$0(7);
        }
        URL uRL = MaterialDesignIcons.getResourceUrl(MaterialDesignIcons.getIconDirectoryPath(categoryName) + iconName);
        if (uRL == null) {
            MaterialDesignIcons.$$$reportNull$$$0(8);
        }
        return uRL;
    }

    @NotNull
    public static URL getDefaultIcon() {
        URL url = MaterialDesignIcons.getResourceUrl("images/material_design_icons/action/ic_android_black_24dp.xml");
        assert (url != null);
        URL uRL = url;
        if (uRL == null) {
            MaterialDesignIcons.$$$reportNull$$$0(9);
        }
        return uRL;
    }

    @VisibleForTesting
    static Collection<String> getCategories(@Nullable URL url) {
        if (url == null) {
            return Collections.emptyList();
        }
        switch (url.getProtocol()) {
            case "file": {
                return MaterialDesignIcons.getCategoriesFromFile(new File(url.getPath()));
            }
            case "jar": {
                try {
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    return MaterialDesignIcons.getCategoriesFromJar(connection.getJarFile());
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    @VisibleForTesting
    static Collection<String> getCategoriesFromFile(@NotNull File file) {
        String[] array;
        if (file == null) {
            MaterialDesignIcons.$$$reportNull$$$0(10);
        }
        if ((array = file.list()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MaterialDesignIcons.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<String> list = Arrays.asList(array);
        list.sort(String::compareTo);
        List<String> list2 = list;
        if (list2 == null) {
            MaterialDesignIcons.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    @VisibleForTesting
    static Collection<String> getCategoriesFromJar(@NotNull ZipFile jar) {
        if (jar == null) {
            MaterialDesignIcons.$$$reportNull$$$0(13);
        }
        Collection collection2 = jar.stream().map(MaterialDesignIcons::getCategory).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (collection2 == null) {
            MaterialDesignIcons.$$$reportNull$$$0(14);
        }
        return collection2;
    }

    @Nullable
    private static String getCategory(@NotNull ZipEntry entry) {
        Matcher matcher;
        if (entry == null) {
            MaterialDesignIcons.$$$reportNull$$$0(15);
        }
        return (matcher = CATEGORY_PATTERN.matcher(entry.getName())).matches() ? matcher.group(1) : null;
    }

    @NotNull
    private static String getIconDirectoryPath(String categoryName) {
        String string = PATH + StringUtil.toLowerCase((String)categoryName) + "/";
        if (string == null) {
            MaterialDesignIcons.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static URL getResourceUrl(String iconPath) {
        return MaterialDesignIcons.class.getClassLoader().getResource(iconPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/MaterialDesignIcons";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/MaterialDesignIcons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasenameToPathMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoriesFromFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoriesFromJar";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconDirectoryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathForBasename";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBasenameToPathMap";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIconNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCategoriesFromFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCategoriesFromJar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

