/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IndexedRegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.PlainFolderRegularExpressionIncludeResolver;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CocosIncludeResolver
extends IncludeResolver {
    @NotNull
    private final IncludeResolver[] myResolvers = new IncludeResolver[]{PlainFolderRegularExpressionIncludeResolver.include("^.*/cocos2d[^//]*/external/$"), PlainFolderRegularExpressionIncludeResolver.include("^.*/cocos2d[^//]*/cocos/editor-support/$"), PlainFolderRegularExpressionIncludeResolver.include("^.*/cocos2d[^//]*/$"), PlainFolderRegularExpressionIncludeResolver.include("^.*/cocos2d[^//]*/cocos/$"), CocosIncludeResolver.cocosEditorPackage(), CocosIncludeResolver.cocosPackage(), CocosIncludeResolver.cocosExternalPackage("^(?<home>.*/cocos2d.*?)(?<relative>/external/(?<library>.*?)(/.*))$"), CocosIncludeResolver.cocosExternalPackage("^(?<home>.*/cocos2d.*?)(?<relative>/(?<library>.*?)(/.*))$")};

    CocosIncludeResolver() {
    }

    @NotNull
    static IncludeResolver cocosPackage() {
        return new IndexedRegularExpressionIncludeResolver(PackageType.CocosFrameworkModule, "^(?<home>.*/cocos2d.*?)(?<relative>/cocos/(?<library>.*?)(/.*))$", null);
    }

    @NotNull
    static IncludeResolver cocosEditorPackage() {
        return new IndexedRegularExpressionIncludeResolver(PackageType.CocosEditorSupportModule, "^(?<home>.*/cocos2d.*?)(?<relative>/cocos/editor-support/(?<library>.*?)(/.*))$", null);
    }

    @NotNull
    static IncludeResolver cocosExternalPackage(@NotNull String pattern) {
        if (pattern == null) {
            CocosIncludeResolver.$$$reportNull$$$0(0);
        }
        return new IndexedRegularExpressionIncludeResolver(PackageType.CocosThirdPartyPackage, pattern, null);
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        if (includeFolder == null) {
            CocosIncludeResolver.$$$reportNull$$$0(1);
        }
        for (IncludeResolver resolver : this.myResolvers) {
            SimpleIncludeValue classifiedIncludeExpression = resolver.resolve(includeFolder);
            if (classifiedIncludeExpression == null) continue;
            return classifiedIncludeExpression;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolder";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/resolver/CocosIncludeResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cocosExternalPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

