/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.apk.SourceFolders;
import com.android.tools.idea.navigator.nodes.apk.java.DexGroupNode;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibFolderNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkModuleNode
extends ProjectViewModuleNode {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ApkFacet myApkFacet;
    @Nullable
    private final PsiFile myApkPsiFile;
    @Nullable
    private final VirtualFile myApkFile;
    @Nullable
    private final VirtualFile myManifestFile;
    @NotNull
    private final List<VirtualFile> myDexFiles;
    @NotNull
    private final List<DexGroupNode> myDexGroupNodes;

    public ApkModuleNode(@NotNull Project project, @NotNull Module module, @NotNull AndroidFacet androidFacet, @NotNull ApkFacet apkFacet, @NotNull ViewSettings settings) {
        if (project == null) {
            ApkModuleNode.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ApkModuleNode.$$$reportNull$$$0(1);
        }
        if (androidFacet == null) {
            ApkModuleNode.$$$reportNull$$$0(2);
        }
        if (apkFacet == null) {
            ApkModuleNode.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            ApkModuleNode.$$$reportNull$$$0(4);
        }
        super(project, module, settings);
        this.myModuleName = module.getName();
        this.myAndroidFacet = androidFacet;
        this.myApkFacet = apkFacet;
        this.myApkPsiFile = this.findApkPsiFile();
        this.myApkFile = this.myApkPsiFile != null ? this.myApkPsiFile.getVirtualFile() : null;
        VirtualFile apkRootFile = this.myApkFile != null ? ApkFileSystem.getInstance().getRootByLocal(this.myApkFile) : null;
        VirtualFile rootFolder = this.findModuleRootFolder();
        this.myManifestFile = rootFolder != null ? rootFolder.findChild("AndroidManifest.xml") : null;
        this.myDexGroupNodes = new ArrayList<DexGroupNode>();
        this.myDexFiles = new ArrayList<VirtualFile>();
        if (apkRootFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> apkRootFile.refresh(false, true)));
            Pattern dexFilePattern = Pattern.compile("classes\\d*\\.dex");
            for (VirtualFile child : apkRootFile.getChildren()) {
                if (!dexFilePattern.matcher(child.getName()).matches()) continue;
                ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> child.refresh(false, false)));
                this.myDexFiles.add(child);
            }
        }
    }

    @Nullable
    private VirtualFile findModuleRootFolder() {
        File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(this.getModule());
        if (moduleRootFolderPath == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)moduleRootFolderPath, (boolean)false);
    }

    @Nullable
    private PsiFile findApkPsiFile() {
        VirtualFile apkFile;
        File apkFilePath;
        String apkPath = ((ApkFacetConfiguration)this.myApkFacet.getConfiguration()).APK_PATH;
        if (StringUtil.isNotEmpty((String)apkPath) && (apkFilePath = new File(FileUtil.toSystemDependentName((String)apkPath))).isFile() && (apkFile = VfsUtil.findFileByIoFile((File)apkFilePath, (boolean)true)) != null) {
            assert (this.myProject != null);
            return PsiManager.getInstance((Project)this.myProject).findFile(apkFile);
        }
        return null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        assert (this.myProject != null);
        ViewSettings settings = this.getSettings();
        ArrayList children = new ArrayList();
        if (this.myApkPsiFile != null) {
            children.add((AbstractTreeNode<?>)new PsiFileNode(this.myProject, this.myApkPsiFile, settings));
        }
        children.add((AbstractTreeNode<?>)this.createManifestGroupNode());
        if (this.myDexGroupNodes.isEmpty()) {
            for (VirtualFile dexFile : this.myDexFiles) {
                DexGroupNode node = new DexGroupNode(this.myProject, settings, dexFile);
                this.myDexGroupNodes.add(node);
            }
        }
        children.addAll(this.myDexGroupNodes);
        VirtualFile found = LibraryFolder.findIn(this.myProject);
        if (found != null) {
            children.add((AbstractTreeNode<?>)new LibFolderNode(this.myProject, found, settings));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            ApkModuleNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private AndroidManifestsGroupNode createManifestGroupNode() {
        assert (this.myProject != null);
        Set<VirtualFile> manifestFiles = this.myManifestFile != null ? Collections.singleton(this.myManifestFile) : Collections.emptySet();
        return new AndroidManifestsGroupNode(this.myProject, this.myAndroidFacet, this.getSettings(), manifestFiles);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "APK Module";
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            ApkModuleNode.$$$reportNull$$$0(6);
        }
        return module2;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ApkModuleNode.$$$reportNull$$$0(7);
        }
        String path2 = file.getPath();
        if (this.myApkFile != null && Objects.equals(path2, this.myApkFile.getPath())) {
            return true;
        }
        if (Objects.equals(path2, this.getManifestPath())) {
            return true;
        }
        if (!this.myDexGroupNodes.isEmpty() && this.myDexGroupNodes.stream().anyMatch(node -> node.contains(file))) {
            return true;
        }
        VirtualFile found = LibraryFolder.findIn(this.myProject);
        if (found != null && VfsUtilCore.isAncestor((VirtualFile)found, (VirtualFile)file, (boolean)false)) {
            return true;
        }
        return SourceFolders.isInSourceFolder(file, this.myProject);
    }

    @Nullable
    private String getManifestPath() {
        return this.myManifestFile != null ? this.myManifestFile.getPath() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApkModuleNode)) {
            return false;
        }
        ApkModuleNode node = (ApkModuleNode)((Object)o);
        return Objects.equals(this.myModuleName, node.myModuleName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myModuleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ApkModuleNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ApkModuleNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

