/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpDouble;
import com.android.tools.idea.common.scene.LerpPoint;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelper;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.NavSceneManagerKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.naveditor.surface.NavInteractionHandler;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.utils.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JViewport;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NavDesignSurface
extends DesignSurface {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private static final String FAILED_DEPENDENCY = "Failed to add navigation dependency";
    private static final String FAILED_DEPENDENCY_TITLE = "Failed to Add Dependency";
    private NlComponent myCurrentNavigation;
    @VisibleForTesting
    AtomicReference<Future<?>> myScheduleRef;
    private DesignerEditorPanel myEditorPanel;
    private static final WeakHashMap<AndroidFacet, SoftReference<ConfigurationManager>> ourConfigurationManagers = new WeakHashMap();
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI_KTX.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI_KTX.getCoordinate("+"));

    @TestOnly
    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(1);
        }
        this(project, null, parentDisposable);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable DesignerEditorPanel editorPanel2, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(3);
        }
        super(project, parentDisposable, surface2 -> new NavActionManager((NavDesignSurface)((Object)surface2)), NavInteractionHandler::new, NavDesignSurface.getDefaultSurfaceState(), true);
        this.myScheduleRef = new AtomicReference();
        this.setBackground((Color)JBColor.white);
        this.myEditorPanel = editorPanel2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavDesignSurface.this.removeComponentListener(this);
                NavDesignSurface.this.requestRender();
            }
        });
        this.getSelectionModel().addListener((SelectionModel unused, List<NlComponent> selection) -> this.updateCurrentNavigation(selection));
    }

    private static DesignSurface.State getDefaultSurfaceState() {
        AndroidEditorSettings.EditorMode preferredMode = AndroidEditorSettings.getInstance().getGlobalState().getPreferredEditorMode();
        if (preferredMode == null) {
            return DesignSurface.State.FULL;
        }
        switch (preferredMode) {
            case CODE: {
                return DesignSurface.State.DEACTIVATED;
            }
            case SPLIT: {
                return DesignSurface.State.SPLIT;
            }
        }
        return DesignSurface.State.FULL;
    }

    @Override
    public void dispose() {
        Future<?> future2 = this.getScheduleRef().get();
        if (future2 != null) {
            future2.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        Point2D.Float p2d;
        SceneComponent sceneComponent;
        Scene scene;
        NlComponent selection;
        if (dataId == null) {
            NavDesignSurface.$$$reportNull$$$0(4);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selection = this.getSelectionModel().getPrimary()) != null && NavComponentHelperKt.isAction(selection) && (scene = this.getScene()) != null && (sceneComponent = scene.getSceneComponent(selection)) != null && (p2d = NavActionHelperKt.getAnyPoint(sceneComponent, SceneContext.get(this.getFocusedSceneView()))) != null) {
            return new Point((int)p2d.x, (int)p2d.y);
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            NavDesignSurface.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public Rectangle getRenderableBoundsForInvisibleComponents(@NotNull SceneView sceneView, @Nullable Rectangle rectangle) {
        if (sceneView == null) {
            NavDesignSurface.$$$reportNull$$$0(6);
        }
        Rectangle viewRect = this.myScrollPane.getViewport().getViewRect();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setBounds(viewRect);
        Rectangle rectangle2 = rectangle;
        if (rectangle2 == null) {
            NavDesignSurface.$$$reportNull$$$0(7);
        }
        return rectangle2;
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            NavDesignSurface.$$$reportNull$$$0(8);
        }
        return new NavSceneManager(model2, this);
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(final NlModel model2) {
        model2.getConfiguration().getResourceResolver();
        final AndroidFacet facet2 = model2.getFacet();
        final CompletableFuture result2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet2)) {
                result2.complete(null);
            } else if (this.requestAddDependency(facet2)) {
                ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getSyncManager(this.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet2)) {
                                NavDesignSurface.this.showFailToAddMessage(result2, model2);
                            } else {
                                result2.complete(null);
                            }
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.this.showFailToAddMessage(result2, model2);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            } else {
                this.showFailToAddMessage(result2, model2);
            }
        });
        return result2;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        CompletableFuture<Void> future2 = super.setModel(model2);
        NavUsageTracker.Companion.getInstance(model2).createEvent(NavEditorEvent.NavEditorEventType.OPEN_FILE).withNavigationContents().log();
        return future2;
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result2, final @NotNull NlModel model2) {
        if (result2 == null) {
            NavDesignSurface.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            NavDesignSurface.$$$reportNull$$$0(10);
        }
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                @Override
                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                    if (result2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (NavDesignSurface.tryToCreateSchema(model2.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/surface/NavDesignSurface$3", "syncEnded"));
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.onFailedToAddDependency());
        result2.completeExceptionally(new Exception(FAILED_DEPENDENCY));
    }

    private void onFailedToAddDependency() {
        Messages.showErrorDialog((Project)this.getProject(), (String)FAILED_DEPENDENCY, (String)FAILED_DEPENDENCY_TITLE);
        if (this.myEditorPanel != null) {
            this.myEditorPanel.getWorkBench().loadingStopped(FAILED_DEPENDENCY);
        }
    }

    private boolean requestAddDependency(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            NavDesignSurface.$$$reportNull$$$0(11);
        }
        List<GradleCoordinate> dependencies2 = NavDesignSurface.getDependencies(facet2.getModule());
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> didAdd.set(DependencyManagementUtil.addDependencies(facet2.getModule(), dependencies2, true, false).isEmpty()));
        return didAdd.get();
    }

    @NotNull
    public static List<GradleCoordinate> getDependencies(@NotNull Module module) {
        if (module == null) {
            NavDesignSurface.$$$reportNull$$$0(12);
        }
        boolean isKotlin = AndroidStudioKotlinPluginUtils.hasKotlinFacet(module);
        if (MigrateToAndroidxUtil.isAndroidx(module.getProject())) {
            List<GradleCoordinate> list = isKotlin ? ANDROIDX_NAVIGATION_DEPENDENCIES_KTX : ANDROIDX_NAVIGATION_DEPENDENCIES;
            if (list == null) {
                NavDesignSurface.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<GradleCoordinate> list = isKotlin ? NAVIGATION_DEPENDENCIES_KTX : NAVIGATION_DEPENDENCIES;
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            NavDesignSurface.$$$reportNull$$$0(15);
        }
        Module module = facet2.getModule();
        return (Boolean)DumbService.getInstance((Project)module.getProject()).runReadActionInSmartMode(() -> {
            try {
                NavigationSchema.createIfNecessary(module);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    public void activate() {
        super.activate();
        NlModel model2 = this.getModel();
        if (model2 != null) {
            Module module = model2.getModule();
            try {
                NavigationSchema.createIfNecessary(module);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get(module);
            if (!schema.quickValidate()) {
                if (this.myEditorPanel == null) {
                    return;
                }
                this.myEditorPanel.getWorkBench().showLoading("Refreshing Navigators...");
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        schema.rebuildSchema().get();
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().hideLoading());
                    }
                    catch (Exception e) {
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().loadingStopped("Error refreshing Navigators"));
                    }
                });
            } else {
                schema.rebuildSchema();
            }
        }
    }

    @Override
    public void layoutContent() {
        this.requestRender();
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component3 -> new DnDTransferComponent(component3.getTagName(), component3.getTagDeprecated().getText(), 0, 0)).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (!this.validateCurrentNavigation().booleanValue()) {
            this.refreshRoot();
        }
        NlComponent nlComponent = this.myCurrentNavigation;
        if (nlComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(16);
        }
        return nlComponent;
    }

    private Boolean validateCurrentNavigation() {
        NlComponent current = this.myCurrentNavigation;
        if (current == null || current.getModel() != this.getModel()) {
            return false;
        }
        while (current.getParent() != null) {
            NlComponent parent = current.getParent();
            if (!parent.getChildren().contains(current)) {
                return false;
            }
            current = parent;
        }
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        assert (components.size() == 1);
        return current == components.get(0);
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        if (currentNavigation == null) {
            NavDesignSurface.$$$reportNull$$$0(17);
        }
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    @Nullable
    public Dimension getScrolledAreaSize() {
        Dimension dimension2 = new Dimension();
        SceneView view = this.getFocusedSceneView();
        if (view == null) {
            dimension2.setSize(0, 0);
            return dimension2;
        }
        return view.getSize(dimension2);
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(0, 0);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView view = this.getFocusedSceneView();
        if (view == null) {
            return new Dimension(0, 0);
        }
        SceneComponent root2 = view.getScene().getRoot();
        if (root2 == null) {
            return new Dimension(0, 0);
        }
        Rectangle boundingBox = NavSceneManagerKt.getBoundingBox(root2);
        Dimension dimension2 = boundingBox.getSize();
        if (dimension2 == null) {
            NavDesignSurface.$$$reportNull$$$0(18);
        }
        return dimension2;
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    protected double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    protected double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    @Override
    public boolean canZoomToFit() {
        return !this.isEmpty();
    }

    @Override
    protected double getFitScale(boolean fitInto) {
        return Math.min(super.getFitScale(fitInto), 1.0);
    }

    private boolean isEmpty() {
        NavSceneManager sceneManager = this.getSceneManager();
        return sceneManager == null || sceneManager.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component3) {
        VirtualFile virtualFile;
        PsiFile file;
        PsiClass psiClass;
        String className;
        NavEditorEvent.NavEditorEventType metricsEventType;
        String id;
        if (component3 == null) {
            NavDesignSurface.$$$reportNull$$$0(19);
        }
        if (this.myCurrentNavigation == component3) {
            return;
        }
        if (NavComponentHelperKt.isNavigation(component3)) {
            if (!NavComponentHelperKt.isInclude(component3)) {
                this.setCurrentNavigation(component3);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_NESTED).log();
                return;
            }
            id = component3.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_INCLUDE;
            if (id == null) {
                return;
            }
        } else {
            id = component3.getAttribute("http://schemas.android.com/tools", "layout");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_LAYOUT;
        }
        if (id != null) {
            VirtualFile virtualFile2;
            File file2;
            String fileName;
            Configuration configuration = (Configuration)Iterables.getOnlyElement(this.getConfigurations(), null);
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value2 = resolver != null ? resolver.findResValue(id, false) : null;
            String string = fileName = value2 != null ? value2.getValue() : null;
            if (fileName != null && (file2 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(metricsEventType).log();
                return;
            }
        }
        if ((className = component3.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file = psiClass.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
            NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_CLASS).log();
            return;
        }
        super.notifyComponentActivate(component3);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        Consumer<NlComponent> consumer = component3 -> NavComponentHelper.INSTANCE.registerComponent((NlComponent)component3);
        if (consumer == null) {
            NavDesignSurface.$$$reportNull$$$0(20);
        }
        return consumer;
    }

    @Override
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        if (type == null) {
            NavDesignSurface.$$$reportNull$$$0(21);
        }
        boolean scaled = super.zoom(type, x, y);
        if (type == ZoomType.FIT || type == ZoomType.FIT_INTO) {
            JViewport viewport = this.getScrollPane().getViewport();
            Rectangle bounds = viewport.getViewRect();
            Dimension size = viewport.getViewSize();
            viewport.setViewPosition(new Point((size.width - bounds.width) / 2, (size.height - bounds.height) / 2));
        }
        return scaled;
    }

    @NotNull
    public Dimension getExtentSize() {
        Dimension dimension2 = this.getScrollPane().getViewport().getExtentSize();
        if (dimension2 == null) {
            NavDesignSurface.$$$reportNull$$$0(22);
        }
        return dimension2;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(23);
        }
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManagerKt.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getScrollPane().getViewport().getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        Point start = new Point(swingStartCenterXInViewport, swingStartCenterYInViewport);
        Point end = new Point(swingViewportSize.width / 2, swingViewportSize.height / 2);
        LerpPoint lerpPoint = new LerpPoint(start, end, this.getScrollDurationMs());
        LerpDouble zoomLerp = new LerpDouble(view.getScale(), this.getFitScale(selectionBounds.getSize(), true), this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time2 = System.currentTimeMillis();
            Point pointSwingValue = (Point)lerpPoint.getValue(time2);
            int targetSwingX = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - pointSwingValue.x, targetSwingY - pointSwingValue.y);
            this.setScale((Double)zoomLerp.getValue(time2), targetSwingX, targetSwingY);
            if (lerpPoint.isComplete(time2)) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        AtomicReference<Future<?>> atomicReference = this.myScheduleRef;
        if (atomicReference == null) {
            NavDesignSurface.$$$reportNull$$$0(24);
        }
        return atomicReference;
    }

    @VisibleForTesting
    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return;
        }
        NlComponent match2 = (NlComponent)model2.getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component3 : model2.flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component3)) continue;
                if (component3 == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component3.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match2 = component3;
                    break;
                }
                if (includingParent || !Objects.equals(component3.getId(), this.myCurrentNavigation.getId())) continue;
                match2 = component3;
                NlComponent componentParent = component3.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        if (this.myCurrentNavigation != match2) {
            this.myCurrentNavigation = match2;
            this.getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.myCurrentNavigation));
        }
    }

    @Override
    @NotNull
    protected DesignSurfaceActionHandler createActionHandler() {
        return new NavDesignSurfaceActionHandler(this);
    }

    @Override
    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            NavDesignSurface.$$$reportNull$$$0(25);
        }
        SoftReference<ConfigurationManager> ref = ourConfigurationManagers.get(facet2);
        ConfigurationManager result2 = null;
        if (ref != null) {
            result2 = (ConfigurationManager)ref.get();
        }
        if (result2 == null) {
            result2 = new MyConfigurationManager(facet2.getModule());
            ourConfigurationManagers.put(facet2, (SoftReference<ConfigurationManager>)new SoftReference((Object)result2));
        }
        ConfigurationManager configurationManager = result2;
        if (configurationManager == null) {
            NavDesignSurface.$$$reportNull$$$0(26);
        }
        return configurationManager;
    }

    @Override
    protected boolean getSupportPinchAndZoom() {
        return false;
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlComponent root2 = this.getCurrentNavigation();
        List<NlComponent> list = root2.flatten().filter(component3 -> component3 == root2 || NavComponentHelperKt.isDestination(component3) && component3.getParent() == root2 || NavComponentHelperKt.isAction(component3) && (component3.getParent() == root2 || component3.getParent() != null && component3.getParent().getParent() == root2 || NavComponentHelperKt.getActionType(component3, root2) == ActionType.EXIT_DESTINATION)).collect(Collectors.toList());
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(27);
        }
        return list;
    }

    private void updateCurrentNavigation(@NotNull List<NlComponent> selection) {
        if (selection == null) {
            NavDesignSurface.$$$reportNull$$$0(28);
        }
        if (selection.size() != 1) {
            return;
        }
        NlComponent selected = selection.get(0);
        if (this.getSelectableComponents().contains(selected)) {
            return;
        }
        NlComponent next = selected.getParent();
        if (next == null) {
            next = selected;
        }
        while (next != null && !NavComponentHelperKt.isNavigation(next)) {
            next = next.getParent();
        }
        if (next != null) {
            this.setCurrentNavigation(next);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNavigation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forceUserRequestedRefresh";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderableBoundsForInvisibleComponents";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNavigation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentRegistrar";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtentSize";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheduleRef";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRenderableBoundsForInvisibleComponents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showFailToAddMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestAddDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateSchema";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentNavigation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentNavigation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConfigurationManager
    extends ConfigurationManager {
        MyConfigurationManager(@NotNull Module module) {
            if (module == null) {
                MyConfigurationManager.$$$reportNull$$$0(0);
            }
            super(module);
        }

        @Override
        public ConfigurationStateManager getStateManager() {
            return new ConfigurationStateManager();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/naveditor/surface/NavDesignSurface$MyConfigurationManager", "<init>"));
        }
    }
}

