/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AndroidModuleInfo
extends AndroidFacetScopedService {
    private static final Logger LOG = Logger.getInstance(AndroidModuleInfo.class);
    @VisibleForTesting
    static final Key<AndroidModuleInfo> KEY = Key.create((String)AndroidModuleInfo.class.getName());

    @NotNull
    public static AndroidModuleInfo getInstance(@NotNull AndroidFacet facet2) {
        AndroidModuleInfo androidModuleInfo;
        if (facet2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(0);
        }
        if ((androidModuleInfo = (AndroidModuleInfo)facet2.getUserData(KEY)) == null) {
            Module baseFeature;
            if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4 && (baseFeature = InstantApps.findBaseFeature(facet2)) != null) {
                androidModuleInfo = AndroidModuleInfo.getInstance(baseFeature);
            }
            if (androidModuleInfo == null) {
                androidModuleInfo = new AndroidModuleInfo(facet2);
            }
            facet2.putUserData(KEY, (Object)androidModuleInfo);
        }
        AndroidModuleInfo androidModuleInfo2 = androidModuleInfo;
        if (androidModuleInfo2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(1);
        }
        return androidModuleInfo2;
    }

    @Nullable
    public static AndroidModuleInfo getInstance(@NotNull Module module) {
        AndroidFacet facet2;
        if (module == null) {
            AndroidModuleInfo.$$$reportNull$$$0(2);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module)) != null ? AndroidModuleInfo.getInstance(facet2) : null;
    }

    @TestOnly
    public static void setInstanceForTest(@NotNull AndroidFacet facet2, @Nullable AndroidModuleInfo androidModuleInfo) {
        if (facet2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(3);
        }
        facet2.putUserData(KEY, (Object)androidModuleInfo);
    }

    private AndroidModuleInfo(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(4);
        }
        super(facet2);
    }

    public int getModuleMinApi() {
        return this.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public String getPackage() {
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return MergedManifestManager.getSnapshot(facet2).getApplicationId();
    }

    @NotNull
    private static <T> ListenableFuture<T> getFromMergedManifest(@NotNull AndroidFacet facet2, @NotNull Function<MergedManifestSnapshot, T> getter) {
        AsyncSupplier<MergedManifestSnapshot> manifestSupplier;
        MergedManifestSnapshot cachedManifest;
        if (facet2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(5);
        }
        if (getter == null) {
            AndroidModuleInfo.$$$reportNull$$$0(6);
        }
        if ((cachedManifest = (MergedManifestSnapshot)(manifestSupplier = MergedManifestManager.getMergedManifestSupplier(facet2.getModule())).getNow()) != null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)getter.apply((Object)cachedManifest));
            if (listenableFuture == null) {
                AndroidModuleInfo.$$$reportNull$$$0(7);
            }
            return listenableFuture;
        }
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)manifestSupplier.get(), getter, (Executor)SameThreadExecutor.INSTANCE);
        if (listenableFuture == null) {
            AndroidModuleInfo.$$$reportNull$$$0(8);
        }
        return listenableFuture;
    }

    @Deprecated
    @NotNull
    public AndroidVersion getRuntimeMinSdkVersionSynchronously() {
        AndroidVersion minSdkVersion2;
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null && (minSdkVersion2 = androidModel.getRuntimeMinSdkVersion()) != null) {
            AndroidVersion androidVersion = minSdkVersion2;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(9);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifestManager.getSnapshot(facet2).getMinSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(10);
        }
        return androidVersion;
    }

    @NotNull
    public ListenableFuture<AndroidVersion> getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion2;
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null && (minSdkVersion2 = androidModel.getRuntimeMinSdkVersion()) != null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)minSdkVersion2);
            if (listenableFuture == null) {
                AndroidModuleInfo.$$$reportNull$$$0(11);
            }
            return listenableFuture;
        }
        return AndroidModuleInfo.getFromMergedManifest(facet2, MergedManifestSnapshot::getMinSdkVersion);
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion2;
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null && (minSdkVersion2 = androidModel.getMinSdkVersion()) != null) {
            AndroidVersion androidVersion = minSdkVersion2;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(12);
            }
            return androidVersion;
        }
        if (AndroidManifestIndex.indexEnabled()) {
            AndroidVersion androidVersion;
            try {
                androidVersion = (AndroidVersion)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> AndroidManifestIndexQueryUtils.queryMinSdkAndTargetSdkFromManifestIndex(facet2).getMinSdk());
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
            }
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(13);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifestManager.getSnapshot(facet2).getMinSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(14);
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion2;
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null && (targetSdkVersion2 = androidModel.getTargetSdkVersion()) != null) {
            AndroidVersion androidVersion = targetSdkVersion2;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(15);
            }
            return androidVersion;
        }
        if (AndroidManifestIndex.indexEnabled()) {
            AndroidVersion androidVersion;
            try {
                androidVersion = (AndroidVersion)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> AndroidManifestIndexQueryUtils.queryMinSdkAndTargetSdkFromManifestIndex(facet2).getTargetSdk());
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
            }
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(16);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifestManager.getSnapshot(facet2).getTargetSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(17);
        }
        return androidVersion;
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        Boolean debuggable2;
        AndroidFacet facet2 = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null && (debuggable2 = androidModel.isDebuggable()) != null) {
            return debuggable2;
        }
        return MergedManifestManager.getSnapshot(facet2).getApplicationDebuggable();
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidModuleInfo.$$$reportNull$$$0(18);
        }
        facet2.putUserData(KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/AndroidModuleInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/AndroidModuleInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromMergedManifest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeMinSdkVersionSynchronously";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeMinSdkVersion";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setInstanceForTest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromMergedManifest";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

