/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.output;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Getter;

public class LogcatOutputSettings
implements Getter<LogcatOutputSettings> {
    private static final String LOGCAT_RUN_OUTPUT_ENABLED = "logcat.run.output.enabled";
    private static final boolean LOGCAT_RUN_OUTPUT_ENABLED_DEFAULT = true;
    private static final String LOGCAT_DEBUG_OUTPUT_ENABLED = "logcat.debug.output.enabled";
    private static final boolean LOGCAT_DEBUG_OUTPUT_ENABLED_DEFAULT = true;

    public static LogcatOutputSettings getInstance() {
        return (LogcatOutputSettings)ApplicationManager.getApplication().getService(LogcatOutputSettings.class);
    }

    public LogcatOutputSettings get() {
        return this;
    }

    public void reset() {
        PropertiesComponent.getInstance().unsetValue(LOGCAT_RUN_OUTPUT_ENABLED);
        PropertiesComponent.getInstance().unsetValue(LOGCAT_DEBUG_OUTPUT_ENABLED);
    }

    public boolean isRunOutputEnabled() {
        return PropertiesComponent.getInstance().getBoolean(LOGCAT_RUN_OUTPUT_ENABLED, true);
    }

    public void setRunOutputEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(LOGCAT_RUN_OUTPUT_ENABLED, enabled, true);
    }

    public boolean isDebugOutputEnabled() {
        return PropertiesComponent.getInstance().getBoolean(LOGCAT_DEBUG_OUTPUT_ENABLED, true);
    }

    public void setDebugOutputEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(LOGCAT_DEBUG_OUTPUT_ENABLED, enabled, true);
    }

    public String toString() {
        return String.format("LogcatOutputSettings{isRunOutputEnabled=%s, isDebugOutputEnabled=%s}", this.isRunOutputEnabled(), this.isDebugOutputEnabled());
    }
}

