/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackTraceExpander {
    private static final Pattern EXCEPTION_LINE_PATTERN = Pattern.compile("^\\s*(at .*\\(.*\\))$");
    private static final Pattern ELIDED_LINE_PATTERN = Pattern.compile("^\\s*... (\\d+) more$");
    private static final Pattern CAUSED_BY_LINE_PATTERN = Pattern.compile("^\\s*(Caused by:.*)$");
    private static final String EXPANDED_STACK_TRACE_MARKER = "\u00a0";
    @NotNull
    private final String myStackTracePrefix;
    @NotNull
    private final String myCauseLinePrefix;
    private List<String> myProcessedLines;
    private List<String> myCurrentStack;
    private List<String> myPreviousStack;
    private boolean myIsInTrace;

    public StackTraceExpander(@NotNull String stackTraceLinePrefix, @NotNull String stackTraceCauseLinePrefix) {
        if (stackTraceLinePrefix == null) {
            StackTraceExpander.$$$reportNull$$$0(0);
        }
        if (stackTraceCauseLinePrefix == null) {
            StackTraceExpander.$$$reportNull$$$0(1);
        }
        this.myProcessedLines = new ArrayList<String>();
        this.myCurrentStack = new ArrayList<String>();
        this.myPreviousStack = new ArrayList<String>();
        this.myStackTracePrefix = stackTraceLinePrefix;
        this.myCauseLinePrefix = stackTraceCauseLinePrefix;
        this.reset();
    }

    public void reset() {
        this.myIsInTrace = false;
        this.myProcessedLines.clear();
        this.myCurrentStack.clear();
        this.myPreviousStack.clear();
    }

    public static boolean wasLineExpanded(@NotNull String line) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(2);
        }
        return line.endsWith(EXPANDED_STACK_TRACE_MARKER) && line.contains(" at ");
    }

    @NotNull
    public List<String> process(@NotNull String line) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(3);
        }
        this.myProcessedLines.clear();
        String stackLine = StackTraceExpander.getStackLine(line);
        if (stackLine != null) {
            this.handleStackTraceLine(stackLine);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                StackTraceExpander.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (!this.myIsInTrace) {
            this.handleNormalLine(line);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                StackTraceExpander.$$$reportNull$$$0(5);
            }
            return list;
        }
        String causeLine = StackTraceExpander.getCauseLine(line);
        if (causeLine != null) {
            this.handleCausedByLine(causeLine);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                StackTraceExpander.$$$reportNull$$$0(6);
            }
            return list;
        }
        int elidedCount = StackTraceExpander.getElidedFrameCount(line);
        if (elidedCount > 0) {
            this.handleElidedLine(line, elidedCount);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                StackTraceExpander.$$$reportNull$$$0(7);
            }
            return list;
        }
        this.handleNormalLine(line);
        List<String> list = this.myProcessedLines;
        if (list == null) {
            StackTraceExpander.$$$reportNull$$$0(8);
        }
        return list;
    }

    @VisibleForTesting
    @Nullable
    static String getStackLine(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(9);
        }
        return (matcher = EXCEPTION_LINE_PATTERN.matcher(line)).matches() ? matcher.group(1) : null;
    }

    @VisibleForTesting
    @Nullable
    static String getCauseLine(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(10);
        }
        return (matcher = CAUSED_BY_LINE_PATTERN.matcher(line)).matches() ? matcher.group(1) : null;
    }

    @VisibleForTesting
    static int getElidedFrameCount(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(11);
        }
        return (matcher = ELIDED_LINE_PATTERN.matcher(line)).matches() ? StringUtil.parseInt((String)matcher.group(1), (int)-1) : -1;
    }

    private void handleNormalLine(@NotNull String line) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(12);
        }
        if (this.myIsInTrace) {
            this.myIsInTrace = false;
            this.myCurrentStack.clear();
            this.myPreviousStack.clear();
        }
        this.myProcessedLines.add(line);
    }

    private void handleStackTraceLine(@NotNull String line) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(13);
        }
        if (!this.myIsInTrace) {
            this.myIsInTrace = true;
        }
        this.myCurrentStack.add(line);
        this.myProcessedLines.add(this.myStackTracePrefix + line);
    }

    private void handleCausedByLine(@NotNull String line) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(14);
        }
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        List<String> temp = this.myPreviousStack;
        this.myPreviousStack = this.myCurrentStack;
        this.myCurrentStack = temp;
        this.myCurrentStack.clear();
        this.myProcessedLines.add(this.myCauseLinePrefix + line);
    }

    private void handleElidedLine(@NotNull String line, int elidedCount) {
        if (line == null) {
            StackTraceExpander.$$$reportNull$$$0(15);
        }
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        assert (elidedCount > 0);
        int startIndex = this.myPreviousStack.size() - elidedCount;
        if (startIndex >= 0) {
            for (int i2 = 0; i2 < elidedCount; ++i2) {
                String frame = this.myPreviousStack.get(startIndex + i2);
                this.myProcessedLines.add(this.myStackTracePrefix + frame + EXPANDED_STACK_TRACE_MARKER);
                this.myCurrentStack.add(frame);
            }
        } else {
            this.myProcessedLines.add(this.myStackTracePrefix + line);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceLinePrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceCauseLinePrefix";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/StackTraceExpander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/StackTraceExpander";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wasLineExpanded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStackLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCauseLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElidedFrameCount";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleNormalLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleStackTraceLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleCausedByLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleElidedLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

