/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.MessageFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LongMessageFormatter
implements MessageFormatter {
    private static final Pattern DATE_TIME = Pattern.compile("\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d.\\d\\d\\d");
    private static final Pattern HEADER_MESSAGE = Pattern.compile("^(" + DATE_TIME + ") +(" + PROCESS_ID + ")-(" + THREAD_ID + ")/(" + PACKAGE + ") (" + PRIORITY + ")/(" + TAG + "): (" + MESSAGE + ")$");

    LongMessageFormatter() {
    }

    @Override
    @NotNull
    public String format(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message2) {
        if (format == null) {
            LongMessageFormatter.$$$reportNull$$$0(0);
        }
        if (header == null) {
            LongMessageFormatter.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            LongMessageFormatter.$$$reportNull$$$0(2);
        }
        LogCatTimestamp dateTime = header.getTimestamp();
        String processIdThreadId = header.getPid() + "-" + header.getTid();
        Character priority = Character.valueOf(header.getLogLevel().getPriorityLetter());
        String tag = header.getTag().replace(' ', '\u00a0');
        String string = String.format(Locale.ROOT, format, dateTime, processIdThreadId, header.getAppName(), priority, tag, message2);
        if (string == null) {
            LongMessageFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public LogCatMessage tryParse(@NotNull String message2) {
        Matcher matcher;
        if (message2 == null) {
            LongMessageFormatter.$$$reportNull$$$0(4);
        }
        if (!(matcher = HEADER_MESSAGE.matcher(message2)).matches()) {
            return null;
        }
        Log.LogLevel priority = Log.LogLevel.getByLetterString((String)matcher.group(5));
        assert (priority != null);
        int processId = Integer.parseInt(matcher.group(2));
        int threadId = Integer.parseInt(matcher.group(3));
        String tag = matcher.group(6);
        LogCatTimestamp timestamp = LogCatTimestamp.fromString((String)matcher.group(1));
        LogCatHeader header = new LogCatHeader(priority, processId, threadId, matcher.group(4), tag, timestamp);
        return new LogCatMessage(header, matcher.group(7));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/LongMessageFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/LongMessageFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryParse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

